package cz.cuni.amis.pogamut.defcon.jason.action;

import static jason.asSyntax.ASSyntax.createNumber;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Term;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.jason.mainai.IJasonAI;

/**
 * Returns the distance between two points.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class getDistance extends AbstractInternalAction {

    @Override
	public Object executeWorker(TransitionSystem ts, Unifier un, Term[] args)
			throws Exception {
		// ts.getAg().getLogger().info("executing internal action 'getDistance'");

		final IJasonAI agent = getAgent(ts);
		if (agent == null)
			return false;

		if (args.length != 3) {
			return false;
		}

		if (!args[0].isLiteral() || !args[1].isLiteral() || !args[2].isVar()) {
			return false;
		}

		Literal locationALit = (Literal) args[0];
		Literal locationBLit = (Literal) args[1];
		
		if (!locationALit.getFunctor().equals("location")
				|| locationALit.getArity() != 2 ||
				!locationBLit.getFunctor().equals("location")
				|| locationBLit.getArity() != 2) {
			return false;
		}

		NumberTerm locationAXTerm = (NumberTerm) locationALit.getTerm(0);
		NumberTerm locationAYTerm = (NumberTerm) locationALit.getTerm(1);
		NumberTerm locationBXTerm = (NumberTerm) locationBLit.getTerm(0);
		NumberTerm locationBYTerm = (NumberTerm) locationBLit.getTerm(1);

		double ax = locationAXTerm.solve();
		double ay = locationAYTerm.solve();
		double bx = locationBXTerm.solve();
		double by = locationBYTerm.solve();

		DefConLocation locationA = new DefConLocation(ax, ay);
		DefConLocation locationB = new DefConLocation(bx, by);

		return un.unifies(
				args[2],
				createNumber(locationA.getDistance(locationB)));
    }
}
