/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import decisionMakingSystem.FreeTimeActivities;
import decisionMakingSystem.GlobalParameters;
import decisionMakingSystem.Intention;
import decisionMakingSystem.ScheduleEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import utils.Interval;
import utils.ScheduleEntryListWrapper;
import utils.TimeUtils;

public class Scheduler
implements Serializable {
    protected ArrayList<Intention> allIntentions = null;
    protected HashMap<String, Intention> nameToIntention = null;
    protected transient Logger log = null;
    private int day = 0;
    private int week = 0;
    private int dayOfWeek = 0;
    protected ArrayList<Interval> freeTime = null;
    protected ArrayList<Boolean> freePartsOfTheDay = null;
    protected ArrayList<Intention> daySchedule = null;
    protected ArrayList<ScheduleEntry> activityScheduling = null;
    protected ArrayList<ScheduleEntry> extraScheduling;
    protected Random rnd = null;
    protected int agentsAlarm = 400;

    public Scheduler(ArrayList<Intention> intentions, Logger log, String directory, String planningFilename) {
        this.allIntentions = intentions;
        this.nameToIntention = new HashMap();
        for (Intention intention : intentions) {
            this.nameToIntention.put(intention.getName(), intention);
        }
        this.log = log;
        this.freePartsOfTheDay = new ArrayList();
        this.freeTime = new ArrayList();
        this.daySchedule = new ArrayList();
        this.activityScheduling = this.loadPlanning(directory, planningFilename);
        this.rnd = new Random(System.currentTimeMillis());
    }

    public Scheduler() {
    }

    public ArrayList<Intention> scheduleNewDay(int counter) {
        for (Intention intention : this.nameToIntention.values()) {
            intention.setActivationIntervals(null);
        }
        this.daySchedule.clear();
        this.day = counter / GlobalParameters.LENGHT_OF_A_DAY;
        this.week = 0;
        this.dayOfWeek = this.day % 7 + 1;
        this.freeTime.clear();
        this.freePartsOfTheDay.clear();
        this.freePartsOfTheDay.add(true);
        this.freePartsOfTheDay.add(true);
        this.freePartsOfTheDay.add(true);
        this.scheduleBasicActions(counter);
        this.scheduleNormalActions();
        this.scheduleSpecialActions();
        this.scheduleOtherActions();
        return this.daySchedule;
    }

    protected void setLog(Logger log) {
        this.log = log;
    }

    private String printFreeTime() {
        String result = "";
        for (Interval interval : this.freeTime) {
            result = result + interval.toString() + " \n";
        }
        return result;
    }

    private void scheduleBasicActions(int start) {
        this.rnd.setSeed(System.currentTimeMillis());
        int dayBegins = start + TimeUtils.minutesToTicksOfLogic(this.agentsAlarm + this.rnd.nextInt(40));
        int dayEnds = start + TimeUtils.minutesToTicksOfLogic(1400 + this.rnd.nextInt(40));
        Intention sleep = this.nameToIntention.get("ISleep");
        Intention eat = this.nameToIntention.get("IEat");
        Intention hygiene = this.nameToIntention.get("IHygiene");
        ArrayList<Interval> activationIntervals = new ArrayList<Interval>();
        activationIntervals.add(new Interval(start, dayBegins, 30));
        sleep.setActivationIntervals(activationIntervals);
        activationIntervals = new ArrayList();
        activationIntervals.add(new Interval(dayBegins + TimeUtils.minutesToTicksOfLogic(5.0), dayBegins + TimeUtils.minutesToTicksOfLogic(15.0), 55));
        activationIntervals.add(new Interval(dayEnds - TimeUtils.minutesToTicksOfLogic(45.0), dayEnds - TimeUtils.minutesToTicksOfLogic(35.0), 55));
        hygiene.setActivationIntervals(activationIntervals);
        activationIntervals = new ArrayList();
        activationIntervals.add(new Interval(dayBegins + TimeUtils.minutesToTicksOfLogic(20.0), dayBegins + TimeUtils.minutesToTicksOfLogic(40.0), 60));
        int timeOfLunch = start + GlobalParameters.LENGHT_OF_A_DAY / 2 + TimeUtils.minutesToTicksOfLogic(this.rnd.nextInt(60) - 30);
        activationIntervals.add(new Interval(timeOfLunch, timeOfLunch + TimeUtils.minutesToTicksOfLogic(40.0), 60));
        int timeOfDinner = start + GlobalParameters.LENGHT_OF_A_DAY / 2 + GlobalParameters.LENGHT_OF_A_DAY / 4 + TimeUtils.minutesToTicksOfLogic(this.rnd.nextInt(60) - 90);
        activationIntervals.add(new Interval(timeOfDinner, timeOfDinner + TimeUtils.minutesToTicksOfLogic(40.0), 60));
        eat.setActivationIntervals(activationIntervals);
        this.freeTime.add(new Interval(dayBegins + TimeUtils.minutesToTicksOfLogic(60.0), timeOfLunch - TimeUtils.minutesToTicksOfLogic(15.0), 10));
        this.freeTime.add(new Interval(timeOfLunch + TimeUtils.minutesToTicksOfLogic(60.0), timeOfDinner - TimeUtils.minutesToTicksOfLogic(25.0), 10));
        this.freeTime.add(new Interval(timeOfDinner + TimeUtils.minutesToTicksOfLogic(55.0), dayEnds - TimeUtils.minutesToTicksOfLogic(60.0), 10));
        this.daySchedule.add(sleep);
        this.daySchedule.add(eat);
        this.daySchedule.add(hygiene);
        this.log.config("after BASIC ACTION: \n" + Scheduler.printIntentions(this.daySchedule));
    }

    private void scheduleNormalActions() {
        Intention intention = null;
        ArrayList<Interval> activationIntervals = null;
        boolean toAdd = false;
        int currentDay = this.dayOfWeek;
        for (ScheduleEntry entry : this.activityScheduling) {
            intention = null;
            toAdd = false;
            activationIntervals = null;
            for (int i = 0; i < 3; ++i) {
                if (!(entry.probabilityOfPerformance(currentDay, i + 1, this.week) >= this.rnd.nextDouble())) continue;
                if (activationIntervals == null) {
                    activationIntervals = new ArrayList<Interval>();
                }
                intention = this.nameToIntention.get(entry.intention);
                toAdd = true;
                this.addInterval(i, intention, activationIntervals);
            }
            if (!toAdd) continue;
            intention.setActivationIntervals(activationIntervals);
            this.daySchedule.add(intention);
        }
        this.log.config("after NORMAL ACTIONS: \n" + Scheduler.printIntentions(this.daySchedule));
    }

    private void addInterval(int index, Intention intention, ArrayList<Interval> activationIntervals) {
        Interval actInterval = null;
        Interval newFreeInterval = null;
        int temp = 0;
        temp = this.freeTime.get(index).getLeftSide();
        int activation = (int)((this.rnd.nextGaussian() + 1.0) * 20.0) + 25;
        activation = activation < 20 ? 20 : activation;
        actInterval = new Interval(temp, temp + intention.getTimeLimit(), activation);
        newFreeInterval = new Interval(temp + intention.getTimeLimit() + TimeUtils.minutesToTicksOfLogic(5.0), this.freeTime.get(index).getRightSide(), 0);
        activationIntervals.add(actInterval);
        this.freeTime.remove(index);
        this.freeTime.add(index, newFreeInterval);
    }

    private void scheduleOtherActions() {
        Intention intention = null;
        Interval interval = null;
        String name = null;
        ArrayList<Interval> activationIntervals = new ArrayList<Interval>();
        this.log.config("Free time: \n" + this.printFreeTime());
        this.rnd.setSeed(System.currentTimeMillis());
        for (int i = 0; i < this.freeTime.size(); ++i) {
            interval = this.freeTime.get(i);
            while (interval.getIntervalSize() > TimeUtils.minutesToTicksOfLogic(60.0)) {
                for (FreeTimeActivities trick : FreeTimeActivities.values()) {
                    name = trick.toString();
                    if (this.rnd.nextDouble() > 0.7) break;
                }
                intention = this.nameToIntention.get(name);
                intention.restrictTimeLimits(interval.getIntervalSize());
                if (intention.getActivationIntervals() == null) {
                    this.addInterval(i, intention, activationIntervals);
                    intention.setActivationIntervals(activationIntervals);
                } else {
                    this.addInterval(i, intention, intention.getActivationIntervals());
                }
                interval = this.freeTime.get(i);
                if (this.daySchedule.contains(intention)) continue;
                this.daySchedule.add(intention);
            }
        }
        this.log.info("after OTHER ACTIONS: \n" + Scheduler.printIntentions(this.daySchedule));
    }

    private void scheduleSpecialActions() {
    }

    private static void createFirstXMLEntry() {
        ScheduleEntryListWrapper list = new ScheduleEntryListWrapper();
        list.list.add(ScheduleEntry.getExample());
        list.list.add(ScheduleEntry.getExample());
        try {
            File file = new File("Plan.xml");
            FileOutputStream outputFile = new FileOutputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ScheduleEntryListWrapper.class});
            Marshaller m = context.createMarshaller();
            m.marshal((Object)list, (OutputStream)outputFile);
        }
        catch (Exception e) {
            System.err.println("Error in creating Plan.xml! " + e);
        }
    }

    private ArrayList<ScheduleEntry> loadPlanning(String directory, String filename) {
        File file = new File(directory + "config\\" + filename);
        ScheduleEntryListWrapper wrapper = null;
        try {
            FileInputStream reader = new FileInputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ScheduleEntryListWrapper.class});
            Unmarshaller u = context.createUnmarshaller();
            wrapper = (ScheduleEntryListWrapper)u.unmarshal((InputStream)reader);
        }
        catch (Exception e) {
            System.err.println("Error in loading " + filename + "\n" + e);
            this.log.severe("Error in loading " + filename + "\n" + e);
        }
        return wrapper.list;
    }

    private static String printIntentions(List<Intention> intentions) {
        String result = "";
        for (Intention intention : intentions) {
            result = result + intention.getName() + " " + intention.getActivationIntervals();
            result = result + "\n";
        }
        return result;
    }

    public void changeLifestyle(String directory, String planningFilename, int alarm) {
        this.activityScheduling.clear();
        this.activityScheduling = this.loadPlanning(directory, planningFilename);
        this.agentsAlarm = alarm;
    }
}

