/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import decisionMakingSystem.Action;
import decisionMakingSystem.ActionStates;
import decisionMakingSystem.Affordance;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.Concentration;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.GlobalParameters;
import decisionMakingSystem.Intention;
import decisionMakingSystem.ThingsManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public class PerceptiveField {
    public final ArrayList<Action> processArea;
    public ArrayList<EItem> memoryItems = null;
    public final ArrayList<EItem> perceivedItems;
    public ThingsManager allThings = null;
    public Logger log = null;
    public double stress = 0.0;
    public DecisionModuleImpl dModule = null;

    public PerceptiveField(Logger log, ThingsManager things, DecisionModuleImpl dModule) {
        this.log = log;
        this.memoryItems = new ArrayList();
        this.processArea = new ArrayList();
        this.perceivedItems = new ArrayList();
        this.allThings = things;
        this.dModule = dModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(Action action) {
        ArrayList<Action> arrayList = this.processArea;
        synchronized (arrayList) {
            for (Action act : this.processArea) {
                if (!act.equals(action)) continue;
                return;
            }
            this.processArea.add(action);
        }
        action.fadeout = GlobalParameters.FADEOUT_FOR_ACTIONS;
        if (action.intention != null) {
            action.activity = action.intention.getActivity();
            if (action.intention.getAncestorAction() != null) {
                action.intention.getAncestorAction().enabled = false;
            }
        }
    }

    public boolean isThingAssignedToAction(EItem item, Action action) {
        if (action == null || action.satisfyingItems == null) {
            return false;
        }
        for (AffordanceType af : action.satisfyingItems.keySet()) {
            if (action.satisfyingItems.get((Object)af) == null || !action.satisfyingItems.get((Object)af).equals(item)) continue;
            return true;
        }
        return false;
    }

    public boolean isAffordanceSatisfied(AffordanceType affordance, Action action) {
        if (action == null || action.satisfyingItems == null) {
            return false;
        }
        if (!action.satisfyingItems.containsKey((Object)affordance)) {
            return false;
        }
        return action.satisfyingItems.get((Object)affordance) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action chooseAction(int time) {
        ArrayList<Action> arrayList = this.processArea;
        synchronized (arrayList) {
            if (this.processArea.isEmpty()) {
                return null;
            }
        }
        Action chosenAction = this.findMaxActivity();
        if (chosenAction == null) {
            return null;
        }
        ++chosenAction.time;
        chosenAction.attention = Concentration.concentrationOnAction(chosenAction, time);
        return chosenAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSource(EItem item) {
        ArrayList<EItem> arrayList = this.perceivedItems;
        synchronized (arrayList) {
            if (!this.perceivedItems.contains(item)) {
                if (this.perceivedItems.size() > 10) {
                    int i = 0;
                    while (i < this.perceivedItems.size()) {
                        if (this.isThingAssignedToAction(item)) {
                            ++i;
                            continue;
                        }
                        this.perceivedItems.remove(i);
                    }
                }
                this.addItemToMemory(item, 1);
                this.perceivedItems.add(item);
            }
        }
        item.setFadeout(GlobalParameters.FADEOUT_FOR_ITEMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSource(EItem item) {
        boolean remove = false;
        AffordanceType keyOfRemoved = null;
        Action action = null;
        ArrayList<Cloneable> arrayList = this.processArea;
        synchronized (arrayList) {
            for (Action act : this.processArea) {
                if (!this.isThingAssignedToAction(item, act)) continue;
                for (AffordanceType aff : act.satisfyingItems.keySet()) {
                    for (Affordance itemAff : item.getAffordances()) {
                        if (itemAff == null || aff == null || !aff.equals((Object)itemAff.type)) continue;
                        remove = true;
                        keyOfRemoved = aff;
                        action = act;
                    }
                }
            }
        }
        if (remove) {
            action.satisfyingItems.remove((Object)keyOfRemoved);
        }
        arrayList = this.perceivedItems;
        synchronized (arrayList) {
            this.perceivedItems.remove(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSource() {
        EItem toRemove = null;
        int minAct = 101;
        int itemMin = 101;
        ArrayList<EItem> arrayList = this.perceivedItems;
        synchronized (arrayList) {
            for (EItem item : this.perceivedItems) {
                itemMin = 101;
                ArrayList<Action> arrayList2 = this.processArea;
                synchronized (arrayList2) {
                    for (Action act : this.processArea) {
                        if (!this.isThingAssignedToAction(item, act) || itemMin <= act.activity) continue;
                        itemMin = act.activity;
                    }
                }
                if (itemMin == 101) {
                    itemMin = 0;
                }
                if (itemMin >= minAct) continue;
                minAct = itemMin;
                toRemove = item;
            }
        }
        this.removeSource(toRemove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action findMaxActivity() {
        int maxActivity = 0;
        Action result = null;
        ArrayList<Action> arrayList = this.processArea;
        synchronized (arrayList) {
            for (Action act : this.processArea) {
                if (act.activity <= maxActivity || !act.enabled) continue;
                maxActivity = act.activity;
                result = act;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateActivities(int time) {
        int intentionActivity = 0;
        boolean changed = false;
        ArrayList<Action> arrayList = this.processArea;
        synchronized (arrayList) {
            for (Action act : this.processArea) {
                intentionActivity = 0;
                changed = false;
                if (!act.enabled) continue;
                if (act.intention != null) {
                    intentionActivity = act.intention.getActivity();
                } else {
                    for (AffordanceType aff : act.satisfyingItems.keySet()) {
                        if (act.satisfyingItems.get((Object)aff) == null || act.satisfyingItems.get((Object)aff).getAttractivity() <= intentionActivity) continue;
                        intentionActivity = act.satisfyingItems.get((Object)aff).getAttractivity();
                        changed = true;
                    }
                    if (!changed) {
                        intentionActivity = act.activity;
                    }
                }
                act.attention = Concentration.concentrationOnAction(act, time);
                act.intentionActivity = intentionActivity;
                act.activity = Math.max(act.attention, act.intentionActivity);
                act.activity = Math.max(act.activity, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFadeout() {
        boolean assigned = false;
        int index = 0;
        EItem item = null;
        ArrayList<EItem> arrayList = this.perceivedItems;
        synchronized (arrayList) {
            while (index < this.perceivedItems.size()) {
                assigned = false;
                item = this.perceivedItems.get(index);
                for (Action act : this.processArea) {
                    if (!this.isThingAssignedToAction(item, act)) continue;
                    assigned = true;
                }
                if (!assigned) {
                    item.setFadeout(item.getFadeout() - 1);
                }
                if (item.getFadeout() < 0) {
                    this.perceivedItems.remove(item);
                    continue;
                }
                ++index;
            }
        }
        Action act = null;
        ArrayList<Action> arrayList2 = this.processArea;
        synchronized (arrayList2) {
            index = 0;
            while (index < this.processArea.size()) {
                act = this.processArea.get(index);
                if (act.intention == null || act.activity <= 0) {
                    --act.fadeout;
                }
                if (act.fadeout < 0) {
                    this.removeFadeoutedAction(act);
                    act.state = ActionStates.FADOUT;
                    continue;
                }
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionsOfIntention(Intention temp) {
        int index = 0;
        Action action = null;
        ArrayList<Action> arrayList = this.processArea;
        synchronized (arrayList) {
            while (index < this.processArea.size()) {
                action = this.processArea.get(index);
                if (action.intention == null) {
                    ++index;
                    continue;
                }
                if (action.intention.equals(temp)) {
                    this.processArea.remove(index);
                    this.dModule.removeActionAndDescendantIntentions(action);
                    continue;
                }
                ++index;
            }
        }
    }

    private void addItemToMemory(EItem item, int i) {
        this.dModule.agent.itemMemory.addItemToMemory(item, this.dModule.counter, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EItem getPerceivedItemOfAffordance(AffordanceType affType) {
        ArrayList<EItem> arrayList = this.perceivedItems;
        synchronized (arrayList) {
            for (EItem item : this.perceivedItems) {
                for (Affordance aff : item.getAffordances()) {
                    if (!aff.type.equals((Object)affType)) continue;
                    return item;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProcessArea() {
        ArrayList<Action> arrayList = this.processArea;
        synchronized (arrayList) {
            this.processArea.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isThingAssignedToAction(EItem item) {
        ArrayList<Action> arrayList = this.processArea;
        synchronized (arrayList) {
            for (Action action : this.processArea) {
                if (action.satisfyingItems == null) continue;
                for (AffordanceType af : action.satisfyingItems.keySet()) {
                    if (action.satisfyingItems.get((Object)af) == null || !action.satisfyingItems.get((Object)af).equals(item)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    void setDMS(DecisionModuleImpl dms) {
        this.dModule = dms;
    }

    void setThings(ThingsManager things) {
        this.allThings = things;
    }

    private void removeFadeoutedAction(Action action) {
        this.dModule.removeActionAndDescendantIntentions(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAction(Action action) {
        ArrayList<Action> arrayList = this.processArea;
        synchronized (arrayList) {
            this.processArea.remove(action);
        }
        if (action.satisfyingItems == null) {
            return;
        }
        for (EItem item : action.satisfyingItems.values()) {
            if (item == null) continue;
            item.decreaseOfAttractivity = item.getBasicAttractivity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAttractivity() {
        EItem item = null;
        int tempAttr = 0;
        boolean assigned = false;
        int affAttractivity = 0;
        if (this.allThings.visibleItems.isEmpty()) {
            return;
        }
        HashMap<Long, EItem> hashMap = this.allThings.visibleItems;
        synchronized (hashMap) {
            for (Long itemID : this.allThings.visibleItems.keySet()) {
                affAttractivity = 0;
                item = this.allThings.visibleItems.get(itemID);
                for (Affordance aff : item.getAffordances()) {
                    if (this.perceivedItems.contains(item)) {
                        assigned = false;
                        ArrayList<Action> arrayList = this.processArea;
                        synchronized (arrayList) {
                            for (Action act : this.processArea) {
                                if (act.satisfyingItems == null || !act.satisfyingItems.containsKey((Object)aff.type)) continue;
                                assigned = true;
                            }
                            if (!assigned) {
                                aff.attractivity = 0;
                            }
                        }
                    }
                    if (affAttractivity >= aff.attractivity) continue;
                    affAttractivity = aff.attractivity;
                }
                if (item.decreaseOfAttractivity > 0 && !this.perceivedItems.contains(item)) {
                    --item.decreaseOfAttractivity;
                }
                if ((tempAttr = item.getBasicAttractivity() - item.decreaseOfAttractivity + affAttractivity) > 100) {
                    tempAttr = 100;
                }
                item.setAttractivity(tempAttr);
            }
        }
    }

    public void increaseAttractivityToAllSources(Action action) {
        if (action.intention != null && action.activity > 0 && action.satisfyingItems != null) {
            ArrayList<EItem> items = null;
            for (AffordanceType aff : action.satisfyingItems.keySet()) {
                items = this.allThings.getItemOfAffordance(aff);
                for (EItem item : items) {
                    item.changeAffordaceActivity(action.activity, aff);
                }
            }
        }
        this.updateAttractivity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double stressLevel() {
        double result = 0.0;
        double temp = 0.0;
        ArrayList<Action> arrayList = this.processArea;
        synchronized (arrayList) {
            for (Action act : this.processArea) {
                if (!act.enabled) continue;
                temp += (double)(act.activity / 100);
            }
        }
        result = (1.0 - Math.exp(temp)) / (1.0 + Math.exp(temp));
        this.dModule.agentParameters.updateCoeficients(result);
        return result;
    }

    public void updateStress() {
        this.stress = this.stressLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printPerceivedItems() {
        String result = "Perceived Items. Number of items: " + this.perceivedItems.size() + "\n";
        ArrayList<EItem> arrayList = this.perceivedItems;
        synchronized (arrayList) {
            for (EItem item : this.perceivedItems) {
                result = result + item.name + " attractivity: " + item.getAttractivity();
                result = result + " Affordances: ";
                for (Affordance affo : item.getAffordances()) {
                    result = result + (Object)((Object)affo.type) + " " + affo.counter + " " + affo.attractivity + "\t";
                }
                result = result + "\n";
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasDerivedAction(Intention actualIntention) {
        ArrayList<Action> arrayList = this.processArea;
        synchronized (arrayList) {
            for (Action act : this.processArea) {
                if (act.intention == null || !act.intention.equals(actualIntention)) continue;
                return true;
            }
        }
        return false;
    }

    public void satisfyAffordance(Action action, AffordanceType af, EItem item) {
        if (action.satisfyingItems.containsKey((Object)af) && action.satisfyingItems.get((Object)af) == null) {
            this.log.fine("Satisfying affordance: " + (Object)((Object)af) + " by item: " + item);
            action.satisfyingItems.put(af, item);
            this.addItemToMemory(item, 0);
        }
    }
}

