/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import decisionMakingSystem.Action;
import decisionMakingSystem.DMSModuleViewerInfo;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.GlobalParameters;
import decisionMakingSystem.Intention;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ToolTipManager;
import javax.swing.table.DefaultTableModel;
import utils.Interval;

public class DMSModuleViewer
extends JFrame {
    private DecisionModuleImpl module = null;
    private JTable intArea = null;
    private DefaultTableModel intAreaModel = null;
    private JScrollPane intAreaSP = null;
    private JTable actArea = null;
    private DefaultTableModel actAreaModel = null;
    private JScrollPane actAreaSP = null;
    private JTable items = null;
    private DefaultTableModel itemsModel = null;
    private JScrollPane itemsSP = null;
    private JTable dayPlan = null;
    private DefaultTableModel dayPlanModel = null;
    private JScrollPane dayPlanSP = null;
    private Vector intAreaColNames = new Vector();
    private Vector actAreaColNames = new Vector();
    private Vector dayPlanColNames = new Vector();
    private Vector itemsColNames = new Vector();
    private JPanel infoPanel = null;

    public DMSModuleViewer(DecisionModuleImpl module) {
        this.module = module;
        this.setTitle("DMS Module viewer");
        this.setSize(640, 480);
        this.setVisible(true);
        this.initializeTables();
        this.updateTables();
        this.initializeInformationPanel();
        this.initComponents();
    }

    public void update() {
        this.updateTables();
        this.repaint();
        this.infoPanel.repaint();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        GroupLayout infoPanelLayout = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(infoPanelLayout);
        infoPanelLayout.setHorizontalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        infoPanelLayout.setVerticalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(10).addGroup(layout.createSequentialGroup().addComponent(this.intAreaSP, -2, 250, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actAreaSP, -1, 250, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.dayPlanSP, -2, 250, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.itemsSP, -1, 250, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.infoPanel, -2, 250, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(10).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.intAreaSP, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addGap(10).addComponent(this.actAreaSP, GroupLayout.Alignment.LEADING, -1, 200, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.dayPlanSP, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addGap(10).addComponent(this.itemsSP, GroupLayout.Alignment.LEADING, -1, 200, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.infoPanel, GroupLayout.Alignment.LEADING, -1, 200, Short.MAX_VALUE))));
        this.pack();
    }

    private void initializeInformationPanel() {
        this.infoPanel = new DMSModuleViewerInfo(this.module);
        this.add(this.infoPanel);
    }

    private void initializeTables() {
        int firstColumnWidth = 150;
        int secondColumnWidth = 25;
        int thirdColumnWidth = 25;
        this.intAreaColNames.add("Name");
        this.intAreaColNames.add("Act");
        this.intAreaColNames.add("Parent");
        this.intAreaModel = new DefaultTableModel(null, this.intAreaColNames);
        this.intArea = new JTable(this.intAreaModel);
        this.intArea.setAutoCreateRowSorter(true);
        this.intArea.getColumnModel().getColumn(0).setPreferredWidth(firstColumnWidth);
        this.intArea.getColumnModel().getColumn(1).setPreferredWidth(secondColumnWidth);
        this.intArea.getColumnModel().getColumn(2).setPreferredWidth(thirdColumnWidth);
        this.intAreaSP = new JScrollPane();
        this.intAreaSP.setViewportView(this.intArea);
        this.intAreaSP.setBounds(0, 0, 400, 250);
        ToolTipManager.sharedInstance().unregisterComponent(this.intArea);
        ToolTipManager.sharedInstance().unregisterComponent(this.intArea.getTableHeader());
        this.actAreaColNames.add("Name");
        this.actAreaColNames.add("Act");
        this.actAreaColNames.add("Activity");
        this.actAreaModel = new DefaultTableModel(null, this.actAreaColNames);
        this.actArea = new JTable(this.actAreaModel);
        this.actArea.setAutoCreateRowSorter(true);
        this.actArea.getColumnModel().getColumn(0).setPreferredWidth(firstColumnWidth);
        this.actArea.getColumnModel().getColumn(1).setPreferredWidth(secondColumnWidth);
        this.actArea.getColumnModel().getColumn(2).setPreferredWidth(thirdColumnWidth);
        this.actAreaSP = new JScrollPane();
        this.actAreaSP.setViewportView(this.actArea);
        this.actAreaSP.setBounds(0, 0, 400, 250);
        ToolTipManager.sharedInstance().unregisterComponent(this.actArea);
        ToolTipManager.sharedInstance().unregisterComponent(this.actArea.getTableHeader());
        this.itemsColNames.add("Name");
        this.itemsColNames.add("Att");
        this.itemsColNames.add("Perc");
        this.itemsModel = new DefaultTableModel(null, this.itemsColNames);
        this.items = new JTable(this.itemsModel);
        this.items.setAutoCreateRowSorter(true);
        this.items.getColumnModel().getColumn(0).setPreferredWidth(firstColumnWidth);
        this.items.getColumnModel().getColumn(1).setPreferredWidth(secondColumnWidth);
        this.items.getColumnModel().getColumn(2).setPreferredWidth(thirdColumnWidth);
        this.itemsSP = new JScrollPane();
        this.itemsSP.setViewportView(this.items);
        this.itemsSP.setBounds(0, 0, 400, 250);
        ToolTipManager.sharedInstance().unregisterComponent(this.items);
        ToolTipManager.sharedInstance().unregisterComponent(this.items.getTableHeader());
        this.dayPlanColNames.add("Name");
        this.dayPlanColNames.add("Interval");
        this.dayPlanColNames.add("XY");
        this.dayPlanModel = new DefaultTableModel(null, this.dayPlanColNames);
        this.dayPlan = new JTable(this.dayPlanModel);
        this.dayPlan.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.dayPlan.getColumnModel().getColumn(1).setPreferredWidth(125);
        this.dayPlan.getColumnModel().getColumn(2).setPreferredWidth(25);
        this.dayPlanSP = new JScrollPane();
        this.dayPlanSP.setViewportView(this.dayPlan);
        this.dayPlanSP.setBounds(0, 0, 400, 250);
        ToolTipManager.sharedInstance().unregisterComponent(this.dayPlan);
        ToolTipManager.sharedInstance().unregisterComponent(this.dayPlan.getTableHeader());
    }

    private void initializeTableModels() {
        Vector intAreaValues = this.transformIntentions(this.module.intentionArea);
        this.intAreaModel = new DefaultTableModel(intAreaValues, this.intAreaColNames);
        Vector actAreaValues = this.transformActions(this.module.perceptiveField.processArea);
        this.actAreaModel = new DefaultTableModel(actAreaValues, this.actAreaColNames);
        Vector itemsValues = this.transformItems(this.module.things.visibleItems);
        this.itemsModel = new DefaultTableModel(itemsValues, this.itemsColNames);
        this.module.log.info("initialized tables 1..3");
        if (this.module.basicIntentions == null) {
            return;
        }
        Vector dayPlanValues = this.transformDayPlan(this.module.basicIntentions, this.module.counter);
        this.dayPlanModel = new DefaultTableModel(dayPlanValues, this.dayPlanColNames);
        this.module.log.info("initialized table 4");
    }

    private boolean isItemPerceived(EItem item) {
        return this.module.perceptiveField.perceivedItems.contains(item);
    }

    private Vector transformIntentions(ArrayList<Intention> intentions) {
        Vector<String> result = new Vector<String>(3 * intentions.size());
        int index = 0;
        for (Intention i : intentions) {
            result.add(index++, new String(i.getName()));
            result.add(index++, new String(Integer.toString(i.getActivity())));
            if (i.getAncestorAction() != null && i.getAncestorAction().name != null) {
                result.add(index++, new String(i.getAncestorAction().name));
                continue;
            }
            result.add(index++, "None" + i);
        }
        return result;
    }

    private Vector transformActions(ArrayList<Action> actions) {
        Vector<String> result = new Vector<String>(3 * actions.size());
        int index = 0;
        for (Action a : actions) {
            result.add(index++, new String(a.name));
            result.add(index++, new String(Integer.toString(a.activity)));
            result.add(index++, new String(Integer.toString(a.attention)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector transformItems(HashMap<Long, EItem> items) {
        Vector<Object> result = new Vector<Object>(3 * items.values().size());
        int index = 0;
        HashMap<Long, EItem> hashMap = items;
        synchronized (hashMap) {
            for (EItem a : items.values()) {
                result.add(index++, new String(a.name));
                result.add(index++, new String(Integer.toString(a.getAttractivity())));
                result.add(index++, this.isItemPerceived(a));
            }
        }
        return result;
    }

    private Vector transformDayPlan(ArrayList<Intention> plan, int counter) {
        Vector<String> result = new Vector<String>(3 * plan.size());
        int index = 0;
        int distance = GlobalParameters.LENGHT_OF_A_DAY;
        Interval toShow = null;
        for (Intention i : plan) {
            result.add(index++, new String(i.getName()));
            toShow = null;
            distance = GlobalParameters.LENGHT_OF_A_DAY;
            for (Interval intr : i.getActivationIntervals()) {
                if (intr.isInInterval(counter)) {
                    toShow = intr;
                    break;
                }
                int tmp = (intr.getLeftSide() + intr.getRightSide()) / 2;
                if ((tmp = Math.abs(tmp - counter)) >= distance) continue;
                distance = tmp;
                toShow = intr;
            }
            if (toShow != null) {
                result.add(index++, new String(toShow.toString()));
            } else {
                result.add(index++, "None");
            }
            result.add(index++, new String(Integer.toString(i.getActivity())));
        }
        return result;
    }

    private void updateTables() {
        Vector intAreaValues = this.transformIntentions(this.module.intentionArea);
        this.actualizeTable(this.intArea, intAreaValues);
        Vector actAreaValues = this.transformActions(this.module.perceptiveField.processArea);
        this.actualizeTable(this.actArea, actAreaValues);
        Vector itemsValues = this.transformItems(this.module.things.visibleItems);
        this.actualizeTable(this.items, itemsValues);
        if (this.module.basicIntentions == null) {
            return;
        }
        Vector dayPlanValues = this.transformDayPlan(this.module.basicIntentions, this.module.counter);
        this.actualizeTable(this.dayPlan, dayPlanValues);
    }

    private void actualizeTable(JTable table, Vector newValues) {
        int j;
        int i;
        int rows = table.getRowCount();
        int[] subIndices = new int[rows];
        boolean substitute = false;
        for (i = 0; i < rows; ++i) {
            if (table.getValueAt(i, 0) == null) {
                subIndices[i] = 1;
                continue;
            }
            substitute = true;
            for (j = 0; j < newValues.size() / 3; ++j) {
                if (newValues.get(j * 3) == null || !table.getValueAt(i, 0).equals(newValues.get(j * 3))) continue;
                subIndices[i] = 0;
                if (!table.getValueAt(i, 1).equals(newValues.get(j * 3 + 1))) {
                    table.setValueAt(newValues.get(j * 3 + 1), i, 1);
                }
                if (!table.getValueAt(i, 1).equals(newValues.get(j * 3 + 2))) {
                    table.setValueAt(newValues.get(j * 3 + 2), i, 2);
                }
                substitute = false;
                newValues.remove(j * 3);
                newValues.remove(j * 3);
                newValues.remove(j * 3);
                break;
            }
            if (!substitute) continue;
            subIndices[i] = 1;
        }
        j = 0;
        for (i = 0; i < table.getRowCount(); ++i) {
            if (subIndices[i] == 0) continue;
            if (newValues.isEmpty()) {
                if (table.getValueAt(i, 0) != null) {
                    table.setValueAt(null, i, 0);
                }
                if (table.getValueAt(i, 1) != null) {
                    table.setValueAt(null, i, 1);
                }
                if (table.getValueAt(i, 2) == null) continue;
                table.setValueAt(null, i, 2);
                continue;
            }
            table.setValueAt(newValues.get(0), i, 0);
            table.setValueAt(newValues.get(1), i, 1);
            table.setValueAt(newValues.get(2), i, 2);
            newValues.remove(0);
            newValues.remove(0);
            newValues.remove(0);
        }
        for (j = 0; j < newValues.size() / 3; ++j) {
            ((DefaultTableModel)table.getModel()).addRow(newValues.subList(j * 3, j * 3 + 3).toArray());
        }
    }
}

