/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import atomicActions.AtomicAction;
import atomicActions.SayHello;
import decisionMakingSystem.ActionStates;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.BasicIntentionLoader;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.GlobalParameters;
import decisionMakingSystem.Intention;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlRootElement;
import pogamutEndEvent.PogamutEndEventType;
import utils.DeepCopyCreator;

@XmlRootElement
public class Action
implements Cloneable,
Serializable {
    public Intention intention = null;
    public ArrayList<Intention> intentions = null;
    public int unfullfiledIntentionsIndex = 0;
    public String name = null;
    public final HashMap<AffordanceType, EItem> satisfyingItems = new HashMap();
    public ArrayList<AtomicAction> atomicActions = null;
    public int atomicActionsIndex = 0;
    public int activity = 0;
    public int intentionActivity = 0;
    public boolean enabled = true;
    public int timeLimit = 0;
    public double realTimeLimit = 0.0;
    public int fadeout = 0;
    public int start = 0;
    public int duration = 0;
    public int time = 0;
    ActionStates state = ActionStates.PRESTATE;
    public int attention;
    public int attractivity = 0;

    public Action() {
        this.fadeout = GlobalParameters.FADEOUT_FOR_ACTIONS;
    }

    public Action(HashSet<AffordanceType> affos) {
        this.fadeout = GlobalParameters.FADEOUT_FOR_ACTIONS;
        Iterator<AffordanceType> it = affos.iterator();
        while (it.hasNext()) {
            this.satisfyingItems.put(it.next(), null);
        }
    }

    public String toString() {
        String result = "ACTION: " + this.name + " | | ";
        result = result + "Activity: " + this.activity + " | | " + "Duration: " + this.duration + " | | ";
        result = result + "Fadeout: " + this.fadeout + " | | " + "Enabled: " + this.enabled + " | | ";
        result = result + "Attention: " + this.attention + " | | " + "Time: " + this.time + " | | ";
        result = result + "Time limit: " + this.timeLimit + " | | " + "State: " + (Object)((Object)this.state) + " | | ";
        if (this.intention != null) {
            result = result + " Parent intention name: " + this.intention.getName() + " | | ";
        }
        if (this.intentions != null && !this.intentions.isEmpty()) {
            result = result + " Intentions: ";
            for (Intention i : this.intentions) {
                result = result + i.getName() + " ";
            }
            result = result + " INDEX: " + this.unfullfiledIntentionsIndex + " | | ";
        }
        if (this.atomicActions != null && !this.atomicActions.isEmpty()) {
            result = result + " Atomic actions size: " + this.atomicActions.size() + " Actions: ";
            for (AtomicAction act : this.atomicActions) {
                result = result + (Object)((Object)act.type) + " ";
            }
            result = result + " INDEX: " + this.atomicActionsIndex + " | | ";
        }
        if (this.satisfyingItems != null && !this.satisfyingItems.isEmpty()) {
            result = result + " Satisfying affordancese: ";
            for (AffordanceType aff : this.satisfyingItems.keySet()) {
                if (this.satisfyingItems.get((Object)aff) != null) {
                    result = result + " aff: " + (Object)((Object)aff) + " item: " + this.satisfyingItems.get((Object)((Object)aff)).classOfItem + " | | ";
                    continue;
                }
                result = result + " aff: " + (Object)((Object)aff) + " item: none ";
            }
            result = result + " | | ";
        }
        return result + "\n";
    }

    public Intention chooseIntention() {
        Intention result = null;
        if (this.intentions == null) {
            return null;
        }
        if (this.unfullfiledIntentionsIndex < this.intentions.size()) {
            result = this.intentions.get(this.unfullfiledIntentionsIndex);
            result.setActivity(this.activity);
        }
        if (result != null) {
            result.setAncestorAction(this);
        }
        return result;
    }

    public Intention getCurrentIntention() {
        if (this.intentions == null) {
            return null;
        }
        if (this.intentions.size() > this.unfullfiledIntentionsIndex) {
            return this.intentions.get(this.unfullfiledIntentionsIndex);
        }
        return null;
    }

    public boolean isSpontaneous() {
        return this.intention == null;
    }

    public AtomicAction getCurrentAtomicAction() {
        if (this.atomicActions == null) {
            return null;
        }
        if (this.atomicActions.size() > this.atomicActionsIndex) {
            return this.atomicActions.get(this.atomicActionsIndex);
        }
        return null;
    }

    public void moveToNextAtomicAction() {
        ++this.atomicActionsIndex;
    }

    public AtomicAction executeAtomicActions(Logger log) {
        if (this == null || this.state == null || this.state.equals((Object)ActionStates.FAILED) || this.state.equals((Object)ActionStates.TERMINATED)) {
            log.warning("Execute atomic actions called on null, failed or terminated action:");
            return null;
        }
        AtomicAction act = this.getCurrentAtomicAction();
        if (act != null && act.checkIfOnThePlace()) {
            act.execute();
        }
        if (act != null && act.succeeded()) {
            this.moveToNextAtomicAction();
            if (this.getCurrentAtomicAction() == null) {
                this.state = ActionStates.TERMINATED;
            }
        } else if (act != null && act.failed()) {
            this.state = ActionStates.FAILED;
            if (!act.type.toString().contains("SEARCH_")) {
                log.info("Atomic action " + (Object)((Object)act.type) + " failed");
            }
        }
        if (act != null) {
            act.agent.getDecisions().eventSource.fireEvent(PogamutEndEventType.ATOMIC_ACTION_EXECUTED, act);
            act.agent.getDecisions().eventSource.fireEvent(PogamutEndEventType.VISIBLE_OBJECTS, this);
        }
        return act;
    }

    public Action cloneBySerialize(DecisionModuleImpl dModule) {
        Action result = (Action)DeepCopyCreator.copy(this);
        ArrayList<Action> actionsWithAtomicActions = new ArrayList<Action>();
        if (result.atomicActions != null) {
            actionsWithAtomicActions.add(result);
        }
        if (result.intentions != null) {
            for (Intention intent : result.intentions) {
                actionsWithAtomicActions.addAll(BasicIntentionLoader.getActionsWithAtomicActions(intent));
            }
        }
        for (Action action : actionsWithAtomicActions) {
            for (AtomicAction aAction : action.atomicActions) {
                aAction.agent = dModule.agent;
                aAction.dModule = dModule;
            }
        }
        return result;
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof Action)) {
            return false;
        }
        Action that = (Action)aThat;
        if (this.timeLimit != that.timeLimit) {
            return false;
        }
        if (this.start != that.start) {
            return false;
        }
        if (this.unfullfiledIntentionsIndex != that.unfullfiledIntentionsIndex) {
            return false;
        }
        if (this.satisfyingItems != null || that.satisfyingItems != null) {
            if (this.satisfyingItems == null || this.satisfyingItems == null) {
                return false;
            }
            if (!this.satisfyingItems.equals(that.satisfyingItems)) {
                return false;
            }
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int hash = 5;
        hash = 7 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 7 * hash + (this.satisfyingItems != null ? this.satisfyingItems.hashCode() : 0);
        hash = 7 * hash + this.timeLimit;
        return hash;
    }

    public static Action exampleAction() {
        Action result = new Action();
        SayHello aAction = new SayHello(result, null);
        SayHello aAction2 = new SayHello(result, null);
        result.name = "My little action";
        result.atomicActions = new ArrayList();
        result.atomicActions.add(aAction);
        result.atomicActions.add(aAction2);
        result.intentions = new ArrayList();
        result.state = ActionStates.PRESTATE;
        Intention intention1 = new Intention();
        Intention intention2 = new Intention();
        result.intentions.add(intention1);
        result.intentions.add(intention2);
        EItem item1 = EItem.exampleItem();
        EItem item2 = new EItem();
        result.satisfyingItems.put(AffordanceType.TO_CLEAN, item1);
        return result;
    }
}

