/*
 * Decompiled with CFR 0.152.
 */
package bot;

import bot.Actions;
import bot.InterfacePerform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class ActionManager
implements Serializable {
    private List<InterfacePerform> everyHourActions = new ArrayList<InterfacePerform>();
    private List<InterfacePerform> everyDayActions = new ArrayList<InterfacePerform>();

    public void doEveryHourActions(String path, int day, int hour) {
        for (InterfacePerform perform : this.everyHourActions) {
            perform.perform(path, day, hour);
        }
    }

    public void doEveryDayActions(int day) {
        for (InterfacePerform perform : this.everyDayActions) {
            perform.perform(day);
        }
    }

    public void addHourAction(InterfacePerform perform) {
        this.everyHourActions.add(perform);
    }

    public void addDayAction(InterfacePerform perform) {
        this.everyDayActions.add(perform);
    }

    public void removeDayAction(Actions action) {
        int i = 0;
        while (i < this.everyDayActions.size()) {
            if (this.everyDayActions.get(i).identification().equals((Object)action)) {
                this.everyDayActions.remove(this.everyDayActions.get(i));
                continue;
            }
            ++i;
        }
    }

    public void removeHourAction(Actions action) {
        int i = 0;
        while (i < this.everyHourActions.size()) {
            if (this.everyHourActions.get(i).identification().equals((Object)action)) {
                this.everyHourActions.remove(this.everyHourActions.get(i));
                continue;
            }
            ++i;
        }
    }

    void cleanUp() {
        for (InterfacePerform perform : this.everyHourActions) {
            perform.cleanUp();
        }
        for (InterfacePerform perform : this.everyDayActions) {
            perform.cleanUp();
        }
    }
}

