/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import atomicActions.AtomicAction;
import atomicActions.AtomicActions;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import decisionMakingSystem.Action;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.AgentParameters;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.ItemRecord;
import decisionMakingSystem.SearchMemory;
import java.util.ArrayList;
import java.util.Collections;

class AtomicSearchMemory
extends AtomicAction {
    private ArrayList<ItemRecord> itemRecords = null;
    private ItemRecord probe = null;
    private int index = 0;
    private EItem item = null;
    private AffordanceType affType = null;
    DecisionModuleImpl module;

    public AtomicSearchMemory(Action parent, DecisionModuleImpl module) {
        this.parent = parent;
        this.agent = module.agent;
        this.module = module;
        this.type = AtomicActions.SEARCH_MEMORY;
        this.dModule = module;
    }

    private ItemRecord getNextLocation() {
        if (this.itemRecords == null || this.index >= this.itemRecords.size()) {
            return null;
        }
        ItemRecord result = this.itemRecords.get(this.index);
        ++this.index;
        if (result == null) {
            return null;
        }
        if (result.probability > AgentParameters.biasProbability && this.index < AgentParameters.numberOfTriedPlacesInMemory) {
            return result;
        }
        return null;
    }

    @Override
    public void execute() {
        if (this.counter == 0) {
            this.initialisation();
        }
        this.counter = this.agent.getCurrentTime();
        this.agent.getLog().warning("AFFTYPE: " + this.affType.toString());
        this.item = this.module.perceptiveField.getPerceivedItemOfAffordance(this.affType);
        if (this.item == null) {
            this.item = this.module.things.seeingItem(this.affType);
        } else if (this.agent.getSeeItem(this.item.getId()) != null) {
            this.agent.getAct().act((CommandMessage)new Move().setFirstLocation(this.item.getLocation()));
        } else if (this.item.getLocation() != null) {
            this.agent.safeRunToLocation(this.item.getLocation());
            return;
        }
        if (this.probe == null) {
            this.probe = this.getNextLocation();
        } else if (this.agent.getLocation() != null && this.agent.getLocation().getDistance(this.probe.location) < 20.0 && !this.succeeded()) {
            this.agent.getLog().warning("Failed to find it: agent loc:" + this.agent.getLocation() + " report missing: " + this.probe);
            this.probe.missed(this.module.counter);
            this.probe = this.getNextLocation();
        }
        if (this.probe != null) {
            this.agent.safeRunToLocation(this.probe.location);
        }
    }

    @Override
    public boolean succeeded() {
        Action parentAction = this.parent.intention.getAncestorAction();
        if (this.module.inventory.hasItemOfAffordance(this.affType)) {
            this.probe.found(this.module.counter);
            this.item = this.module.inventory.getItemOfAffordance(this.affType);
            this.module.perceptiveField.satisfyAffordance(parentAction, this.affType, this.item);
            this.agent.getLog().info("Atomic search memory - " + (Object)((Object)this.affType) + " - finished. Duration :" + this.counter + " rounds.");
            return true;
        }
        if (this.item == null || this.item.cathegory == null) {
            return false;
        }
        boolean succeeded = false;
        switch (this.item.cathegory) {
            case PLAYER: {
                succeeded = true;
                break;
            }
            case PLACE: {
                if (this.agent.getLocation() == null || !(this.agent.getLocation().getDistance(this.item.getLocation()) < 505.0)) break;
                succeeded = true;
            }
        }
        if (succeeded) {
            this.item.decreaseAttractivity();
            this.module.perceptiveField.satisfyAffordance(parentAction, this.affType, this.item);
            this.probe.found(this.module.counter);
            this.agent.getLog().info("Atomic search memory - " + (Object)((Object)this.affType) + " - finished. Duration :" + this.counter + " rounds.");
        }
        return succeeded;
    }

    @Override
    public boolean failed() {
        if (this.counter - this.actionStart > this.parent.timeLimit) {
            return true;
        }
        return this.probe == null;
    }

    @Override
    protected void initialisation() {
        super.initialisation();
        this.affType = ((SearchMemory)this.parent).affordance;
        this.itemRecords = this.agent.itemMemory.getLocationOfAffordances(this.affType, this.module.counter);
        if (this.itemRecords == null || this.itemRecords.isEmpty()) {
            return;
        }
        Collections.sort(this.itemRecords);
        this.probe = this.itemRecords.get(0);
        ++this.index;
        this.agent.getAct().act((CommandMessage)new Configuration().setAction(this.type.toString()).setName(this.type.toString() + " " + (Object)((Object)this.affType)));
    }
}

