/*
 * Decompiled with CFR 0.152.
 */
package bot;

import bot.DMSMemoryVO;
import bot.ExperimentController;
import bot.ExperimentControllerImpl;
import bot.PathFinderModule;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import decisionMakingSystem.DMSModuleViewer;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.GMTTime;
import decisionMakingSystem.GlobalParameters;
import decisionMakingSystem.ItemMemory;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import pogamutEndEvent.IPogamutEndEventListener;
import pogamutEndEvent.PogamutEndEventType;
import utils.TimeUtils;

@AgentScoped
public class Bot
extends UT2004BotModuleController {
    UT2004Bot agent;
    private static IPogamutEndEventListener listener = null;
    public boolean verbose;
    public double gmtTime = 0.0;
    private double oldGMT = 0.0;
    private boolean loadAgentFromFile = false;
    private ExperimentController expControl;
    private DecisionModuleImpl decisions = null;
    public Game game;
    public AgentInfo agentInfo;
    public Players players;
    private DMSMemoryVO memoryVO = null;
    private DMSModuleViewer dmsViz;
    private ArrayList<Item> knownWeapons = new ArrayList();
    private ArrayList<Item> knownItems = new ArrayList();
    public String mapMarkings = "maps" + File.separator + "UnrealVille.xml";
    String directory = "." + File.separator;
    public String planningFilename = "transitions" + File.separator + "Student.xml";
    private Initialize initilizeCommand = null;
    public int lifeTime = 24;
    public static boolean noFrames = true;
    PathFinderModule myPathFinder;
    public HashMap<UnrealId, NavPoint> knownNavPoints = new HashMap();
    public double currentTime;
    protected double lastFeaturesTime = 0.0;
    protected static final double FEATURES_INTERVAL = 3.0;
    public ItemMemory itemMemory;
    private int currentItemIndex = 0;
    public static double TMP_TimeSpeed = 1.0;
    public static double TMP_TimeStart = -1.0;
    private double TMP_TimeDiff = -1.0;
    private double TMP_TimeOrigStart = -1.0;
    IWorldEventListener<MapPointListObtained> myMapListObtainedListener = new IWorldEventListener<MapPointListObtained>(){

        public void notify(MapPointListObtained event) {
            MapPointListObtained map = event;
            Bot.this.knownNavPoints.putAll(map.getNavPoints());
            for (NavPoint nav : Bot.this.knownNavPoints.values()) {
                EItem eItem = ((Bot)Bot.this).decisions.things.processItem(nav);
                if (eItem == null) continue;
                Bot.this.itemMemory.addItemToMemory(eItem, 0, 1);
            }
        }
    };
    public IWorldEventListener<BeginMessage> myBegListener = new IWorldEventListener<BeginMessage>(){

        public void notify(BeginMessage bm) {
            Bot.this.currentTime = bm.getTime();
            if (Bot.this.TMP_TimeOrigStart == -1.0) {
                Bot.this.TMP_TimeOrigStart = Bot.this.currentTime;
            }
            Bot.this.TMP_TimeDiff = Bot.this.currentTime - Bot.this.TMP_TimeOrigStart;
            Bot.this.currentTime = TMP_TimeStart + (Bot.this.currentTime - Bot.this.TMP_TimeOrigStart) * TMP_TimeSpeed;
        }
    };
    protected static final String PERC_LOG = "PERC";
    ICommandListener moveListener;

    public void setPogamutEndEventListener(IPogamutEndEventListener _listener) {
        listener = _listener;
    }

    public IVisionWorldView getWorldView() {
        return super.getWorldView();
    }

    public DecisionModuleImpl getDecisions() {
        return this.decisions;
    }

    public void logic() throws PogamutException {
        this.expControl.increaseInternalCounter(this.currentTime);
        this.doNormalActions();
        if (GMTTime.isMidnight((int)this.expControl.getInternalCounter())) {
            this.getLog().fine("Midnight update Main.java");
            this.expControl.controlExperiment();
        }
    }

    protected void doAction(String act) {
        try {
            this.getAct().act((CommandMessage)new Configuration().setAction("USE"));
            Self slf = (Self)this.getWorldView().getSingle(Self.class);
            Field f = Self.class.getDeclaredField("action");
            f.setAccessible(true);
            f.set(slf, act);
        }
        catch (Exception ex) {
            throw new PogamutException("Reflect exception.", (Throwable)ex, (Object)this);
        }
    }

    private void doNormalActions() {
        this.memoryVO = this.decisions.doReasoning(this.getCurrentTime());
        this.memoryVO.setVerbose(this.verbose);
        if (this.oldGMT != this.gmtTime) {
            this.decisions.setGMT(this.gmtTime);
            this.expControl.getDMSLogger().writeAMessage("Time zone changed! Change: " + this.gmtTime + "\n\r");
            this.memoryVO.setGMTChanged(true);
            this.oldGMT = this.gmtTime;
        }
        this.expControl.getDMSLogger().update(this.memoryVO);
        if (!noFrames) {
            this.dmsViz.update();
            if (this.memoryVO.getCounter() % (GlobalParameters.LENGHT_OF_A_DAY / 24) == 0) {
                // empty if block
            }
        }
        if (TimeUtils.isHour(this.decisions.counter)) {
            this.expControl.hourUpdate();
        }
    }

    public void prepareBot(UT2004Bot bot) {
        this.game = new Game(bot, (Logger)this.getLog());
        this.agentInfo = new AgentInfo(bot, this.game, (Logger)this.getLog());
        this.players = new Players(bot, (Logger)this.getLog());
        this.itemMemory = new ItemMemory((Logger)this.getLog());
        this.getWorldView().addEventListener(MapPointListObtained.class, this.myMapListObtainedListener);
        this.getWorldView().addEventListener(BeginMessage.class, this.myBegListener);
        this.prepareNewAgent();
        if (!noFrames) {
            this.dmsViz = new DMSModuleViewer(this.decisions);
        }
        this.getLog().info("finished with preparation.");
        this.getLog().setLevel(Level.SEVERE);
    }

    private void setNextWeaponTarget() {
        ++this.currentItemIndex;
        if (this.knownWeapons.size() == this.currentItemIndex) {
            this.currentItemIndex = 0;
        }
    }

    private void prepareNewAgent() {
        this.decisions = new DecisionModuleImpl(this.itemMemory);
        this.decisions.prepareLogic(this, this.directory, this.planningFilename);
        if (listener != null) {
            this.decisions.eventSource.addEventListener(listener);
        }
        this.expControl = new ExperimentControllerImpl((Logger)this.getLog(), this.directory, this);
        this.expControl.prepareExperiment();
        this.decisions.setDMSLogger(this.expControl.getDMSLogger());
        this.decisions.eventSource.fireEvent(PogamutEndEventType.INIT_DECISION_TREE, this.decisions.allIntentions);
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        this.knownItems.addAll(this.getWorldView().getAll(Item.class).values());
        this.knownWeapons.addAll(this.getWorldView().getAll(Item.class).values());
        for (Item it : this.knownItems) {
            EItem eItem = this.decisions.things.processItem(it);
            if (eItem == null) continue;
            this.itemMemory.addItemToMemory(eItem, 0, 1);
        }
        Iterator<Item> iterator = this.knownWeapons.iterator();
        while (iterator.hasNext()) {
            Item it;
            it = iterator.next();
            if (it.getType().getCategory() == ItemType.Category.WEAPON) continue;
            iterator.remove();
        }
    }

    protected void shutdownAgent() {
        this.expControl.cleanUp();
        if (!noFrames) {
            this.dmsViz.dispose();
        }
    }

    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        this.body.getCommunication().sendGlobalTextMessage("Hello world! I am alive!");
    }

    private void runAroundTheMap() {
        this.runAroundItemsInTheMap(this.knownWeapons, false);
    }

    DecisionModuleImpl getDMS() {
        return this.decisions;
    }

    public void botKilled(BotKilled event) {
    }

    public Initialize getInitializeCommand() {
        if (this.initilizeCommand == null) {
            return new Initialize();
        }
        return this.initilizeCommand;
    }

    public void runAroundItemsInTheMap(ArrayList<Item> itemsToRunAround, boolean b) {
    }

    public ArrayList<Item> getKnownWeapons() {
        return this.knownWeapons;
    }

    public Object getSeeItem(long id) {
        for (Item it : this.knownItems) {
            Long longId = this.getDecisions().things.idTable.get(it.getId());
            if (longId == null) {
                Long newId = (long)this.getDecisions().things.idTable.size() + 1L;
                this.getDecisions().things.idTable.put(it.getId(), newId);
                longId = newId;
            }
            if (longId != id || !it.isVisible()) continue;
            return it;
        }
        return null;
    }

    public void safeRunToLocation(Location location) {
        IPathFuture pathHandle = this.pathPlanner.computePath((Object)this.info.getLocation(), (Object)location);
        this.pathExecutor.followPath(pathHandle);
    }

    public int getCurrentTime() {
        return (int)Math.round(this.currentTime);
    }

    public Location getLocation() {
        Self self = (Self)this.getWorldView().getSingle(Self.class);
        if (self != null) {
            return self.getLocation();
        }
        return null;
    }

    public void createAgent() {
        new UT2004BotRunner(Bot.class, "MyBot").setMain(true).startAgent();
    }

    public void initializeController(UT2004Bot bot) {
        super.initializeController(bot);
        this.agent = bot;
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(Bot.class, "MyBot").startAgent();
    }
}

