/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.schemas;

import cz.cuni.amis.pogamut.episodic.schemas.SchemaObjectNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaSlot;
import cz.cuni.amis.pogamut.episodic.schemas.SlotContent;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaSlotTest {
    SchemaSlot instance = null;

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSchemaSlot01() {
        this.instance = new SchemaSlot(123, "type");
        Assert.assertEquals((long)this.instance.getId(), (long)123L);
        Assert.assertEquals((Object)this.instance.getType(), (Object)"type");
        Assert.assertTrue((boolean)this.instance.filledBy.isEmpty());
        Assert.assertNull((Object)this.instance.getSlotContent("object"));
        SchemaObjectNode obj = new SchemaObjectNode(456, "object");
        boolean result = this.instance.addSlotContent(789, obj);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)this.instance.filledBy.size(), (long)1L);
        SlotContent cont = this.instance.getSlotContent("object");
        Assert.assertNotNull((Object)cont);
        Assert.assertSame((Object)cont.getSlot(), (Object)this.instance);
        Assert.assertSame((Object)cont.getObject(), (Object)obj);
        Assert.assertEquals((long)cont.getId(), (long)789L);
        result = this.instance.addSlotContent(0, obj);
        Assert.assertFalse((boolean)result);
        cont = this.instance.getSlotContent("object");
        Assert.assertEquals((long)cont.getId(), (long)789L);
        SchemaObjectNode obj2 = new SchemaObjectNode(1, "object2");
        result = this.instance.addSlotContent(1, obj2);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)this.instance.filledBy.size(), (long)2L);
        cont = this.instance.getSlotContent("object2");
        Assert.assertSame((Object)cont.getSlot(), (Object)this.instance);
        Assert.assertSame((Object)cont.getObject(), (Object)obj2);
        Assert.assertEquals((Object)this.instance.getSlotContents(), this.instance.filledBy.values());
        System.out.println("---/// TEST SCHEMA SLOT 01 OK ///---");
    }

    @Test
    public void testSchemaSlot02() {
        this.instance = new SchemaSlot(123, "type");
        for (int i = 0; i < 100; ++i) {
            SchemaObjectNode obj = new SchemaObjectNode(i, "object" + i);
            boolean result = this.instance.addSlotContent(200 + i, obj);
            Assert.assertTrue((boolean)result);
        }
        Collection col = this.instance.getSlotContents();
        Assert.assertEquals((long)col.size(), (long)100L);
        for (int i = 0; i < 100; ++i) {
            SlotContent cont = this.instance.getSlotContent("object" + i);
            Assert.assertTrue((boolean)col.contains(cont));
            Assert.assertSame((Object)cont.getSlot(), (Object)this.instance);
            Assert.assertEquals((Object)cont.getObject().getName(), (Object)("object" + i));
        }
        System.out.println("---/// TEST SCHEMA SLOT 02 OK ///---");
    }
}

