/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.schemas;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaCounter;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaObjectNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaSlot;
import cz.cuni.amis.pogamut.episodic.schemas.SlotContent;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaEpisodeNodeTest {
    SchemaEpisodeNode instance = null;

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSchemaEpisodeNode01() {
        Intention intention = new Intention("intention", 0);
        this.instance = new SchemaEpisodeNode((Node)intention, 1, "SchemaEpisodeNode1");
        Assert.assertSame((Object)this.instance.getAssociatedNode(), (Object)intention);
        Assert.assertSame((Object)intention.getAssociatedNode(), (Object)this.instance);
        Assert.assertEquals((long)this.instance.getId(), (long)1L);
        Assert.assertEquals((Object)this.instance.getName(), (Object)"SchemaEpisodeNode1");
        Assert.assertNull((Object)this.instance.getParentSchemaNode());
        Assert.assertTrue((boolean)this.instance.getChildrenSchemaNodes().isEmpty());
        Action action1 = new Action("action1", 0);
        intention.addSubNode(action1);
        SchemaEpisodeNode node2 = new SchemaEpisodeNode((Node)action1, 2, "SchemaEpisodeNode2");
        Assert.assertEquals((long)this.instance.getChildrenSchemaNodes().size(), (long)1L);
        Assert.assertSame((Object)node2.getParentSchemaNode(), (Object)this.instance);
        Action action2 = new Action("action2", 0);
        intention.addSubNode(action2);
        SchemaEpisodeNode node3 = new SchemaEpisodeNode((Node)action2, 3, "SchemaEpisodeNode3");
        Assert.assertEquals((long)this.instance.getChildrenSchemaNodes().size(), (long)2L);
        Assert.assertSame((Object)node3.getParentSchemaNode(), (Object)this.instance);
        Assert.assertTrue((boolean)this.instance.getChildrenSchemaNodes().contains(node2));
        Assert.assertTrue((boolean)this.instance.getChildrenSchemaNodes().contains(node3));
        Assert.assertTrue((boolean)this.instance.getSlots().isEmpty());
        boolean result = this.instance.addSlot("slot1", 4);
        Assert.assertTrue((boolean)result);
        result = this.instance.addSlot("slot2", 5);
        Assert.assertTrue((boolean)result);
        result = this.instance.addSlot("slot2", 6);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)this.instance.getSlots().size(), (long)2L);
        Assert.assertEquals((long)this.instance.getSlot("slot1").getId(), (long)4L);
        Assert.assertEquals((long)this.instance.getSlot("slot2").getId(), (long)5L);
        System.out.println("---/// TEST SCHEMA EPISODE NODE 01 OK ///---");
    }

    @Test
    public void testSchemaEpisodeNode02() {
        Intention n1 = new Intention("intention1", 0);
        Intention n2 = new Intention("intention2", 0);
        Action n3 = new Action("action1", 0);
        Action n4 = new Action("action2", 0);
        SchemaEpisodeNode node1 = new SchemaEpisodeNode((Node)n1, 1, "n1");
        SchemaEpisodeNode node2 = new SchemaEpisodeNode((Node)n2, 2, "n2");
        SchemaEpisodeNode node3 = new SchemaEpisodeNode((Node)n3, 3, "n3");
        SchemaEpisodeNode node4 = new SchemaEpisodeNode((Node)n4, 4, "n4");
        SchemaSlot slot = new SchemaSlot(5, "type");
        SchemaObjectNode obj = new SchemaObjectNode(6, "object");
        SlotContent content = new SlotContent(5, slot, obj);
        HashSet<SchemaEpisodeNode> col1 = new HashSet<SchemaEpisodeNode>();
        col1.add(node1);
        HashSet<SchemaEpisodeNode> col2 = new HashSet<SchemaEpisodeNode>();
        col2.add(node1);
        col2.add(node2);
        col2.add(node3);
        HashSet colc1 = new HashSet();
        HashSet<SlotContent> colc2 = new HashSet<SlotContent>();
        colc2.add(content);
        int hash = node1.id;
        SchemaCounter c1 = new SchemaCounter(hash, col1, colc1);
        hash = node1.id + node2.id + node3.id;
        SchemaCounter c2 = new SchemaCounter(hash += content.id, col2, colc2);
        c1.increaseCount();
        c2.increaseCount();
        c2.increaseCount();
        Assert.assertEquals((long)node1.getCounts().size(), (long)2L);
        Assert.assertEquals((long)node2.getCounts().size(), (long)1L);
        Assert.assertEquals((long)node3.getCounts().size(), (long)1L);
        Assert.assertEquals((long)node4.getCounts().size(), (long)0L);
        Assert.assertSame(node2.getCounts().get((Object)(hash - node2.id)).iterator().next(), (Object)c2);
        Assert.assertSame(node3.getCounts().get((Object)(hash - node3.id)).iterator().next(), (Object)c2);
        Assert.assertSame(node1.getCounts().get((Object)(hash - node1.id)).iterator().next(), (Object)c2);
        Assert.assertSame(node1.getCounts().get((Object)0).iterator().next(), (Object)c1);
        Assert.assertEquals((long)((SchemaCounter)node1.getCounts().get((Object)0).iterator().next()).getCount(), (long)1L);
        Assert.assertTrue((boolean)c1.getENodes().contains(node1));
        Assert.assertEquals((long)c1.getENodes().size(), (long)1L);
        Assert.assertTrue((boolean)c1.getContentsNodes().isEmpty());
        Assert.assertTrue((boolean)c2.getENodes().contains(node1));
        Assert.assertTrue((boolean)c2.getENodes().contains(node2));
        Assert.assertTrue((boolean)c2.getENodes().contains(node3));
        Assert.assertTrue((boolean)c2.getENodes().contains(node1));
        Assert.assertEquals((long)c2.getENodes().size(), (long)3L);
        Assert.assertTrue((boolean)c2.getContentsNodes().contains(content));
        Assert.assertEquals((long)c2.getContentsNodes().size(), (long)1L);
        Assert.assertEquals((long)((SchemaCounter)node1.getCounts().get((Object)(hash - node1.id)).iterator().next()).getCount(), (long)2L);
        System.out.println("---/// TEST SCHEMA EPISODE NODE 02 OK ///---");
    }
}

