/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.schemas;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaCounter;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaObjectNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaSlot;
import cz.cuni.amis.pogamut.episodic.schemas.SlotContent;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaCounterTest {
    SchemaCounter instance = null;

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSchemaCounter01() {
        HashSet cole = new HashSet();
        HashSet colc = new HashSet();
        this.instance = new SchemaCounter(0, cole, colc);
        Assert.assertEquals((long)this.instance.key, (long)0L);
        Assert.assertEquals((long)this.instance.getCount(), (long)0L);
        Assert.assertEquals((long)this.instance.getTotalCount(), (long)0L);
        Assert.assertTrue((boolean)this.instance.getContentsNodes().isEmpty());
        Assert.assertTrue((boolean)this.instance.getENodes().isEmpty());
        System.out.println("---/// TEST SCHEMA COUNTER 01 OK ///---");
    }

    @Test
    public void testSchemaCounter02() {
        Intention n1 = new Intention("intention1", 0);
        Intention n2 = new Intention("intention2", 0);
        Action n3 = new Action("action1", 0);
        Action n4 = new Action("action2", 0);
        SchemaEpisodeNode node1 = new SchemaEpisodeNode((Node)n1, 1, "n1");
        SchemaEpisodeNode node2 = new SchemaEpisodeNode((Node)n2, 2, "n2");
        SchemaEpisodeNode node3 = new SchemaEpisodeNode((Node)n3, 3, "n3");
        SchemaEpisodeNode node4 = new SchemaEpisodeNode((Node)n4, 4, "n4");
        SchemaSlot slot1 = new SchemaSlot(1, "type1");
        SchemaSlot slot2 = new SchemaSlot(2, "type2");
        SchemaObjectNode obj1 = new SchemaObjectNode(3, "object1");
        SchemaObjectNode obj2 = new SchemaObjectNode(4, "object2");
        SlotContent content11 = new SlotContent(5, slot1, obj1);
        SlotContent content12 = new SlotContent(6, slot1, obj2);
        SlotContent content21 = new SlotContent(7, slot2, obj1);
        SlotContent content22 = new SlotContent(8, slot2, obj2);
        HashSet<SchemaEpisodeNode> cole = new HashSet<SchemaEpisodeNode>();
        HashSet<SlotContent> colc = new HashSet<SlotContent>();
        cole.add(node1);
        cole.add(node2);
        cole.add(node3);
        cole.add(node4);
        colc.add(content11);
        colc.add(content12);
        colc.add(content21);
        colc.add(content22);
        int hash = node1.id + node2.id + node3.id + node4.id;
        this.instance = new SchemaCounter(hash += content11.id + content12.id + content21.id + content22.id, cole, colc);
        Assert.assertTrue((boolean)this.instance.checkNode(Integer.valueOf(node1.getId())));
        Assert.assertTrue((boolean)this.instance.checkNode(Integer.valueOf(node2.getId())));
        Assert.assertTrue((boolean)this.instance.checkNode(Integer.valueOf(node3.getId())));
        Assert.assertTrue((boolean)this.instance.checkNode(Integer.valueOf(node4.getId())));
        Assert.assertTrue((boolean)this.instance.checkNode(Integer.valueOf(content11.getId())));
        Assert.assertTrue((boolean)this.instance.checkNode(Integer.valueOf(content12.getId())));
        Assert.assertTrue((boolean)this.instance.checkNode(Integer.valueOf(content21.getId())));
        Assert.assertTrue((boolean)this.instance.checkNode(Integer.valueOf(content22.getId())));
        Assert.assertTrue((boolean)this.instance.checkNodes(cole, colc));
        HashSet<Integer> col = new HashSet<Integer>();
        col.add(node1.getId());
        Assert.assertFalse((boolean)this.instance.checkNodes(col));
        col.add(node2.getId());
        col.add(node3.getId());
        col.add(node4.getId());
        Assert.assertFalse((boolean)this.instance.checkNodes(col));
        col.add(content11.getId());
        col.add(content12.getId());
        col.add(content21.getId());
        Assert.assertFalse((boolean)this.instance.checkNodes(col));
        col.add(content22.getId());
        Assert.assertTrue((boolean)this.instance.checkNodes(col));
        col.add(-1);
        Assert.assertFalse((boolean)this.instance.checkNodes(col));
        Assert.assertFalse((boolean)this.instance.checkNode(Integer.valueOf(0)));
        colc.remove(content11);
        Assert.assertFalse((boolean)this.instance.checkNodes(cole, colc));
        colc.add(content11);
        Assert.assertTrue((boolean)this.instance.checkNodes(cole, colc));
        cole.remove(node1);
        Assert.assertFalse((boolean)this.instance.checkNodes(cole, colc));
        System.out.println("---/// TEST SCHEMA COUNTER 02 OK ///---");
    }
}

