/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.episodes;

import cz.cuni.amis.pogamut.episodic.decisions.DecisionTree;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTreeTest;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.episodes.EpisodeNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectNode;
import cz.cuni.amis.pogamut.episodic.memory.AffordanceUsed;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EpisodeTest {
    Chronobag ch = null;
    Episode instance = null;

    @Before
    public void setUp() {
        DecisionTree dTree = DecisionTreeTest.sampleTree(10, 2, 3);
        AgentMemory mem = new AgentMemory();
        mem.initialize(dTree.topLevelGoals.values());
        this.ch = new Chronobag(mem.getIdGenerator(), mem);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testEpisode01() {
        this.instance = new Episode(this.ch);
        Assert.assertFalse((boolean)this.instance.deleted);
        Assert.assertFalse((boolean)this.instance.finished);
        Assert.assertSame((Object)this.instance.getParentChronobag(), (Object)this.ch);
        ArrayList<String> trace = new ArrayList<String>();
        trace.add("intention.2.0");
        trace.add("action.1.0");
        trace.add("intention.1.0");
        trace.add("action.0.0");
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        this.instance.addNewNode("atomic.0.0", trace, affs);
        Assert.assertEquals((Object)this.instance.getRoot().getName(), (Object)"intention.2.0");
        Assert.assertSame((Object)this.instance.getRoot().getAssociatedNode(), this.ch.getMemory().getDecisionTree().topLevelGoals.get("intention.2.0"));
        EpisodeNode n = this.instance.getRoot();
        n = n.getChild("action.1.0").getChild("intention.1.0").getChild("action.0.0").getChild("atomic.0.0");
        Assert.assertNotNull((Object)n.getAssociatedNode());
        affs.add(new AffordanceUsed("action.1.0", "type", "obj1"));
        this.instance.addNewNode("atomic.0.0", trace, affs);
        n = this.instance.getRoot().getChild("action.1.0");
        Assert.assertEquals((long)n.getObjectSlot("type").getUsedObjects().size(), (long)1L);
        Assert.assertEquals((Object)((ObjectNode)n.getObjectSlot("type").getUsedObjects().iterator().next()).getName(), (Object)"obj1");
        Assert.assertEquals((long)this.instance.getRoot().numberOfSubNodes, (long)4L);
        Assert.assertEquals((long)this.instance.getRoot().numberOfSubNodesWithObjects, (long)5L);
        trace.clear();
        trace.add("intention.2.0");
        trace.add("action.1.1");
        trace.add("intention.1.0");
        trace.add("action.0.0");
        affs.clear();
        affs.add(new AffordanceUsed("intention.2.0", "type", "obj2"));
        this.instance.addNewNode("atomic.0.0", trace, affs);
        Assert.assertEquals((long)this.instance.getRoot().numberOfSubNodes, (long)8L);
        Assert.assertEquals((long)this.instance.getRoot().numberOfSubNodesWithObjects, (long)10L);
        ArrayList<String> trace2 = new ArrayList<String>(trace);
        trace2.add("atomic.0.0");
        boolean result = this.instance.finishNode("atomic.0.0", trace2, true);
        Assert.assertTrue((boolean)result);
        trace2.addAll(trace);
        result = this.instance.finishNode("action.0.0", trace2, false);
        Assert.assertTrue((boolean)result);
        n = this.instance.getRoot().getChild("action.1.1").getChild("intention.1.0").getChild("action.0.0");
        Assert.assertTrue((boolean)n.finished);
        Assert.assertFalse((boolean)n.succeeded);
        n = n.getChild("atomic.0.0");
        Assert.assertTrue((boolean)n.finished);
        Assert.assertTrue((boolean)n.succeeded);
        trace.clear();
        trace.add("intention.2.1");
        trace.add("action.1.1");
        trace.add("intention.1.0");
        trace.add("action.0.0");
        try {
            this.instance.addNewNode("atomic.0.0", trace, affs);
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertEquals((long)this.instance.getRoot().numberOfSubNodes, (long)8L);
        Assert.assertEquals((long)this.instance.getRoot().numberOfSubNodesWithObjects, (long)10L);
        trace.clear();
        trace.add("intention.2.0");
        trace.add("action.x.x");
        affs.clear();
        this.instance.addNewNode("atomic.x", trace, affs);
        n = this.instance.getRoot().getChild("action.x.x");
        Assert.assertNotNull((Object)n);
        Assert.assertNull((Object)n.associatedNode);
        n = n.getChild("atomic.x");
        Assert.assertNotNull((Object)n);
        Assert.assertNull((Object)n.associatedNode);
        Assert.assertFalse((boolean)this.instance.finished);
        trace.clear();
        trace.add("intention.2.0");
        this.instance.finishNode("intention.2.0", trace, true);
        Assert.assertTrue((boolean)this.instance.finished);
        System.out.println("---/// TEST EPISODE 01 OK ///---");
    }

    @Test
    public void testEpisode02() {
        this.instance = new Episode(this.ch);
        ArrayList<String> trace = new ArrayList<String>();
        trace.add("intention.2.0");
        trace.add("action.1.0");
        trace.add("intention.1.0");
        trace.add("action.0.0");
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        affs.add(new AffordanceUsed("action.1.0", "type", "obj1"));
        this.instance.addNewNode("atomic.0.0", trace, affs);
        trace.clear();
        trace.add("intention.2.0");
        trace.add("action.x.x");
        affs.clear();
        this.instance.addNewNode("atomic.x", trace, affs);
        Episode copy = this.instance.createCopy(null);
        Assert.assertNotNull((Object)copy);
        Assert.assertNotSame((Object)this.instance, (Object)copy);
        Assert.assertEquals((long)this.instance.getIdEpisode(), (long)copy.getIdEpisode());
        Assert.assertNull((Object)copy.getParentChronobag());
        Assert.assertNotSame((Object)this.instance.getRoot(), (Object)copy.getRoot());
        Assert.assertEquals((Object)this.instance.getRoot().getName(), (Object)copy.getRoot().getName());
        Assert.assertFalse((this.instance.getRoot().getId() == copy.getRoot().getId() ? 1 : 0) != 0);
        Assert.assertSame((Object)this.instance.getRoot().getAssociatedNode(), (Object)copy.getRoot().getAssociatedNode());
        EpisodeNode n1 = this.instance.getRoot().getChild("action.1.0");
        EpisodeNode n2 = copy.getRoot().getChild("action.1.0");
        Assert.assertNotSame((Object)n1, (Object)n2);
        Assert.assertEquals((Object)n1.getName(), (Object)n2.getName());
        Assert.assertFalse((n1.getId() == n2.getId() ? 1 : 0) != 0);
        Assert.assertSame((Object)n1.getAssociatedNode(), (Object)n2.getAssociatedNode());
        Assert.assertEquals((long)n1.getObjectSlots().size(), (long)n2.getObjectSlots().size());
        Assert.assertEquals((long)n1.getObjectSlot("type").getUsedObjects().size(), (long)n2.getObjectSlot("type").getUsedObjects().size());
        Assert.assertSame(n1.getObjectSlot("type").getUsedObjects().iterator().next(), n2.getObjectSlot("type").getUsedObjects().iterator().next());
        Assert.assertEquals((long)((ObjectNode)this.instance.getParentChronobag().objectNodes.get((Object)"obj1")).usedAt.size(), (long)2L);
        System.out.println("---/// TEST EPISODE 02 OK ///---");
    }
}

