package cz.cuni.amis.pogamut.episodic.schemas;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Michal Cermak
 */
public class SchemaObjectNodeTest {

    SchemaObjectNode instance = null;

    public SchemaObjectNodeTest() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSchemaObjectNode01() {
        instance = new SchemaObjectNode(1, "object");

        assertEquals(instance.getId(), 1);
        assertEquals(instance.getName(), "object");
        
        assertTrue(instance.getSlotContents().isEmpty());

        SchemaSlot slot1 = new SchemaSlot(2, "slot1");
        SlotContent con1 = new SlotContent(5, slot1, instance);
        instance.addSlotUsedIn(con1);

        assertEquals(instance.getSlotContents().size(), 1);
        assertSame(con1.getObject(), instance);

        SchemaSlot slot2 = new SchemaSlot(3, "slot2");
        SlotContent con2 = new SlotContent(6, slot2, instance);
        instance.addSlotUsedIn(con2);

        assertEquals(instance.getSlotContents().size(), 2);
        assertSame(con2.getObject(), instance);

        assertTrue(instance.getSlotContents().contains(con1));
        assertTrue(instance.getSlotContents().contains(con2));


        System.out.println("---/// TEST SCHEMA OBJECT NODE 01 OK ///---");
    }

}