package cz.cuni.amis.pogamut.episodic.memory;

import java.util.HashSet;
import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.AtomicAction;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTree;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTreeTest;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.episodes.EpisodeNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectSlot;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.PriorityQueue;
import java.util.Queue;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Miso
 */
public class AgentMemoryTest {

    AgentMemory instance = null;
    DecisionTree dTree = null;

    public AgentMemoryTest() {
    }

    @Before
    public void setUp() {
        dTree = DecisionTreeTest.sampleTree(10, 2, 3);
        for (Intention i : dTree.topLevelGoals.values()) {
            Action a = (Action)i.getSubNode("action.1.0").getSubNode("intention.1.0").getSubNode("action.0.0");
            a.addAtomicAction(new AtomicAction("SLEEP", 80));
        }
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testAgentMemory01() {
        System.out.println("---/// STARTING AGENT MEMORY 01 ///---");

        instance = new AgentMemory();
        assertNotNull(instance);

        assertNotNull(instance.getIdGenerator());

        assertNotNull(instance.decisionTree);
        assertTrue(instance.decisionTree.topLevelGoals.isEmpty());

        assertNotNull(instance.getPresentChronobag());
        assertTrue(instance.getPresentChronobag().getEpisodes().isEmpty());
        assertTrue(instance.getPastChrononags().isEmpty());

        assertNotNull(instance.getSchemaBag());
        assertEquals(instance.getSchemaBag().getNumberOfNodes(), 0);

        instance.initialize(dTree.topLevelGoals.values());
        
        assertFalse(instance.decisionTree.topLevelGoals.isEmpty());
        assertEquals(dTree.topLevelGoals.size(), instance.getDecisionTree().topLevelGoals.size());

        assertEquals(instance.listeners.getListenerCount(), 0);

        System.out.println("---/// TEST AGENT MEMORY 01 OK ///---");
    }

    @Test
    public void testAgentMemory02() {
        System.out.println("---/// STARTING AGENT MEMORY 02 ///---");

        String origHash = getParametersHash();
        int MAX_CHRONOBAG_NODES = Parameters.MAX_CHRONOBAG_NODES;
        Parameters.MAX_CHRONOBAG_NODES = 0;

        instance = new AgentMemory();
        instance.initialize(dTree.topLevelGoals.values());

        ArrayList<String> trace = new ArrayList<String>();
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");
        String time = "Mo, 03:44, day 0.";
        instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.1");
        instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.2");
        instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.3");

        instance.addNewNode("atomic.0.0", trace, time, affs);
        
        Chronobag ch = instance.present;
        
        assertEquals(instance.getChronobags().size(), 1);
        assertEquals(instance.schemas.getSchemaENodes().size(), 8);

        time = "Tu, 03:44, day 1.";
        instance.addNewNode("SLEEP", trace, time, affs);
        
        assertEquals(instance.getChronobags().size(), 5);
        assertEquals(instance.schemas.getSchemaENodes().size(), 9);

        assertEquals(instance.past.size(), 4);
     /*   ch = instance.past.iterator().next();
        assertEquals(ch.getNumberOfEpisodeNodes(), 0);
        assertTrue(ch.getEpisodes().isEmpty());*/

        Parameters.MAX_CHRONOBAG_NODES = MAX_CHRONOBAG_NODES;
        String newHash = getParametersHash();
        assertTrue(newHash.equals(origHash));

        System.out.println("---/// TEST AGENT MEMORY 02 OK ///---");
    }

    @Test
    public void testAgentMemory03() {
        System.out.println("---/// STARTING AGENT MEMORY 03 ///---");

        String origHash = getParametersHash();

        int MAX_CHRONOBAG_NODES = Parameters.MAX_CHRONOBAG_NODES;
        int MAX_CHRONOBAG_LEVEL = Parameters.MAX_CHRONOBAG_LEVELS;
        Parameters.MAX_CHRONOBAG_NODES = 500;
        Parameters.MAX_CHRONOBAG_LEVELS = 1;

        instance = new AgentMemory();
        instance.initialize(dTree.topLevelGoals.values());

        ArrayList<String> trace = new ArrayList<String>();
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");
        String time = "Mo, 03:44, day 0.";
        instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.1");
        instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.2");
        instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.3");

        instance.addNewNode("atomic.0.0", trace, time, affs);

        Chronobag ch = instance.present;
        assertEquals(ch.getEpisodes().size(), 4);

        assertEquals(instance.getChronobags().size(), 1);
        assertEquals(ch.getNumberOfEpisodeNodes(), 20);
        assertEquals(instance.schemas.getSchemaENodes().size(), 8);

        time = "Tu, 03:44, day 1.";
        instance.addNewNode("SLEEP", trace, time, affs);

        assertEquals(instance.getChronobags().size(), 2);
        assertEquals(instance.past.size(), 1);
        ch = instance.past.iterator().next();
        assertEquals(ch.getNumberOfEpisodeNodes(), 21);
        assertEquals(instance.schemas.getSchemaENodes().size(), 9);
        assertEquals(ch.getEpisodes().size(), 4);

        Parameters.MAX_CHRONOBAG_NODES = MAX_CHRONOBAG_NODES;
        Parameters.MAX_CHRONOBAG_LEVELS = MAX_CHRONOBAG_LEVEL;
        String newHash = getParametersHash();
        assertTrue(newHash.equals(origHash));

        System.out.println("---/// TEST AGENT MEMORY 03 OK ///---");
    }

    private void checkEpisodeNodes(AgentMemory mem) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Chronobag c : mem.getChronobags()) {
            for (Episode e : c.getEpisodes()) {
                EpisodeNode n = e.getRoot();
                Queue<EpisodeNode> q = new PriorityQueue<EpisodeNode>();
                q.add(n);
                while (!q.isEmpty()) {
                    n = q.poll();
                    assertFalse(ids.contains(n.getId()));
                    ids.add(n.getId());
                    for (EpisodeNode ch : n.getChildrenNodes()) {
                        q.add(ch);
                    }
                    if (!n.getPredecessor().isEmpty()) {
                        if (n.getPredecessor().get(n.getEpisodeRoot().idEpisode) == n.getSuccessor().get(n.getEpisodeRoot().idEpisode)) {
             //               fail();
                            int i = 1;
                        }
            //            assertNotSame(n.getPredecessor().get(n.getEpisodeRoot().idEpisode), n.getSuccessor().get(n.getEpisodeRoot().idEpisode));
                    }
                }
            }
        }
    }

    @Test
    public void testAgentMemory04() {
        System.out.println("---/// STARTING AGENT MEMORY 04 ///---");

        int MAX_CHRONOBAG_NODES = Parameters.MAX_CHRONOBAG_NODES;
        double CHRONOBAG_SCORE_NODE_THRESHOLD = Parameters.CHRONOBAG_SCORE_NODE_THRESHOLD;
        int LANDMARK_AGE_THRESHOLD = Parameters.LANDMARK_AGE_THRESHOLDS[0];
        Parameters.MAX_CHRONOBAG_NODES = 25;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = 10;
        Parameters.CHRONOBAG_SCORE_NODE_THRESHOLD = -1;
        
        instance = new AgentMemory();
        instance.initialize(dTree.topLevelGoals.values());

        ArrayList<String> trace = new ArrayList<String>();
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");
        String time = "Mo, 03:44, day 0.";
        instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.1");
        instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.2");
        instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.3");

        instance.addNewNode("atomic.0.0", trace, time, affs);

        int nodes;
        Chronobag ch = instance.present;
        time = "Tu, 03:44, day 1.";
        checkEpisodeNodes(instance);
        instance.addNewNode("SLEEP", trace, time, affs);
        checkEpisodeNodes(instance);
        testChronobagSequence(instance);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 2.";
        instance.addNewNode("SLEEP", trace, time, affs);
        checkEpisodeNodes(instance);
        testChronobagSequence(instance);
        assertTrue(ch.getNumberOfEpisodeNodes() <= nodes);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 3.";
        instance.addNewNode("SLEEP", trace, time, affs);
        checkEpisodeNodes(instance);
        testChronobagSequence(instance);
        assertTrue(ch.getNumberOfEpisodeNodes() <= nodes);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 4.";
        instance.addNewNode("SLEEP", trace, time, affs);
        checkEpisodeNodes(instance);
        testChronobagSequence(instance);
        assertTrue(ch.getNumberOfEpisodeNodes() <= nodes);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 5.";
        instance.addNewNode("SLEEP", trace, time, affs);
        checkEpisodeNodes(instance);
        testChronobagSequence(instance);
        assertTrue(ch.getNumberOfEpisodeNodes() <= nodes);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 6.";
        instance.addNewNode("SLEEP", trace, time, affs);
        checkEpisodeNodes(instance);
        testChronobagSequence(instance);
        assertTrue(ch.getNumberOfEpisodeNodes() <= nodes);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 7.";
        instance.addNewNode("SLEEP", trace, time, affs);
        checkEpisodeNodes(instance);
        testChronobagSequence(instance);
        assertTrue(ch.getNumberOfEpisodeNodes() <= nodes);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 8.";
        instance.addNewNode("SLEEP", trace, time, affs);
        checkEpisodeNodes(instance);
        testChronobagSequence(instance);
        assertTrue(ch.getNumberOfEpisodeNodes() <= nodes);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 9.";
        instance.addNewNode("SLEEP", trace, time, affs);
        checkEpisodeNodes(instance);
        testChronobagSequence(instance);
        assertTrue(ch.getNumberOfEpisodeNodes() <= nodes);
        nodes = ch.getNumberOfEpisodeNodes();

        assertFalse(ch.isLandmark());

        time = "Tu, 03:44, day 10.";
        instance.addNewNode("SLEEP", trace, time, affs);
        checkEpisodeNodes(instance);
        assertTrue(ch.getNumberOfEpisodeNodes() <= nodes);
        nodes = ch.getNumberOfEpisodeNodes();

        time = "Tu, 03:44, day 10.";
        instance.addNewNode("SLEEP", trace, time, affs);
        assertTrue(ch.getNumberOfEpisodeNodes() == nodes);

        assertTrue(ch.isLandmark());

        Parameters.MAX_CHRONOBAG_NODES = MAX_CHRONOBAG_NODES;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = LANDMARK_AGE_THRESHOLD;
        Parameters.CHRONOBAG_SCORE_NODE_THRESHOLD = CHRONOBAG_SCORE_NODE_THRESHOLD;
        System.out.println("---/// TEST AGENT MEMORY 04 OK ///---");
    }

    private void testChronobagSequence(AgentMemory instance) {
        Chronobag c;
        int total = 0;
        for (int l = 0; l < Parameters.MAX_CHRONOBAG_LEVELS; l++) {
            c = instance.getChronobagSequenceEnds().get(l);
            while (c != null) {
                total++;
                assertEquals(c.getLevel(), l);
                assertEquals(c.getAge().getMaxAge() - c.getAge().getMinAge() + 1, Parameters.CHRONOBAG_INTERVAL_LENGHTS[l]);
                c = c.getOlderChronobag();
                if (c != null) {
                    assertTrue(c.getAge().getMinAge() > c.getYoungerChronobag().getAge().getMinAge());
                }
            }
        }
        assertEquals(total, instance.getChronobags().size());
    }

    @Test
    public void testAgentMemory05() {
        System.out.println("---/// STARTING AGENT MEMORY 05 ///---");

        //derive subnodes basic test
        instance = new AgentMemory();
        instance.initialize(dTree.topLevelGoals.values());

        ArrayList<String> trace = new ArrayList<String>();
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");

        instance.addNewNode("atomic.0.0", trace, affs);
        trace.set(3, "intention.2.1");
        instance.addNewNode("atomic.0.0", trace, affs);
        trace.set(3, "intention.2.2");
        instance.addNewNode("atomic.0.0", trace, affs);
        trace.set(3, "intention.2.3");
        instance.addNewNode("atomic.0.0", trace, affs);

        trace.set(1, "intention.1.1");
        ArrayList<String> rootTrace = new ArrayList<String>();
        for (int i=0; i<10; i++) {
            instance.addNewNode("atomic.0.0", trace, affs);
            rootTrace.add("intention.2.3");
            assertTrue(instance.nodeFinished("intention.2.3", rootTrace, true));
        }

        instance.getPresentChronobag().finish();
        
        assertEquals(28, instance.getPresentChronobag().getNumberOfEpisodeNodes());
        SchemaEpisodeNode sNode = instance.getDecisionTree().topLevelGoals.get("intention.2.3").getAssociatedNode();
        assertTrue(sNode.getSingleCount() == 1);
        assertEquals(sNode.getCounts().get(0).iterator().next().getCount(), 1);
        assertEquals(sNode.getCounts().get(0).iterator().next().getTotalCount(), 11);

        affs.add(new AffordanceUsed("intention.1.1", "type", "obj"));
        for (int i=0; i < 50; i++) {
            trace.set(3,"intention.2.0");
            instance.addNewNode("atomic.0.0", trace, affs);
            rootTrace.add("intention.2.0");
            instance.nodeFinished("intention.2.0", rootTrace, true);
            trace.set(3, "intention.2.3");
            instance.addNewNode("atomic.0.0", trace, affs);
            rootTrace.add("intention.2.3");
            instance.nodeFinished("intention.2.3", rootTrace, true);
        }

        assertTrue(sNode.getSingleCount() == 51);

        Episode e = instance.getPresentChronobag().getFirstEpisode();
        while (!(e.getRoot().getName().equals("intention.2.3") &&
                e.getRoot().getChild("action.1.0").getChild("intention.1.1") != null &&
                e.getRoot().getNumberOfSubNodes() < 7 &&
                !e.getRoot().getChild("action.1.0").getChild("intention.1.1").getObjectSlots().isEmpty())) {
            e = e.next.iterator().next();
        }

        ObjectNode obj = instance.getPresentChronobag().objectNodes.get("obj");
        assertEquals(obj.usedAt.size(), 100);

        assertEquals(e.getRoot().getNumberOfSubNodes(), 4);
        EpisodeNode node;
        node = e.getRoot().getChild("action.1.0").getChild("intention.1.1").getChild("action.0.0").getChild("atomic.0.0");
        node.deleteNode();
        node = e.getRoot().getChild("action.1.0").getChild("intention.1.1").getChild("action.0.0");
        assertTrue(node.getChildrenNodes().isEmpty());
        node.deleteNode();
        node = e.getRoot().getChild("action.1.0").getChild("intention.1.1");
        assertTrue(node.getChildrenNodes().isEmpty());
        node.deleteNode();
        node = e.getRoot().getChild("action.1.0");
        assertTrue(node.getChildrenNodes().isEmpty());
        
        node = e.getRoot().getChild("action.1.0");
        assertEquals(node.getObjectSlots().size(), 1);
        assertEquals(node.getObjectSlot("Other").getUsedObjects().size(), 1);
        assertEquals(node.getObjectSlot("Other").getUsedObjects().iterator().next().getName(), "obj");

        e.deriveEpisode();

        assertEquals(obj.usedAt.size(), 100);

        node = e.getRoot();
        assertEquals(1, node.getChildrenNodes().size());
        assertNotNull(node.getChild("action.1.0"));
        node = node.getChild("action.1.0");
        assertTrue(node.getObjectSlots().isEmpty());
        assertEquals(1, node.getChildrenNodes().size());
        assertNotNull(node.getChild("intention.1.1"));
        node = node.getChild("intention.1.1");
        assertEquals(node.getObjectSlots().size(), 1);
        assertNotNull(node.getObjectSlot("type"));
        assertEquals(node.getObjectSlot("type").getUsedObjects().size(), 1);
        assertEquals(node.getObjectSlot("type").getUsedObjects().iterator().next().getName(), "obj");
        assertEquals(1, node.getChildrenNodes().size());
        assertNotNull(node.getChild("action.0.0"));
        node = node.getChild("action.0.0");
        assertEquals(1, node.getChildrenNodes().size());
        assertNotNull(node.getChild("atomic.0.0"));
        node = node.getChild("atomic.0.0");
        assertEquals(0, node.getChildrenNodes().size());

        node = e.getRoot().getChild("action.1.0").getChild("intention.1.1");
        node.deleteNode();

        e.deriveEpisode();

        node = e.getRoot();
        assertEquals(1, node.getChildrenNodes().size());
        assertNotNull(node.getChild("action.1.0"));
        node = node.getChild("action.1.0");
        assertEquals(1, node.getChildrenNodes().size());
        assertNotNull(node.getChild("intention.1.1"));
        node = node.getChild("intention.1.1");
        assertEquals(1, node.getChildrenNodes().size());
        assertNotNull(node.getChild("action.0.0"));
        node = node.getChild("action.0.0");
        assertEquals(1, node.getChildrenNodes().size());
        assertNotNull(node.getChild("atomic.0.0"));
        node = node.getChild("atomic.0.0");
        assertEquals(0, node.getChildrenNodes().size());

        System.out.println("---/// TEST AGENT MEMORY 05 OK ///---");
    }

    @Test
    public void testAgentMemory06() {
        System.out.println("---/// STARTING AGENT MEMORY 06 ///---");

        instance = new AgentMemory();
        instance.initialize(dTree.topLevelGoals.values());

        ArrayList<String> trace = new ArrayList<String>();
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");
        affs.add(new AffordanceUsed("action.0.0", "type1", "obj1"));
        affs.add(new AffordanceUsed("action.0.0", "type1", "obj2"));
        affs.add(new AffordanceUsed("action.0.0", "type2", "obj2"));
        affs.add(new AffordanceUsed("action.0.0", "type2", "obj3"));

        ArrayList<String> rootTrace = new ArrayList<String>();
        for (int i=0; i < 50; i++) {
            trace.set(3,"intention.2.0");
            instance.addNewNode("atomic.0.0", trace, affs);
            trace.set(2, "action.1.1");
            instance.addNewNode("atomic.0.0", trace, affs);
            trace.set(2, "action.1.0");
            rootTrace.add("intention.2.0");
            instance.nodeFinished("intention.2.0", rootTrace, true);
            trace.set(3, "intention.2.3");
            instance.addNewNode("atomic.0.0", trace, affs);
            rootTrace.add("intention.2.3");
            instance.nodeFinished("intention.2.3", rootTrace, true);
        }

        Episode e = instance.getPresentChronobag().getFirstEpisode();
        while (!e.getRoot().getName().equals("intention.2.0")) {
            e = e.next.iterator().next();
        }

        assertTrue(e.episodeSimilarity(e.next.iterator().next()) == 0);
        assertTrue(e.episodeSimilarity(e.next.iterator().next().next.iterator().next()) == 1);

        e.getRoot().getChild("action.1.0").deleteNode();
        e.getRoot().getChild("action.1.1").deleteNode();

        assertEquals(e.getRoot().getChildrenNodes().size(), 1);
        assertNotNull(e.getRoot().getChild("intention.1.0"));
        e.getRoot().getChild("intention.1.0").deleteNode();
        e.getRoot().getChild("action.0.0").deleteNode();
        e.getRoot().getChild("atomic.0.0").deleteNode();
        assertTrue(e.getRoot().getChildrenNodes().isEmpty());
        assertEquals(e.getRoot().getObjectSlots().size(), 1);
        assertNotNull(e.getRoot().getObjectSlot("Other"));

        ObjectSlot slot = e.getRoot().getObjectSlot("Other");
        assertEquals(slot.getUsedObjects().size(), 3);

        e.deriveEpisode();

        EpisodeNode node = e.getRoot();
        slot = node.getObjectSlot("Other");
        assertNull(slot);
        assertEquals(node.getChildrenNodes().size(), 2);
        node = node.getFirstChild().get(e.getIdEpisode());
        assertTrue(node.getObjectSlots().isEmpty());
        String name1 = node.getName();
        node = node.getSuccessor().get(e.getIdEpisode());
        assertTrue(node.getObjectSlots().isEmpty());
        String name2 = node.getName();
        assertTrue((name1.equals("action.1.0") && name2.equals("action.1.1"))
                || (name1.equals("action.1.1") && name2.equals("action.1.0")));

        for (int i = 0; i < 2; i++) {
            node = e.getRoot().getChild("action.1."+i).getChild("intention.1.0");
            assertNotNull(node);
            assertTrue(node.getObjectSlots().isEmpty());
            assertEquals(node.getChildrenNodes().size(), 1);
            node = node.getChild("action.0.0");
            assertNotNull(node);
            assertEquals(node.getObjectSlots().size(), 2);
            slot = node.getObjectSlot("type1");
            assertNotNull(slot);
            assertEquals(slot.getUsedObjects().size(), 2);
            ObjectNode obj = instance.getPresentChronobag().objectNodes.get("obj1");
            assertTrue(slot.getUsedObjects().contains(obj));
            obj = instance.getPresentChronobag().objectNodes.get("obj2");
            slot = node.getObjectSlot("type2");
            assertNotNull(slot);
            assertEquals(slot.getUsedObjects().size(), 2);
            assertTrue(slot.getUsedObjects().contains(obj));
            obj = instance.getPresentChronobag().objectNodes.get("obj3");
            assertTrue(slot.getUsedObjects().contains(obj));
            obj = instance.getPresentChronobag().objectNodes.get("obj1");
            assertFalse(slot.getUsedObjects().contains(obj));
            node = node.getChild("atomic.0.0");
            assertNotNull(node);
            assertTrue(node.getChildrenNodes().isEmpty());
            assertTrue(node.getObjectSlots().isEmpty());
        }

        System.out.println("---/// TEST AGENT MEMORY 06 OK ///---");
    }

    @Test
    public void testAgentMemory07() {
        System.out.println("---/// STARTING AGENT MEMORY 07 ///---");

        int MAX_CHRONOBAG_NODES = Parameters.MAX_CHRONOBAG_NODES;
        int LANDMARK_AGE_THRESHOLD = Parameters.LANDMARK_AGE_THRESHOLDS[0];
        int MAX_CHRONOBAG_LEVELS = Parameters.MAX_CHRONOBAG_LEVELS;
        Parameters.MAX_CHRONOBAG_NODES = 25;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = 1;
        Parameters.MAX_CHRONOBAG_LEVELS = 1;
        instance = new AgentMemory();
        instance.initialize(dTree.topLevelGoals.values());

        ArrayList<String> trace = new ArrayList<String>();
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");

        instance.addNewNode("atomic.0.0", trace, "Mo, 08:00, day 0.", affs);
        for (int i = 0; i < 100; i++) {
            instance.addNewNode("SLEEP", trace, "Mo, 08:00, day "+i+".", affs);
        }

        assertEquals(instance.getChronobags().size(), 100);

        Parameters.MAX_CHRONOBAG_NODES = MAX_CHRONOBAG_NODES;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = LANDMARK_AGE_THRESHOLD;
        Parameters.MAX_CHRONOBAG_LEVELS = MAX_CHRONOBAG_LEVELS;

        System.out.println("---/// TEST AGENT MEMORY 07 OK ///---");
    }

    @Test
    public void testAgentMemory08() {
        System.out.println("---/// STARTING AGENT MEMORY 08 ///---");

        int MAX_CHRONOBAG_NODES = Parameters.MAX_CHRONOBAG_NODES;
        int LANDMARK_AGE_THRESHOLD = Parameters.LANDMARK_AGE_THRESHOLDS[0];
        int MAX_CHRONOBAG_LEVELS = Parameters.MAX_CHRONOBAG_LEVELS;
        Parameters.MAX_CHRONOBAG_NODES = 200;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = 10;
        Parameters.MAX_CHRONOBAG_LEVELS = 4;
        instance = new AgentMemory();
        instance.initialize(dTree.topLevelGoals.values());

        ArrayList<String> trace = new ArrayList<String>();
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");

        instance.addNewNode("atomic.0.0", trace, "Mo, 08:00, day 0.", affs);
        for (int i = 0; i < 10; i++) {
            instance.addNewNode("SLEEP", trace, "Mo, 08:00, day "+i+".", affs);
        }

        assertTrue(instance.getChronobags().size() > 10);

        Parameters.MAX_CHRONOBAG_NODES = MAX_CHRONOBAG_NODES;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = LANDMARK_AGE_THRESHOLD;
        Parameters.MAX_CHRONOBAG_LEVELS = MAX_CHRONOBAG_LEVELS;

        System.out.println("---/// TEST AGENT MEMORY 08 OK ///---");
    }

    private String getParametersHash() {
        String hash = "";
        Field[] fields = Parameters.class.getDeclaredFields();
        for (Field field : fields) {
            try  {
                if (field.getType().isArray()) {
                    int lenght = Array.getLength(field.get(field));
                    for (int i = 0; i < lenght; i++) {
                        hash += Array.get(field.get(field), i);
                    }
                } else {
                    hash += field.get(field).toString();
                }
            } catch (Exception e) {
                System.out.println ("Memory test error: could not retrieve parameter value - " + e );
            }
        }
        return hash;
    }
}