package cz.cuni.amis.pogamut.episodic.episodes;

import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Michal Cermak
 */
public class ObjectSlotTest {

    EpisodeNode node = null;
    ObjectSlot instance = null;

    public ObjectSlotTest() {
    }

    @Before
    public void setUp() {
        AgentMemory mem = new AgentMemory();
        Chronobag ch = new Chronobag(mem.getIdGenerator(), mem);
        Episode e = new Episode(ch);
        node = new EpisodeNode("node", null, e, null);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testObjectSlot01() {
        instance = new ObjectSlot(1, "slot type", node);
        assertEquals(instance.getId(), 1);
        assertEquals(instance.getType(), "slot type");
        assertSame(instance.getParentNode(), node);

        assertTrue(instance.getUsedObjects().isEmpty());

        ObjectNode obj1 = new ObjectNode("object1", 2);
        ObjectNode obj2 = new ObjectNode("object2", 2);
        instance.addObject(obj1, true);
        instance.addObject(obj2, true);
        assertEquals(instance.getUsedObjects().size(), 2);
        assertTrue(instance.getUsedObjects().contains(obj1));
        assertTrue(instance.getUsedObjects().contains(obj2));

        assertEquals(obj1.usedAt.size(), 1);
        assertTrue(obj1.usedAt.contains(instance));
        
        instance.emptySlot();

        assertTrue(instance.getUsedObjects().isEmpty());
        assertTrue(obj1.usedAt.isEmpty());

        System.out.println("---/// TEST OBJECT SLOT 01 OK ///---");
    }

    @Test
    public void testObjectSlot02() {
        instance = new ObjectSlot(1, "slot type", node);

        ObjectNode obj1 = new ObjectNode("object1", 2);
        ObjectNode obj2 = new ObjectNode("object2", 2);
        instance.addObject(obj1, true);
        instance.addObject(obj2, true);

        assertEquals(instance.getUsedObjects().size(), 2);
        assertTrue(instance.getUsedObjects().contains(obj1));
        assertTrue(instance.getUsedObjects().contains(obj2));

        assertNull(instance.getParentNode().slots.get("Other"));
        instance.deleteSlot();
        assertNotNull(instance.getParentNode().slots.get("Other"));

        ObjectSlot other = instance.getParentNode().slots.get("Other");

        assertTrue(instance.getUsedObjects().isEmpty());
        assertEquals(other.getUsedObjects().size(), 2);
        assertTrue(other.getUsedObjects().contains(obj1));
        assertTrue(other.getUsedObjects().contains(obj2));

        assertEquals(obj1.usedAt.size(), 1);
        assertSame(obj1.usedAt.iterator().next(), other);
        assertEquals(obj2.usedAt.size(), 1);
        assertSame(obj2.usedAt.iterator().next(), other);

        System.out.println("---/// TEST OBJECT SLOT 02 OK ///---");
    }

}