/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.visualizer;

import cz.cuni.amis.pogamut.episodic.schemas.ISchemaMessageCommand;
import cz.cuni.amis.pogamut.episodic.visualizer.EdgeType;
import cz.cuni.amis.pogamut.episodic.visualizer.VertexType;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.algorithms.shortestpath.MinimumSpanningForest2;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractPopupGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class VisualizationRenderer {
    final int MARGIN_WIDTH = 50;
    final int MAX_LABEL_LENGTH = 20;
    private int schemaGraphIndex;
    protected Map<Integer, Graph<Integer, Integer>> graphs = new HashMap<Integer, Graph<Integer, Integer>>();
    protected Map<Integer, Layout<Integer, Integer>> layouts = new HashMap<Integer, Layout<Integer, Integer>>();
    protected Map<Integer, String> graph_names = new HashMap<Integer, String>();
    protected Integer lastSchemaEpisodeNode = 0;
    protected Map<Integer, Integer> lastNonObjectNode = new HashMap<Integer, Integer>();
    private AdditionalInfo info = new AdditionalInfo();
    boolean refresh = true;
    Map<Integer, ObjectVertex> objectVertices = new HashMap<Integer, ObjectVertex>();
    Map<Integer, HideEdge> noSpanningEdges = new HashMap<Integer, HideEdge>();
    protected int graph_index;
    ISchemaMessageCommand schemaMessageCommand = null;
    JTextArea textArea;
    JScrollPane scrollPane;
    JDialog infoDialog = new JDialog();
    private EdgeDisplayPredicate<Integer, Integer> showEdge;
    VisualizationViewer<Integer, Integer> vv;
    VisualizationModel<Integer, Integer> vm;
    JComboBox graph_chooser;

    public VisualizationRenderer() {
        DirectedSparseGraph graph = new DirectedSparseGraph();
        StaticLayout layout = new StaticLayout((Graph)graph);
        this.vm = new DefaultVisualizationModel((Layout)layout);
        this.vv = new VisualizationViewer(this.vm);
        this.showEdge = new EdgeDisplayPredicate(true, true, true);
        this.vv.getRenderContext().setEdgeIncludePredicate(this.showEdge);
        this.vv.getRenderContext().setVertexLabelTransformer((Transformer)new Transformer<Integer, String>(){

            public String transform(Integer v) {
                if (((VisualizationRenderer)VisualizationRenderer.this).info.showLabels.get((Object)VertexType.DEFAULT_VERTEX).booleanValue() && (!((VisualizationRenderer)VisualizationRenderer.this).info.vertexTypes.containsKey(v) || ((VisualizationRenderer)VisualizationRenderer.this).info.showLabels.get((Object)((VisualizationRenderer)VisualizationRenderer.this).info.vertexTypes.get(v)).booleanValue())) {
                    return ((VisualizationRenderer)VisualizationRenderer.this).info.vertexLabels.get(v);
                }
                return "";
            }
        });
        this.vv.getRenderContext().setVertexFillPaintTransformer((Transformer)new Transformer<Integer, Paint>(){

            public Paint transform(Integer v) {
                if (VisualizationRenderer.this.vv.getPickedVertexState().isPicked((Object)v)) {
                    return Color.YELLOW;
                }
                if (((VisualizationRenderer)VisualizationRenderer.this).info.vertexColors.containsKey(v)) {
                    if (((VisualizationRenderer)VisualizationRenderer.this).info.vertexSaturation.containsKey(v)) {
                        double saturation = ((VisualizationRenderer)VisualizationRenderer.this).info.vertexSaturation.get(v);
                        Color c = ((VisualizationRenderer)VisualizationRenderer.this).info.vertexColors.get(v);
                        int blue = c.getBlue();
                        int red = c.getRed();
                        int green = c.getGreen();
                        blue = (int)Math.round((double)(255 - blue) * (1.0 - saturation)) + blue;
                        red = (int)Math.round((double)(255 - red) * (1.0 - saturation)) + red;
                        green = (int)Math.round((double)(255 - green) * (1.0 - saturation)) + green;
                        return new Color(red, green, blue);
                    }
                    return ((VisualizationRenderer)VisualizationRenderer.this).info.vertexColors.get(v);
                }
                return Color.RED;
            }
        });
        this.vv.setEdgeToolTipTransformer((Transformer)new Transformer<Integer, String>(){

            public String transform(Integer v) {
                if (((VisualizationRenderer)VisualizationRenderer.this).info.edgeTooltips.containsKey(v)) {
                    return ((VisualizationRenderer)VisualizationRenderer.this).info.edgeTooltips.get(v);
                }
                return "";
            }
        });
        this.vv.setVertexToolTipTransformer((Transformer)new Transformer<Integer, String>(){

            public String transform(Integer v) {
                if (((VisualizationRenderer)VisualizationRenderer.this).info.vertexTooltips.containsKey(v)) {
                    return ((VisualizationRenderer)VisualizationRenderer.this).info.vertexTooltips.get(v);
                }
                return ((VisualizationRenderer)VisualizationRenderer.this).info.vertexLabels.get(v);
            }
        });
        this.vv.getRenderContext().setEdgeDrawPaintTransformer((Transformer)new Transformer<Integer, Paint>(){

            public Paint transform(Integer e) {
                HashSet picked = new HashSet(VisualizationRenderer.this.vv.getPickedVertexState().getPicked());
                Integer id = e;
                if (picked.contains(VisualizationRenderer.this.graphs.get(VisualizationRenderer.this.graph_index).getDest((Object)id)) || picked.contains(VisualizationRenderer.this.graphs.get(VisualizationRenderer.this.graph_index).getSource((Object)id))) {
                    return Color.BLACK;
                }
                if (((VisualizationRenderer)VisualizationRenderer.this).info.edgeColors.containsKey(e)) {
                    return ((VisualizationRenderer)VisualizationRenderer.this).info.edgeColors.get(e);
                }
                return Color.LIGHT_GRAY;
            }
        });
        this.vv.getRenderContext().setArrowDrawPaintTransformer((Transformer)new Transformer<Integer, Paint>(){

            public Paint transform(Integer e) {
                if (((VisualizationRenderer)VisualizationRenderer.this).info.edgeColors.containsKey(e)) {
                    return ((VisualizationRenderer)VisualizationRenderer.this).info.edgeColors.get(e);
                }
                return Color.BLACK;
            }
        });
        this.vv.getRenderContext().setArrowFillPaintTransformer((Transformer)new Transformer<Integer, Paint>(){

            public Paint transform(Integer e) {
                if (((VisualizationRenderer)VisualizationRenderer.this).info.edgeColors.containsKey(e)) {
                    return ((VisualizationRenderer)VisualizationRenderer.this).info.edgeColors.get(e);
                }
                return Color.BLACK;
            }
        });
        JFrame frame = new JFrame();
        frame.setTitle("Chronobag Viewer");
        Container content = frame.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add((Component)panel);
        frame.setDefaultCloseOperation(3);
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        this.vv.addKeyListener(gm.getModeKeyListener());
        gm.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        gm.add((GraphMousePlugin)new PopupGraphMousePlugin());
        this.textArea = new JTextArea(6, 30);
        this.scrollPane = new JScrollPane(this.textArea, 20, 31);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        this.infoDialog.getContentPane().add(this.scrollPane);
        this.infoDialog.pack();
        this.infoDialog.setAlwaysOnTop(true);
        this.infoDialog.setSize(new Dimension(300, 300));
        this.vv.setName("");
        this.vv.addPostRenderPaintable(new VisualizationServer.Paintable(){
            int x;
            int y;
            Font font;
            FontMetrics metrics;
            int swidth;
            int sheight;
            String str;

            public void paint(Graphics g) {
                this.str = VisualizationRenderer.this.vv.getName();
                Dimension d = VisualizationRenderer.this.vv.getSize();
                if (this.font == null) {
                    this.font = new Font(g.getFont().getName(), 1, 20);
                    this.metrics = g.getFontMetrics(this.font);
                    this.swidth = this.metrics.stringWidth(this.str);
                    this.sheight = this.metrics.getMaxAscent() + this.metrics.getMaxDescent();
                    this.x = 50;
                    this.y = (int)((double)d.height - (double)this.sheight * 1.5);
                }
                g.setFont(this.font);
                Color oldColor = g.getColor();
                g.setColor(Color.DARK_GRAY);
                g.drawString(this.str, this.x, this.y);
                g.setColor(oldColor);
            }

            public boolean useTransform() {
                return false;
            }
        });
        Box graph_panel = Box.createVerticalBox();
        graph_panel.setBorder(BorderFactory.createTitledBorder("Structure"));
        this.graph_chooser = new JComboBox<Object>(this.graph_names.values().toArray());
        this.graph_chooser.addActionListener(new GraphChooser(this));
        graph_panel.add(this.graph_chooser);
        JCheckBox refreshCheckBox = new JCheckBox("Refresh");
        refreshCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean bl = VisualizationRenderer.this.refresh = e.getStateChange() == 1;
                if (VisualizationRenderer.this.graph_index == VisualizationRenderer.this.schemaGraphIndex && VisualizationRenderer.this.graphs.containsKey(VisualizationRenderer.this.schemaGraphIndex) && VisualizationRenderer.this.graphs.get(VisualizationRenderer.this.schemaGraphIndex).getVertexCount() > 0) {
                    VisualizationRenderer.this.returnNoSpanningEdges(VisualizationRenderer.this.schemaGraphIndex, VisualizationRenderer.this.lastSchemaEpisodeNode);
                }
                if (VisualizationRenderer.this.lastNonObjectNode.containsKey(VisualizationRenderer.this.graph_index)) {
                    VisualizationRenderer.this.positionObjectNodes(VisualizationRenderer.this.lastNonObjectNode.get(VisualizationRenderer.this.graph_index) + 50);
                }
                VisualizationRenderer.this.vv.repaint();
            }
        });
        refreshCheckBox.setSelected(true);
        graph_panel.add(refreshCheckBox);
        Box labels_panel = Box.createVerticalBox();
        labels_panel.setBorder(BorderFactory.createTitledBorder("Labels"));
        JCheckBox allLabelsCheckBox = new JCheckBox("All Labels");
        allLabelsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((VisualizationRenderer)VisualizationRenderer.this).info.showLabels.put(VertexType.DEFAULT_VERTEX, e.getStateChange() == 1);
                VisualizationRenderer.this.vv.repaint();
            }
        });
        this.info.showLabels.put(VertexType.DEFAULT_VERTEX, Boolean.TRUE);
        allLabelsCheckBox.setSelected(true);
        labels_panel.add(allLabelsCheckBox);
        JCheckBox actionLabelsCheckBox = new JCheckBox("Actions");
        actionLabelsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((VisualizationRenderer)VisualizationRenderer.this).info.showLabels.put(VertexType.ACTION, e.getStateChange() == 1);
                VisualizationRenderer.this.vv.repaint();
            }
        });
        this.info.showLabels.put(VertexType.ACTION, Boolean.TRUE);
        actionLabelsCheckBox.setSelected(true);
        labels_panel.add(actionLabelsCheckBox);
        JCheckBox intentionLabelsCheckBox = new JCheckBox("Intentions");
        intentionLabelsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((VisualizationRenderer)VisualizationRenderer.this).info.showLabels.put(VertexType.INTENTION, e.getStateChange() == 1);
                VisualizationRenderer.this.vv.repaint();
            }
        });
        this.info.showLabels.put(VertexType.INTENTION, Boolean.TRUE);
        intentionLabelsCheckBox.setSelected(true);
        labels_panel.add(intentionLabelsCheckBox);
        JCheckBox atomicLabelsCheckBox = new JCheckBox("Atomic actions");
        atomicLabelsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((VisualizationRenderer)VisualizationRenderer.this).info.showLabels.put(VertexType.ATOMIC_ACTION, e.getStateChange() == 1);
                VisualizationRenderer.this.vv.repaint();
            }
        });
        this.info.showLabels.put(VertexType.ATOMIC_ACTION, Boolean.TRUE);
        atomicLabelsCheckBox.setSelected(true);
        labels_panel.add(atomicLabelsCheckBox);
        JCheckBox affordancesLabelsCheckBox = new JCheckBox("Affordances");
        affordancesLabelsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((VisualizationRenderer)VisualizationRenderer.this).info.showLabels.put(VertexType.AFFORDANCE, e.getStateChange() == 1);
                VisualizationRenderer.this.vv.repaint();
            }
        });
        this.info.showLabels.put(VertexType.AFFORDANCE, Boolean.TRUE);
        affordancesLabelsCheckBox.setSelected(true);
        labels_panel.add(affordancesLabelsCheckBox);
        JCheckBox objectsLabelsCheckBox = new JCheckBox("Object nodes");
        objectsLabelsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((VisualizationRenderer)VisualizationRenderer.this).info.showLabels.put(VertexType.OBJECT, e.getStateChange() == 1);
                VisualizationRenderer.this.vv.repaint();
            }
        });
        this.info.showLabels.put(VertexType.OBJECT, Boolean.TRUE);
        objectsLabelsCheckBox.setSelected(true);
        labels_panel.add(objectsLabelsCheckBox);
        Box showEdgePanel = Box.createVerticalBox();
        showEdgePanel.setBorder(BorderFactory.createTitledBorder("Edges"));
        JCheckBox subNodesCheckbox = new JCheckBox("Subnode edges");
        subNodesCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VisualizationRenderer.this.showEdge.showSubNodes(e.getStateChange() == 1);
                VisualizationRenderer.this.vv.repaint();
            }
        });
        subNodesCheckbox.setSelected(true);
        showEdgePanel.add(subNodesCheckbox);
        JCheckBox sequenceCheckbox = new JCheckBox("Sequence edges");
        sequenceCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VisualizationRenderer.this.showEdge.showSequence(e.getStateChange() == 1);
                VisualizationRenderer.this.vv.repaint();
            }
        });
        sequenceCheckbox.setSelected(true);
        showEdgePanel.add(sequenceCheckbox);
        JCheckBox objectEdgeCheckbox = new JCheckBox("Object edges");
        objectEdgeCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VisualizationRenderer.this.showEdge.showObject(e.getStateChange() == 1);
                VisualizationRenderer.this.vv.repaint();
            }
        });
        objectEdgeCheckbox.setSelected(true);
        showEdgePanel.add(objectEdgeCheckbox);
        JPanel modePanel = new JPanel();
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modePanel.add(gm.getModeComboBox());
        JPanel middlePanel = new JPanel(new GridLayout(0, 1));
        middlePanel.add((Component)labels_panel, "Center");
        middlePanel.add((Component)showEdgePanel, "Center");
        JPanel controls = new JPanel();
        controls.setLayout(new BorderLayout());
        controls.add((Component)graph_panel, "North");
        controls.add((Component)middlePanel, "Center");
        controls.add((Component)modePanel, "South");
        content.add((Component)controls, "East");
        frame.pack();
        frame.setVisible(true);
    }

    public void setSchemaMessageCommand(ISchemaMessageCommand command, int schemaGraph) {
        this.schemaGraphIndex = schemaGraph;
        this.schemaMessageCommand = command;
    }

    public void updateTime(String time) {
        this.vv.setName(time);
        this.vv.repaint();
    }

    public void positionObjectNodes(int y) {
        y += 50;
        Double x = -this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).getTranslateX();
        for (ObjectVertex v : this.objectVertices.values()) {
            boolean contain = v.graphs.contains(this.graph_index);
            if (!contain) continue;
            x = x + 50.0;
            this.layouts.get(this.graph_index).setLocation((Object)v.id, (Point2D)new Point2D.Double(x, y));
        }
    }

    private void drawGraph(int index) {
        this.vm.setGraphLayout(this.layouts.get(index));
    }

    public void addVertex(int index, int id, String label) {
        this.graphs.get(index).addVertex((Object)new Integer(id));
        this.info.vertexLabels.put(id, label);
    }

    public void addVertex(int index, int id, String label, Color c, VertexType type) {
        this.addVertex(index, id, 0.0, 0.0, label, c, type);
    }

    public void addVertex(int index, int id, double x, double y, String label, Color c) {
        this.addVertex(index, id, x, y, label, c, VertexType.DEFAULT_VERTEX);
    }

    public void addVertex(int index, int id, double x, double y, String label, Color c, VertexType type) {
        if (label.length() > 20) {
            label = label.substring(0, 20);
        }
        this.graphs.get(index).addVertex((Object)new Integer(id));
        this.info.vertexLabels.put(id, label);
        this.info.vertexTypes.put(id, type);
        this.info.vertexColors.put(id, c);
        if (type == VertexType.OBJECT) {
            ObjectVertex objectVertex = this.objectVertices.get(id);
            if (objectVertex == null) {
                objectVertex = new ObjectVertex(id);
            }
            objectVertex.graphs.add(index);
            this.objectVertices.put(id, objectVertex);
        }
        this.layouts.get(index).setLocation((Object)id, (Point2D)new Point2D.Double(x + 50.0, y + 50.0));
    }

    public void setVertexLocation(int graph, int id, double x, double y) {
        this.layouts.get(graph).setLocation((Object)id, (Point2D)new Point2D.Double(x + 50.0, y + 50.0));
    }

    public boolean addEdge(int index, int id, int v1, int v2, String label, Color c) {
        return this.addEdge(index, id, EdgeType.SUBNODE, v1, v2, label, c);
    }

    public boolean addEdge(int index, int id, EdgeType type, int v1, int v2, String label, Color c) {
        boolean success = this.graphs.get(index).addEdge((Object)id, (Object)v1, (Object)v2);
        if (!success) {
            return false;
        }
        this.info.edgeColors.put(id, c);
        this.info.edgeType.put(id, type);
        if (!type.spanning) {
            this.noSpanningEdges.put(id, new HideEdge(id, index, v1, v2));
        }
        if (type == EdgeType.OBJECT) {
            ObjectVertex objectVertex = null;
            if (this.objectVertices.containsKey(v1)) {
                objectVertex = this.objectVertices.get(v1);
            }
            if (this.objectVertices.containsKey(v2)) {
                objectVertex = this.objectVertices.get(v2);
            }
            if (objectVertex == null) {
                return true;
            }
            objectVertex.graphs.add(index);
            if (this.info.vertexTypes.get(v1) == VertexType.AFFORDANCE) {
                objectVertex.slots.put(id, v1);
            }
            if (this.info.vertexTypes.get(v2) == VertexType.AFFORDANCE) {
                objectVertex.slots.put(id, v2);
            }
        }
        return true;
    }

    public void removeEdge(int index, int id) {
        this.info.edgeColors.remove(id);
        this.info.edgeType.remove(id);
        this.noSpanningEdges.remove(id);
        this.graphs.get(index).removeEdge((Object)id);
    }

    public void setVertexDetail(int id, String tip) {
        this.info.vertexDetail.put(id, tip);
    }

    public void setVertexSaturation(int id, double saturation) {
        assert (saturation <= 1.0);
        assert (saturation >= 0.0);
        this.info.vertexSaturation.put(id, saturation);
    }

    public void setVertexTooltip(int id, String tip) {
        this.info.vertexTooltips.put(id, tip);
    }

    public void setEdgeTooltip(int id, String tip) {
        this.info.edgeTooltips.put(id, tip);
    }

    public boolean addGraph(int index, String label, Dimension dim) {
        if (dim == null) {
            dim = new Dimension(1000, 500);
        }
        if (this.graph_names.containsValue(label) || this.graphs.containsKey(index)) {
            return false;
        }
        this.graphs.put(index, (Graph<Integer, Integer>)new DirectedSparseGraph());
        this.graph_names.put(index, label);
        this.layouts.put(index, (Layout<Integer, Integer>)new StaticLayout(this.graphs.get(index)));
        dim.height += 100;
        dim.width += 100;
        this.layouts.get(index).setSize(dim);
        this.graph_chooser.addItem(label);
        return true;
    }

    private void removeVertices(int index) {
        Graph<Integer, Integer> g = this.graphs.get(index);
        HashSet col = new HashSet();
        col.addAll(g.getEdges());
        for (Integer e : col) {
            this.noSpanningEdges.remove(e);
            this.info.removeEdge(e);
            g.removeEdge((Object)e);
        }
        col.clear();
        col.addAll(g.getVertices());
        for (Integer v : col) {
            if (this.objectVertices.containsKey(v)) {
                this.objectVertices.get((Object)v).graphs.remove(index);
                if (this.objectVertices.get((Object)v).graphs.isEmpty()) {
                    this.objectVertices.remove(v);
                }
            }
            this.info.removeVertex(v);
            g.removeVertex((Object)v);
        }
    }

    public boolean removeGraph(int index) {
        if (!this.graphs.containsKey(index)) {
            return false;
        }
        this.clearGraph(index);
        this.graphs.remove(index);
        this.graph_chooser.removeItem(this.graph_names.get(index));
        this.graph_names.remove(index);
        this.layouts.remove(index);
        return true;
    }

    public boolean clearGraph(int index) {
        if (!this.graphs.containsKey(index)) {
            return false;
        }
        Iterator<Map.Entry<Integer, HideEdge>> i = this.noSpanningEdges.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, HideEdge> entry = i.next();
            if (entry.getValue().graph != index) continue;
            i.remove();
        }
        this.removeVertices(index);
        return true;
    }

    private void removeNoSpanningEdges(int index) {
        for (HideEdge e : this.noSpanningEdges.values()) {
            if (e.graph != index) continue;
            this.graphs.get(index).removeEdge((Object)e.id);
        }
        for (ObjectVertex v : this.objectVertices.values()) {
            boolean foo = v.graphs.contains(index);
            if (!foo) continue;
            this.graphs.get(index).removeVertex((Object)v.id);
        }
    }

    private void returnNoSpanningEdges(int index, int depth) {
        for (HideEdge e : this.noSpanningEdges.values()) {
            if (e.graph != index) continue;
            this.graphs.get(index).addEdge((Object)e.id, (Object)e.v1, (Object)e.v2);
        }
        Double x = -this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).getTranslateX();
        for (ObjectVertex v : this.objectVertices.values()) {
            if (!v.graphs.contains(index)) continue;
            this.graphs.get(index).addVertex((Object)v.id);
            this.layouts.get(index).setLocation((Object)v.id, (Point2D)new Point2D.Double(x + 50.0, depth + 50));
            x = x + 50.0;
        }
    }

    public void createTreeLayout(int index) {
        this.removeNoSpanningEdges(index);
        Graph<Integer, Integer> graph = this.graphs.get(index);
        if (graph == null) {
            return;
        }
        MinimumSpanningForest2 prim = new MinimumSpanningForest2(graph, (Forest)new DelegateForest(), DelegateTree.getFactory(), (Transformer)new ConstantTransformer((Object)1.0));
        Forest tree = prim.getForest();
        int depth = 0;
        Collection trees = tree.getTrees();
        for (Tree t : trees) {
            if (t.getHeight() <= depth) continue;
            depth = t.getHeight();
        }
        depth = (depth + 1) * 60;
        TreeLayout layoutTree = new TreeLayout(tree);
        StaticLayout layout = new StaticLayout(graph, (Transformer)layoutTree);
        this.layouts.put(index, (Layout<Integer, Integer>)layout);
        this.vm.setGraphLayout(this.layouts.get(this.graph_index));
        if (index == this.schemaGraphIndex) {
            this.lastSchemaEpisodeNode = depth;
        }
        this.returnNoSpanningEdges(index, depth);
    }

    private final class EdgeDisplayPredicate<V, E>
    implements Predicate<Context<Graph<V, E>, E>> {
        protected boolean showSubNodes;
        protected boolean showSequence;
        protected boolean showObject;

        public EdgeDisplayPredicate(boolean showSub, boolean showSeq, boolean showObj) {
            this.showSubNodes = showSub;
            this.showSequence = showSeq;
            this.showObject = showObj;
        }

        public void showSubNodes(boolean b) {
            this.showSubNodes = b;
        }

        public void showSequence(boolean b) {
            this.showSequence = b;
        }

        public void showObject(boolean b) {
            this.showObject = b;
        }

        public boolean evaluate(Context<Graph<V, E>, E> context) {
            Object e = context.element;
            HashSet picked = new HashSet(VisualizationRenderer.this.vv.getPickedVertexState().getPicked());
            Integer id = (Integer)e;
            if (picked.contains(VisualizationRenderer.this.graphs.get(VisualizationRenderer.this.graph_index).getDest((Object)id)) || picked.contains(VisualizationRenderer.this.graphs.get(VisualizationRenderer.this.graph_index).getSource((Object)id))) {
                return true;
            }
            if (((VisualizationRenderer)VisualizationRenderer.this).info.edgeType.get(id) == EdgeType.SUBNODE && this.showSubNodes) {
                return true;
            }
            if (((VisualizationRenderer)VisualizationRenderer.this).info.edgeType.get(id) == EdgeType.SEQUENCE && this.showSequence) {
                return true;
            }
            return ((VisualizationRenderer)VisualizationRenderer.this).info.edgeType.get(id) == EdgeType.OBJECT && this.showObject;
        }
    }

    protected class PopupGraphMousePlugin
    extends AbstractPopupGraphMousePlugin
    implements MouseListener {
        public PopupGraphMousePlugin() {
            this(4);
        }

        public PopupGraphMousePlugin(int modifiers) {
            super(modifiers);
        }

        protected void handlePopup(MouseEvent e) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point p = e.getPoint();
            if (VisualizationRenderer.this.graph_index == VisualizationRenderer.this.schemaGraphIndex) {
                HashSet<Integer> picked = new HashSet<Integer>(vv.getPickedVertexState().getPicked());
                VisualizationRenderer.this.textArea.setText(VisualizationRenderer.this.schemaMessageCommand.getSchemaMessage(picked));
                VisualizationRenderer.this.infoDialog.setVisible(true);
                return;
            }
            GraphElementAccessor pickSupport = vv.getPickSupport();
            if (pickSupport != null) {
                Integer v = (Integer)pickSupport.getVertex(vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
                if (v != null) {
                    if (((VisualizationRenderer)VisualizationRenderer.this).info.vertexDetail.containsKey(v)) {
                        VisualizationRenderer.this.textArea.setText(((VisualizationRenderer)VisualizationRenderer.this).info.vertexDetail.get(v));
                        VisualizationRenderer.this.infoDialog.setVisible(true);
                    }
                } else {
                    Number edge = (Number)pickSupport.getEdge(vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
                    if (edge != null) {
                        // empty if block
                    }
                }
            }
        }
    }

    public class GraphChooser
    implements ActionListener {
        VisualizationRenderer viz;

        public GraphChooser(VisualizationRenderer _viz) {
            this.viz = _viz;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            VisualizationRenderer.this.graph_index = cb.getSelectedIndex();
            this.viz.drawGraph(VisualizationRenderer.this.graph_index);
            if (VisualizationRenderer.this.lastNonObjectNode.containsKey(VisualizationRenderer.this.graph_index)) {
                VisualizationRenderer.this.positionObjectNodes(VisualizationRenderer.this.lastNonObjectNode.get(VisualizationRenderer.this.graph_index) + 50);
            }
        }
    }

    public class HideEdge {
        int id;
        int graph;
        Integer v1;
        Integer v2;

        HideEdge(int _id, int _graph, int _v1, int _v2) {
            this.id = _id;
            this.graph = _graph;
            this.v1 = _v1;
            this.v2 = _v2;
        }
    }

    public class ObjectVertex {
        public int id;
        public HashSet<Integer> graphs = new HashSet();
        public HashMap<Integer, Integer> slots = new HashMap();

        public ObjectVertex(int _id) {
            this.id = _id;
        }
    }

    public class AdditionalInfo {
        Map<Integer, String> vertexLabels = new HashMap<Integer, String>();
        Map<Integer, String> vertexTooltips = new HashMap<Integer, String>();
        Map<Integer, String> vertexDetail = new HashMap<Integer, String>();
        Map<Integer, String> edgeTooltips = new HashMap<Integer, String>();
        Map<Integer, VertexType> vertexTypes = new HashMap<Integer, VertexType>();
        Map<Integer, Paint> edgeColors = new HashMap<Integer, Paint>();
        Map<Integer, EdgeType> edgeType = new HashMap<Integer, EdgeType>();
        Map<Integer, Color> vertexColors = new HashMap<Integer, Color>();
        Map<Integer, Double> vertexSaturation = new HashMap<Integer, Double>();
        Map<VertexType, Boolean> showLabels = new HashMap<VertexType, Boolean>();

        void removeEdge(Integer e) {
            this.edgeColors.remove(e);
            this.edgeTooltips.remove(e);
            this.edgeType.remove(e);
        }

        void removeVertex(Integer v) {
            this.vertexColors.remove(v);
            this.vertexDetail.remove(v);
            this.vertexLabels.remove(v);
            this.vertexTooltips.remove(v);
            this.vertexTypes.remove(v);
            this.vertexSaturation.remove(v);
        }
    }
}

