/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.visualizer;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.AffordanceSlot;
import cz.cuni.amis.pogamut.episodic.decisions.AtomicAction;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTree;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.episodes.EpisodeNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectSlot;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.memory.Parameters;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaBag;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaObjectNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaSlot;
import cz.cuni.amis.pogamut.episodic.schemas.SlotContent;
import cz.cuni.amis.pogamut.episodic.visualizer.EdgeType;
import cz.cuni.amis.pogamut.episodic.visualizer.IVisualizationListener;
import cz.cuni.amis.pogamut.episodic.visualizer.VertexType;
import cz.cuni.amis.pogamut.episodic.visualizer.VisualizationEvent;
import cz.cuni.amis.pogamut.episodic.visualizer.VisualizationRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Stack;

public class VisualizationCreator
implements IVisualizationListener {
    VisualizationRenderer visualizer = new VisualizationRenderer();
    private int edgeIdCounter = 0;
    final int DECISION_GRAPH_INDEX = 0;
    final int CHRONOBAG_VIEW_INDEX = 1;
    final int SCHEMA_GRAPH_INDEX = 2;
    final int PRESENT_GRAPH_INDEX = 3;
    final int PAST_GRAPH_START_INDEX = 4;
    private Integer numberOfPastChronobags = 0;
    final Color COLOR_DEFAULT_VERTEX = Color.LIGHT_GRAY;
    final Color COLOR_INTENTION = Color.GREEN;
    final Color COLOR_ACTION = Color.RED;
    final Color COLOR_ATOMIC_ACTION = Color.ORANGE;
    final Color COLOR_AFFORDANCE = Color.DARK_GRAY;
    final Color COLOR_EDGE_STANDARD = Color.GRAY;
    final Color COLOR_EDGE_SEQUENCE = Color.BLUE;
    final Color COLOR_EPISODE_NODE = Color.LIGHT_GRAY;
    final Color COLOR_OBJECT = Color.BLUE;
    private int numberOfSchemaBagNodes = 0;
    private int maxY = 0;

    @Override
    public void handleVisualizationEvent(VisualizationEvent e) {
        switch (e.type) {
            case INITIALIZATION: {
                this.createDecisionTree(e.mem.getDecisionTree());
                this.createChronobagView(e.mem);
                this.createSchemaBag(e.mem.getSchemaBag());
                this.refreshSchemaBag(e.mem.getSchemaBag());
                this.createPresentChronobag(e.mem.getPresentChronobag());
                this.refreshPastChronobags(e.mem.getPastChrononags());
                this.refreshPresentChronobag(e.mem.getPresentChronobag());
                break;
            }
            case DECISION_TREE_UPDATE: {
                this.createDecisionTree(e.mem.getDecisionTree());
                break;
            }
            case REFRESH_CHRONOBAG_VIEW: {
                this.refreshChronobagView(e.mem.getSchemaBag(), e.mem.getChronobags());
                break;
            }
            case REFRESH_PAST_CHRONOBAGS: {
                this.refreshPastChronobags(e.mem.getPastChrononags());
                break;
            }
            case REFRESH_PRESENT_CHRONOBAG: {
                this.refreshPresentChronobag(e.mem.getPresentChronobag());
                break;
            }
            case REFRESH_SCHEMA_BAG: {
                this.refreshSchemaBag(e.mem.getSchemaBag());
                break;
            }
            case UPDATE_TIME: {
                this.visualizer.updateTime(e.time);
            }
        }
    }

    public void refreshPastChronobags(HashSet<Chronobag> past) {
        int index;
        this.visualizer.removeGraph(3);
        for (index = 0; index < this.numberOfPastChronobags; ++index) {
            this.visualizer.removeGraph(4 + index);
        }
        this.numberOfPastChronobags = past.size();
        this.visualizer.addGraph(3, "Present day", new Dimension(1000, 600));
        index = 0;
        for (Chronobag c : past) {
            String strDaysAgo = "";
            strDaysAgo = c.getAge().toString() + " day(s) ago";
            this.visualizer.addGraph(4 + index, strDaysAgo, new Dimension(1000, 600));
            this.refreshChronobag(c, 4 + index);
            ++index;
        }
    }

    public void refreshPresentChronobag(Chronobag present) {
        this.refreshChronobag(present, 3);
    }

    public void refreshChronobag(Chronobag chronobag, int graphIndex) {
        if (!this.visualizer.refresh) {
            return;
        }
        this.visualizer.clearGraph(graphIndex);
        this.visualizer.addGraph(graphIndex, "", null);
        for (Episode e : chronobag.getEpisodes()) {
            this.displayChronobagNode(graphIndex, e.getRoot());
        }
        this.createTreeLayout(chronobag, graphIndex);
        for (Episode e1 : chronobag.getEpisodes()) {
            for (Episode e2 : e1.next) {
                int id1 = e1.getRoot().getId();
                int id2 = e2.getRoot().getId();
                this.visualizer.addEdge(graphIndex, this.edgeIdCounter++, EdgeType.SEQUENCE, e1.getRoot().getId(), e2.getRoot().getId(), "", this.COLOR_EDGE_SEQUENCE);
            }
        }
    }

    private void displayChronobagNode(int graph, EpisodeNode node) {
        if (node == null) {
            return;
        }
        Color color = this.COLOR_EPISODE_NODE;
        VertexType vtype = VertexType.DEFAULT_VERTEX;
        if (node.getAssociatedNode() != null) {
            switch (node.getAssociatedNode().getType()) {
                case ACTION: {
                    color = this.COLOR_ACTION;
                    vtype = VertexType.ACTION;
                    break;
                }
                case INTENTION: {
                    color = this.COLOR_INTENTION;
                    vtype = VertexType.INTENTION;
                    break;
                }
                case ATOMIC_ACTION: {
                    color = this.COLOR_ATOMIC_ACTION;
                    vtype = VertexType.ATOMIC_ACTION;
                }
            }
        }
        this.visualizer.addVertex(graph, node.getId(), node.getName(), color, vtype);
        String str = Integer.valueOf(node.getId()).toString() + " " + node.getName();
        this.visualizer.setVertexTooltip(node.getId(), str);
        this.visualizer.setVertexDetail(node.getId(), node.toString());
        this.visualizer.setVertexSaturation(node.getId(), node.getScore() / Parameters.MAX_NODE_SCORE);
        for (ObjectSlot slot : node.getObjectSlots()) {
            this.visualizer.addVertex(graph, slot.getId(), slot.getType(), this.COLOR_AFFORDANCE, VertexType.AFFORDANCE);
            str = Integer.valueOf(slot.getId()).toString() + " " + slot.getType();
            this.visualizer.setVertexTooltip(slot.getId(), str);
            this.visualizer.addEdge(graph, this.edgeIdCounter++, node.getId(), slot.getId(), "", this.COLOR_EDGE_STANDARD);
            for (ObjectNode obj : slot.getUsedObjects()) {
                this.visualizer.addVertex(graph, obj.getId(), obj.getName(), this.COLOR_OBJECT, VertexType.OBJECT);
                str = Integer.valueOf(obj.getId()).toString() + " " + obj.getName();
                this.visualizer.setVertexTooltip(obj.getId(), str);
                this.visualizer.addEdge(graph, this.edgeIdCounter++, EdgeType.OBJECT, obj.getId(), slot.getId(), "", this.COLOR_EDGE_STANDARD);
            }
        }
        for (EpisodeNode n : node.getChildrenNodes()) {
            this.displayChronobagNode(graph, n);
            this.visualizer.addEdge(graph, this.edgeIdCounter++, node.getId(), n.getId(), "", this.COLOR_EDGE_STANDARD);
        }
        for (EpisodeNode n1 : node.getChildrenNodes()) {
            for (EpisodeNode n2 : n1.getSuccessor().values()) {
                if (n2 == null) continue;
                this.visualizer.addEdge(graph, this.edgeIdCounter++, EdgeType.SEQUENCE, n1.getId(), n2.getId(), "", this.COLOR_EDGE_SEQUENCE);
            }
        }
    }

    public void createPresentChronobag(Chronobag bag) {
        this.visualizer.addGraph(3, "Present day", new Dimension(1000, 600));
        this.refreshPresentChronobag(bag);
    }

    private int displayIntentionTree(int graph, Intention i) throws Exception {
        this.visualizer.addVertex(graph, i.getId(), i.getName(), this.COLOR_INTENTION, VertexType.INTENTION);
        this.visualizer.setVertexTooltip(i.getId(), Integer.valueOf(i.getId()).toString() + " " + i.getName());
        for (AffordanceSlot slot : i.getAffordances()) {
            this.visualizer.addVertex(graph, slot.getId(), slot.getType(), this.COLOR_AFFORDANCE, VertexType.AFFORDANCE);
            this.visualizer.setVertexTooltip(slot.getId(), Integer.valueOf(slot.getId()).toString() + " " + slot.getType());
            this.visualizer.addEdge(graph, this.edgeIdCounter++, i.getId(), slot.getId(), "", this.COLOR_EDGE_STANDARD);
        }
        for (Action a : i.getSubNodes()) {
            int id = this.displayActionTree(graph, a);
            this.visualizer.addEdge(graph, this.edgeIdCounter++, i.getId(), id, "", this.COLOR_EDGE_STANDARD);
        }
        return i.getId();
    }

    private int displayActionTree(int graph, Action a) throws Exception {
        this.visualizer.addVertex(graph, a.getId(), a.getName(), this.COLOR_ACTION, VertexType.ACTION);
        this.visualizer.setVertexTooltip(a.getId(), Integer.valueOf(a.getId()).toString() + " " + a.getName());
        for (AtomicAction aa : a.getAtomicActions()) {
            this.visualizer.addVertex(graph, aa.getId(), aa.getName(), this.COLOR_ATOMIC_ACTION, VertexType.ATOMIC_ACTION);
            this.visualizer.setVertexTooltip(aa.getId(), Integer.valueOf(aa.getId()).toString() + " " + aa.getName());
            this.visualizer.addEdge(graph, this.edgeIdCounter++, a.getId(), aa.getId(), "", this.COLOR_EDGE_STANDARD);
        }
        for (AffordanceSlot slot : a.getAffordances()) {
            this.visualizer.addVertex(graph, slot.getId(), slot.getType(), this.COLOR_AFFORDANCE, VertexType.AFFORDANCE);
            this.visualizer.setVertexTooltip(slot.getId(), Integer.valueOf(slot.getId()).toString() + " " + slot.getType());
            this.visualizer.addEdge(graph, this.edgeIdCounter++, a.getId(), slot.getId(), "", this.COLOR_EDGE_STANDARD);
        }
        for (Intention i : a.getSubNodes()) {
            int id = this.displayIntentionTree(graph, i);
            this.visualizer.addEdge(graph, this.edgeIdCounter++, a.getId(), id, "", this.COLOR_EDGE_STANDARD);
        }
        return a.getId();
    }

    public void createDecisionTree(DecisionTree dTree) {
        if (this.visualizer.graphs.get(0) == null) {
            this.visualizer.addGraph(0, "Decision Tree", new Dimension(1000, 600));
        } else {
            this.visualizer.clearGraph(0);
        }
        try {
            for (Intention i : dTree.topLevelGoals.values()) {
                this.displayIntentionTree(0, i);
            }
            this.visualizer.createTreeLayout(0);
        }
        catch (Exception e) {
            System.err.println("Could not visualize decision graph.");
            System.err.println(e.getMessage());
        }
    }

    public void createChronobagView(AgentMemory mem) {
        SchemaBag schemas = mem.getSchemaBag();
        Chronobag present = mem.getPresentChronobag();
        this.visualizer.addGraph(1, "Chronobags", new Dimension(1000, 600));
        this.visualizer.clearGraph(1);
        this.visualizer.addVertex(1, schemas.id, "Schema Bag", this.COLOR_OBJECT, VertexType.DEFAULT_VERTEX);
        this.visualizer.setVertexTooltip(schemas.id, Integer.valueOf(schemas.id).toString() + " Schema bag");
        this.visualizer.setVertexDetail(schemas.id, schemas.toString());
        this.visualizer.addVertex(1, present.id, "Present day", this.COLOR_DEFAULT_VERTEX, VertexType.DEFAULT_VERTEX);
        this.visualizer.setVertexTooltip(present.id, Integer.valueOf(present.id).toString() + " Present day");
        this.visualizer.setVertexDetail(present.id, present.toString());
        for (Chronobag c : mem.getPastChrononags()) {
            this.visualizer.addVertex(1, c.id, c.getAge().toString(), this.COLOR_DEFAULT_VERTEX, VertexType.DEFAULT_VERTEX);
            this.visualizer.setVertexTooltip(c.id, Integer.valueOf(c.id).toString());
            this.visualizer.setVertexDetail(c.id, c.toString());
            if (c.getOlderChronobag() == null) continue;
            this.visualizer.addEdge(1, this.edgeIdCounter++, c.id, c.getOlderChronobag().id, "", this.COLOR_EDGE_SEQUENCE);
        }
        this.visualizer.createTreeLayout(1);
    }

    public void createSchemaBag(SchemaBag schemas) {
        this.visualizer.addGraph(2, "Schemas", new Dimension(1000, 600));
        this.visualizer.setSchemaMessageCommand(schemas.schemaMessageCommand, 2);
        this.numberOfSchemaBagNodes = 0;
    }

    public void refreshSchemaBag(SchemaBag schemas) {
        if (!this.visualizer.refresh) {
            return;
        }
        if (schemas.getNumberOfNodes() == this.numberOfSchemaBagNodes) {
            return;
        }
        this.numberOfSchemaBagNodes = schemas.getNumberOfNodes();
        for (SchemaEpisodeNode schemaEpisodeNode : schemas.getSchemaENodes()) {
            this.displaySchemaEpisodeNode(schemaEpisodeNode);
        }
        for (SchemaObjectNode schemaObjectNode : schemas.getSchemaONodes()) {
            this.displaySchemaObjectNode(schemaObjectNode);
        }
        this.visualizer.createTreeLayout(2);
    }

    public void refreshChronobagView(SchemaBag schemas, Collection<Chronobag> chronobags) {
        if (!this.visualizer.refresh) {
            return;
        }
        this.visualizer.setVertexDetail(schemas.id, schemas.toString());
        for (Chronobag c : chronobags) {
            String s = c.getAge().toString();
            this.visualizer.addVertex(1, c.id, s, this.COLOR_DEFAULT_VERTEX, VertexType.DEFAULT_VERTEX);
            this.visualizer.setVertexTooltip(c.id, Integer.valueOf(c.id).toString() + " " + s);
            this.visualizer.setVertexDetail(c.id, c.toString());
            if (c.getOlderChronobag() == null || !this.visualizer.addEdge(1, this.edgeIdCounter++, EdgeType.SUBNODE, c.id, c.getOlderChronobag().id, "", this.COLOR_EDGE_SEQUENCE)) continue;
            ++this.edgeIdCounter;
        }
        this.visualizer.createTreeLayout(1);
    }

    private void displaySchemaObjectNode(SchemaObjectNode node) {
        if (node == null) {
            return;
        }
        this.visualizer.addVertex(2, node.getId(), node.getName(), this.COLOR_OBJECT, VertexType.OBJECT);
        String str = Integer.valueOf(node.getId()).toString() + " " + node.getName();
        this.visualizer.setVertexTooltip(node.getId(), str);
        for (SlotContent content : node.getSlotContents()) {
            this.visualizer.addEdge(2, this.edgeIdCounter++, EdgeType.OBJECT, node.getId(), content.getId(), "", this.COLOR_EDGE_STANDARD);
        }
    }

    private void displaySchemaEpisodeNode(SchemaEpisodeNode node) {
        if (node == null) {
            return;
        }
        Color color = this.COLOR_EPISODE_NODE;
        VertexType vtype = VertexType.DEFAULT_VERTEX;
        if (node.getAssociatedNode() != null) {
            switch (node.getAssociatedNode().getType()) {
                case ACTION: {
                    color = this.COLOR_ACTION;
                    vtype = VertexType.ACTION;
                    break;
                }
                case INTENTION: {
                    color = this.COLOR_INTENTION;
                    vtype = VertexType.INTENTION;
                    break;
                }
                case ATOMIC_ACTION: {
                    color = this.COLOR_ATOMIC_ACTION;
                    vtype = VertexType.ATOMIC_ACTION;
                }
            }
        }
        this.visualizer.addVertex(2, node.getId(), node.getName(), color, vtype);
        String str = Integer.valueOf(node.getId()).toString() + " " + node.getName();
        this.visualizer.setVertexTooltip(node.getId(), str);
        SchemaEpisodeNode parent = null;
        if (node.getAssociatedNode().parent != null) {
            parent = node.getAssociatedNode().parent.getAssociatedNode();
        }
        if (parent != null) {
            this.visualizer.addEdge(2, this.edgeIdCounter++, parent.getId(), node.getId(), "", this.COLOR_EDGE_STANDARD);
        }
        for (SchemaSlot slot : node.getSlots()) {
            this.visualizer.addVertex(2, slot.getId(), slot.getType(), this.COLOR_AFFORDANCE, VertexType.AFFORDANCE);
            str = Integer.valueOf(slot.getId()).toString() + " " + slot.getType();
            this.visualizer.setVertexTooltip(slot.getId(), str);
            this.visualizer.addEdge(2, this.edgeIdCounter++, node.getId(), slot.getId(), "", this.COLOR_EDGE_STANDARD);
            for (SlotContent content : slot.getSlotContents()) {
                this.visualizer.addVertex(2, content.getId(), "(slot content)", this.COLOR_AFFORDANCE, VertexType.AFFORDANCE);
                str = Integer.valueOf(content.getId()).toString() + "\n";
                str = str + " slot:" + Integer.valueOf(content.getSlot().getId()).toString() + " " + content.getSlot().getType() + "\n";
                str = str + " object:" + Integer.valueOf(content.getObject().getId()).toString() + " " + content.getObject().getName();
                this.visualizer.setVertexTooltip(content.getId(), str);
                this.visualizer.addEdge(2, this.edgeIdCounter++, slot.getId(), content.getId(), "", this.COLOR_EDGE_STANDARD);
            }
        }
    }

    public void createTreeLayout(Chronobag c, int graph) {
        this.maxY = 0;
        Episode e2 = c.getFirstEpisode();
        if (e2 == null) {
            return;
        }
        int x = 0;
        HashSet<Episode> done = new HashSet<Episode>();
        while (!done.contains(e2)) {
            x += this.setNodeTreePosition(graph, e2.getRoot(), x, 0);
            done.add(e2);
            for (Episode e2 : e2.next) {
                if (!done.contains(e2)) break;
            }
        }
        this.visualizer.lastNonObjectNode.put(graph, this.maxY);
        this.visualizer.positionObjectNodes(this.maxY + Parameters.NODES_Y_MARGIN);
    }

    private int setNodeTreePosition(int graph, EpisodeNode node, int x, int y) {
        EpisodeNode n;
        LinkedList<EpisodeNode> nodes = new LinkedList<EpisodeNode>();
        HashSet<Integer> included = new HashSet<Integer>();
        Stack<EpisodeNode> s = new Stack<EpisodeNode>();
        for (EpisodeNode n2 : node.getFirstChild().values()) {
            s.push(n2);
        }
        while (!s.isEmpty()) {
            n = (EpisodeNode)s.pop();
            if (included.contains(n.getId())) continue;
            included.add(n.getId());
            nodes.add(n);
            for (EpisodeNode suc : n.getSuccessor().values()) {
                s.push(suc);
            }
        }
        int size = 0;
        if (nodes.isEmpty()) {
            size = Parameters.NODES_X_MARGIN;
        }
        while (!nodes.isEmpty()) {
            n = (EpisodeNode)nodes.poll();
            size += this.setNodeTreePosition(graph, n, x + size, y + Parameters.NODES_Y_MARGIN);
        }
        for (ObjectSlot slot : node.getObjectSlots()) {
            this.visualizer.setVertexLocation(graph, slot.getId(), x + size + Parameters.NODES_X_MARGIN / 2, (double)y + 0.8 * (double)Parameters.NODES_Y_MARGIN);
            size += Parameters.NODES_X_MARGIN;
        }
        this.visualizer.setVertexLocation(graph, node.getId(), x + size / 2, y);
        if (y > this.maxY) {
            this.maxY = y;
        }
        return size;
    }

    public static void main(String[] args) {
        VisualizationRenderer viz = new VisualizationRenderer();
        viz.addGraph(0, "G1", new Dimension(300, 300));
        viz.addGraph(1, "G2", new Dimension(1000, 600));
        viz.addEdge(0, 51, 41, 42, "", Color.red);
        viz.addEdge(0, 52, 42, 43, "", Color.red);
        viz.addEdge(0, 53, 42, 44, "", Color.blue);
        viz.addEdge(0, 54, 42, 44, "", Color.green);
        viz.addVertex(1, 0, 0.0, 0.0, "a", Color.BLUE);
        viz.addVertex(1, 1, 100.0, 100.0, "b", Color.RED);
        viz.addVertex(1, 2, 400.0, 100.0, "c", Color.GREEN);
        viz.addVertex(1, 3, 1000.0, 600.0, "d", Color.ORANGE);
        viz.addVertex(0, 41, "nopos1");
        viz.addVertex(0, 42, "nopos2");
        viz.addVertex(0, 43, "nopos3");
        viz.addVertex(0, 44, "nopos4");
        viz.addVertex(0, 45, "nopos5");
        viz.addEdge(1, 0, 0, 1, "e", Color.red);
        viz.setVertexTooltip(0, "tooltip");
        viz.addVertex(0, 7, 150.0, 150.0, "g1vertex", Color.BLUE);
        viz.addVertex(0, 71, 250.0, 250.0, "g1vertex1", Color.BLUE);
        viz.addVertex(1, 8, 150.0, 150.0, "g2vertex", Color.ORANGE);
        viz.createTreeLayout(0);
        viz.createTreeLayout(1);
    }
}

