/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.schemas;

import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import cz.cuni.amis.pogamut.episodic.schemas.SlotContent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

public class SchemaCounter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Collection<SchemaEpisodeNode> schemaNodes = new HashSet<SchemaEpisodeNode>();
    private Collection<SlotContent> contentNodes = new HashSet<SlotContent>();
    final int key;
    private int count = 0;
    private int totalCount = 0;

    public SchemaCounter(int _key, Collection<SchemaEpisodeNode> _schemaNodes, Collection<SlotContent> _contentNodes) {
        this.key = _key;
        this.schemaNodes.addAll(_schemaNodes);
        this.contentNodes.addAll(_contentNodes);
        int hash = 0;
        for (SchemaEpisodeNode s : this.schemaNodes) {
            s.addCount(this.key - s.id, this);
            hash += s.id;
        }
        for (SlotContent c : this.contentNodes) {
            c.addCount(this.key - c.id, this);
            hash += c.id;
        }
        assert (hash == this.key);
        if (hash != this.key) {
            System.err.println("Incorrect schema counter key!");
        }
    }

    public void increaseCount() {
        ++this.count;
    }

    public void increaseTotalCount() {
        ++this.totalCount;
    }

    public int getCount() {
        return this.count;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean checkNodes(Collection<Integer> col) {
        if (col.size() != this.schemaNodes.size() + this.contentNodes.size()) {
            return false;
        }
        for (SchemaEpisodeNode n : this.schemaNodes) {
            if (col.contains(n.id)) continue;
            return false;
        }
        for (SlotContent c : this.contentNodes) {
            if (col.contains(c.id)) continue;
            return false;
        }
        return true;
    }

    public boolean checkNode(Integer i) {
        for (SchemaEpisodeNode n : this.schemaNodes) {
            if (n.getId() != i.intValue()) continue;
            return true;
        }
        for (SlotContent c : this.contentNodes) {
            if (c.getId() != i.intValue()) continue;
            return true;
        }
        return false;
    }

    public boolean checkNodes(Collection<SchemaEpisodeNode> sn, Collection<SlotContent> cn) {
        return this.schemaNodes.containsAll(sn) && sn.containsAll(this.schemaNodes) && this.contentNodes.containsAll(cn) && cn.containsAll(this.contentNodes);
    }

    public Collection<SchemaEpisodeNode> getENodes() {
        return this.schemaNodes;
    }

    public Collection<SlotContent> getContentsNodes() {
        return this.contentNodes;
    }
}

