/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.schemas;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.AtomicAction;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.decisions.NodeType;
import cz.cuni.amis.pogamut.episodic.memory.AffordanceUsed;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.memory.IdGenerator;
import cz.cuni.amis.pogamut.episodic.memory.Parameters;
import cz.cuni.amis.pogamut.episodic.schemas.ISchemaMessageCommand;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaCounter;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaObjectNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaSlot;
import cz.cuni.amis.pogamut.episodic.schemas.SlotContent;
import cz.cuni.amis.pogamut.episodic.schemas.utils.Binomial;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.collections15.multimap.MultiHashMap;

public class SchemaBag
implements Serializable {
    private static final long serialVersionUID = 1L;
    IdGenerator idGenerator;
    AgentMemory memory;
    private int numberOfNodes = 0;
    public final int id;
    HashMap<String, SchemaEpisodeNode> schemaENodes = new HashMap();
    HashMap<String, SchemaObjectNode> schemaONodes = new HashMap();
    MultiHashMap<Integer, SchemaCounter> counters = new MultiHashMap();
    public SchemaMessageCommand schemaMessageCommand = new SchemaMessageCommand();
    private Collection<Integer> lastIds = new HashSet<Integer>();
    private Collection<Integer> requiredIds = new HashSet<Integer>();

    public SchemaBag(IdGenerator idGen, AgentMemory mem) {
        this.idGenerator = idGen;
        this.memory = mem;
        this.id = this.idGenerator.getNewId();
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        String s = "";
        s = s + Integer.valueOf(this.id).toString() + " Nodes:" + this.numberOfNodes + newline;
        s = s + "Number of Schema Episode Nodes: " + this.schemaENodes.size() + newline;
        s = s + "Number of Schema Object Nodes: " + this.schemaONodes.size() + newline;
        s = s + "Number of Counters: " + this.counters.size() + newline;
        return s;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public SchemaEpisodeNode getSchemaENode(String name) {
        return this.schemaENodes.get(name);
    }

    public Collection<SchemaEpisodeNode> getSchemaENodes() {
        return this.schemaENodes.values();
    }

    public Collection<SchemaObjectNode> getSchemaONodes() {
        return this.schemaONodes.values();
    }

    public Integer getCount(Collection<SchemaEpisodeNode> schemaNodes, Collection<SlotContent> objectNodes) {
        SchemaCounter c = this.getCounter(schemaNodes, objectNodes, Parameters.MAX_SCHEMA_COMBINATION_COUNT);
        if (c == null) {
            return 0;
        }
        return c.getCount();
    }

    public SchemaCounter getCounter(Collection<SchemaEpisodeNode> schemaNodes, Collection<SlotContent> objectNodes, int maxCombination) {
        HashSet<Integer> col = new HashSet<Integer>();
        for (SchemaEpisodeNode n : schemaNodes) {
            col.add(n.getId());
        }
        for (SlotContent s : objectNodes) {
            col.add(s.getId());
        }
        if (col.isEmpty()) {
            return null;
        }
        if (col.size() > maxCombination) {
            return null;
        }
        int key = 0;
        for (Integer i : col) {
            key += i.intValue();
        }
        Collection counts = this.counters.get((Object)key);
        SchemaCounter count = null;
        if (counts != null) {
            for (SchemaCounter c : counts) {
                if (!c.checkNodes(col)) continue;
                count = c;
            }
        }
        return count;
    }

    private void increaseCount(Collection<SchemaEpisodeNode> schemaNodes, Collection<SlotContent> objectNodes) {
        int hash = 0;
        for (SchemaEpisodeNode e : schemaNodes) {
            hash += e.id;
        }
        for (SlotContent c : objectNodes) {
            hash += c.id;
        }
        if (schemaNodes.isEmpty() && objectNodes.isEmpty()) {
            return;
        }
        Collection counts = this.counters.get((Object)hash);
        SchemaCounter counter = null;
        if (counts != null) {
            for (SchemaCounter c : counts) {
                if (!c.checkNodes(schemaNodes, objectNodes)) continue;
                counter = c;
                break;
            }
        }
        if (counter == null) {
            counter = new SchemaCounter(hash, schemaNodes, objectNodes);
            this.counters.put((Object)hash, (Object)counter);
        }
        counter.increaseTotalCount();
        boolean increase = false;
        for (Integer i : this.requiredIds) {
            if (!counter.checkNode(i)) continue;
            increase = true;
            break;
        }
        if (increase) {
            counter.increaseCount();
        }
    }

    private <T> Collection<T> getSubSet(Collection<T> set, ArrayList<T> list, int k, int i) {
        int n = list.size();
        int found = 0;
        set.clear();
        if (k > n) {
            return set;
        }
        while (k > 0) {
            long subsum;
            int index = 0;
            for (subsum = Binomial.binomial(n - 1, k - 1); (long)i >= subsum; subsum += Binomial.binomial(n - 1 - ++index, k - 1)) {
            }
            set.add(list.get(index + found));
            i = (int)((long)i - (subsum - Binomial.binomial(n - 1, k - 1)));
            --n;
            ++found;
            --k;
        }
        return set;
    }

    void increaseCounts(Collection<SchemaEpisodeNode> schemaNodes, Collection<SlotContent> objectNodes, int maxCombination) {
        Collection<Object> eSubSet = new HashSet();
        Collection<Object> oSubSet = new HashSet();
        ArrayList<SchemaEpisodeNode> schemaNodes2 = new ArrayList<SchemaEpisodeNode>(schemaNodes);
        ArrayList<SlotContent> objectNodes2 = new ArrayList<SlotContent>(objectNodes);
        for (int s1 = 0; s1 <= maxCombination; ++s1) {
            long i1max = Binomial.binomial(schemaNodes2.size(), s1);
            int i1 = 0;
            while ((long)i1 < i1max) {
                eSubSet = this.getSubSet(eSubSet, schemaNodes2, s1, i1);
                int s2 = 0;
                while (s1 + s2 <= maxCombination) {
                    long i2max = Binomial.binomial(objectNodes2.size(), s2);
                    int i2 = 0;
                    while ((long)i2 < i2max) {
                        oSubSet = this.getSubSet(oSubSet, objectNodes2, s2, i2);
                        if (eSubSet.size() == s1 && oSubSet.size() == s2) {
                            this.increaseCount(eSubSet, oSubSet);
                        }
                        ++i2;
                    }
                    ++s2;
                }
                ++i1;
            }
        }
    }

    public Collection<SchemaCounter> getAllExistingSubSets(Collection<SchemaEpisodeNode> schemaNodes, Collection<SlotContent> objectNodes, int maxSize) {
        HashSet<SchemaCounter> result = new HashSet<SchemaCounter>();
        Collection<Object> eSubSet = new HashSet();
        Collection<Object> oSubSet = new HashSet();
        ArrayList<SchemaEpisodeNode> schemaNodes2 = new ArrayList<SchemaEpisodeNode>(schemaNodes);
        ArrayList<SlotContent> objectNodes2 = new ArrayList<SlotContent>(objectNodes);
        SchemaCounter counter = null;
        for (int s1 = 0; s1 <= maxSize; ++s1) {
            long i1max = Binomial.binomial(schemaNodes2.size(), s1);
            int i1 = 0;
            while ((long)i1 < i1max) {
                eSubSet = this.getSubSet(eSubSet, schemaNodes2, s1, i1);
                int s2 = 0;
                while (s1 + s2 <= maxSize) {
                    long i2max = Binomial.binomial(objectNodes2.size(), s2);
                    int i2 = 0;
                    while ((long)i2 < i2max) {
                        oSubSet = this.getSubSet(oSubSet, objectNodes2, s2, i2);
                        if (eSubSet.size() == s1 && oSubSet.size() == s2 && s1 + s2 > 0 && (counter = this.getCounter(eSubSet, oSubSet, maxSize)) != null) {
                            result.add(counter);
                        }
                        ++i2;
                    }
                    ++s2;
                }
                ++i1;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public void updateSchema(String atomicAction, ArrayList<String> trace, ArrayList<AffordanceUsed> affordances) {
        int i;
        HashMap<String, SchemaEpisodeNode> eNodesSubSet = new HashMap<String, SchemaEpisodeNode>();
        HashSet<SlotContent> contentsSubSet = new HashSet<SlotContent>();
        ArrayList<Node> decisionNodes = this.memory.getDecisionTree().getTrace(trace);
        assert (!decisionNodes.isEmpty());
        Node last = decisionNodes.get(decisionNodes.size() - 1);
        try {
            AtomicAction a = ((Action)last).getAtomicAction(atomicAction);
            if (a != null) {
                decisionNodes.add(a);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("SchemaBag: could not find associated node for atomic action.");
        }
        for (i = 0; i < decisionNodes.size(); ++i) {
            SchemaEpisodeNode schemaNode;
            String string;
            Node node = decisionNodes.get(i);
            int nodeId = 0;
            String string2 = "";
            try {
                nodeId = node.getId();
                string = node.getName();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.err.println("SchemaBag: could not retrive ID of associated node.");
                continue;
            }
            if (!this.schemaENodes.containsKey(string)) {
                schemaNode = new SchemaEpisodeNode(node, this.idGenerator.getNewId(), node.getName());
                ++this.numberOfNodes;
                this.schemaENodes.put(string, schemaNode);
            } else {
                schemaNode = this.schemaENodes.get(string);
                if (node.getAssociatedNode() == null) {
                    node.setAssociatedSchemaNode(schemaNode);
                }
            }
            eNodesSubSet.put(schemaNode.name, schemaNode);
        }
        for (i = 0; i < affordances.size(); ++i) {
            void var13_22;
            SlotContent slotContent;
            SchemaObjectNode object;
            SchemaEpisodeNode schemaNode;
            AffordanceUsed aff = affordances.get(i);
            if (aff.item == null || (schemaNode = (SchemaEpisodeNode)eNodesSubSet.get(aff.usedOn)) == null) continue;
            SchemaSlot schemaSlot = schemaNode.getSlot(aff.type);
            if (schemaSlot == null) {
                if (schemaNode.addSlot(aff.type, this.idGenerator.getNewId())) {
                    ++this.numberOfNodes;
                }
                SchemaSlot schemaSlot2 = schemaNode.getSlot(aff.type);
            }
            if ((object = this.schemaONodes.get(aff.item)) == null) {
                object = new SchemaObjectNode(this.idGenerator.getNewId(), aff.item);
                ++this.numberOfNodes;
                this.schemaONodes.put(aff.item, object);
            }
            if ((slotContent = var13_22.getSlotContent(aff.item)) == null) {
                if (var13_22.addSlotContent(this.idGenerator.getNewId(), object)) {
                    ++this.numberOfNodes;
                }
                slotContent = var13_22.getSlotContent(aff.item);
            }
            contentsSubSet.add(slotContent);
        }
        this.requiredIds.clear();
        boolean add = false;
        for (Node node : decisionNodes) {
            if (!add && this.schemaENodes.get(node.getName()) != null && this.lastIds.contains(this.schemaENodes.get(node.getName()).getId())) continue;
            this.requiredIds.add(this.schemaENodes.get(node.getName()).getId());
            add = true;
        }
        for (SlotContent slotContent : contentsSubSet) {
            if (this.lastIds.contains(slotContent.getId())) continue;
            this.requiredIds.add(slotContent.getId());
        }
        this.lastIds.clear();
        for (SchemaEpisodeNode schemaEpisodeNode : eNodesSubSet.values()) {
            this.lastIds.add(schemaEpisodeNode.getId());
        }
        for (SlotContent slotContent : contentsSubSet) {
            this.lastIds.add(slotContent.getId());
        }
        this.increaseCounts(eNodesSubSet.values(), contentsSubSet, Parameters.MAX_SCHEMA_COMBINATION_COUNT);
    }

    private int getActualNumberOfVariations(Intention node) {
        if (node.getAssociatedNode() == null) {
            return 0;
        }
        int intentionVariations = 0;
        for (Action action : node.getSubNodes()) {
            int actionVariations = 1;
            if (action.getAssociatedNode() == null) continue;
            for (Intention intention : action.getSubNodes()) {
                int temp = this.getActualNumberOfVariations(intention);
                actionVariations *= temp;
            }
            intentionVariations += actionVariations;
        }
        return intentionVariations;
    }

    public void generateStatistics(String fileName) {
        try {
            FileWriter outFile = new FileWriter(fileName);
            PrintWriter out = new PrintWriter(outFile);
            HashSet<SchemaEpisodeNode> eNodes = new HashSet<SchemaEpisodeNode>();
            HashSet<SlotContent> oNodes = new HashSet<SlotContent>();
            for (Intention intention : this.memory.getDecisionTree().topLevelGoals.values()) {
                out.print(intention.getName() + " | Possible:");
                out.print(intention.getPossibleSubTrees() + "| Actual:");
                if (intention.getAssociatedNode() == null) {
                    out.println("0");
                    continue;
                }
                out.println(this.getActualNumberOfVariations(intention));
            }
            out.println();
            for (SchemaEpisodeNode schemaEpisodeNode : this.schemaENodes.values()) {
                if (schemaEpisodeNode.getAssociatedNode().getType() != NodeType.INTENTION) continue;
                int sum = 0;
                for (Node a : schemaEpisodeNode.getAssociatedNode().getAllChildrenNodes()) {
                    eNodes.clear();
                    eNodes.add(schemaEpisodeNode);
                    if (a.getAssociatedNode() == null) continue;
                    eNodes.add(a.getAssociatedNode());
                    sum += this.getCount(eNodes, oNodes).intValue();
                }
                out.print(schemaEpisodeNode.getName() + "|");
                for (Node a : schemaEpisodeNode.getAssociatedNode().getAllChildrenNodes()) {
                    eNodes.clear();
                    eNodes.add(schemaEpisodeNode);
                    if (a.getAssociatedNode() == null) {
                        out.print(a.getName() + " 0 (0%) | ");
                        continue;
                    }
                    eNodes.add(a.getAssociatedNode());
                    int count = this.getCount(eNodes, oNodes);
                    out.print(a.getName() + " " + count + " (" + (double)count * 100.0 / (double)sum + "%) |");
                }
                out.println();
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            System.err.println(e.toString());
            System.err.println("Could not create file with statistics!");
        }
    }

    public class SchemaMessageCommand
    implements ISchemaMessageCommand,
    Serializable {
        @Override
        public String getSchemaMessage(Collection<Integer> picked) {
            if (picked.isEmpty()) {
                return "Select some episodic nodes, slot contents and retry.";
            }
            int key = 0;
            for (Integer i : picked) {
                key += i.intValue();
            }
            Collection counts = SchemaBag.this.counters.get((Object)key);
            SchemaCounter count = null;
            if (counts != null) {
                for (SchemaCounter c : counts) {
                    if (!c.checkNodes(picked)) continue;
                    count = c;
                }
            }
            if (count == null) {
                return "No count for given selection.";
            }
            String s = "Count for given selection: " + count.getCount() + System.getProperty("line.separator");
            s = s + "Total count for given selection: " + count.getTotalCount();
            return s;
        }
    }
}

