/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.query;

import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.episodes.EpisodeNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectSlot;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.memory.Parameters;
import cz.cuni.amis.pogamut.episodic.query.ComboTexts;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaCounter;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaSlot;
import cz.cuni.amis.pogamut.episodic.schemas.SlotContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class QueryExecutor {
    private final AgentMemory mem;

    public QueryExecutor(AgentMemory mem) {
        this.mem = mem;
    }

    public String executeQuery(ComboTexts.ComboType type, boolean schemaOnly, String str) {
        String result = "Problem executing query.";
        this.mem.sem.acquireUninterruptibly();
        if (type == ComboTexts.ComboType.COMBO_ACTIVITY && schemaOnly) {
            result = this.executeActivitySchemaQuery(str);
        }
        if (type == ComboTexts.ComboType.COMBO_ACTIVITY && !schemaOnly) {
            result = this.executeActivityQuery(str);
        }
        if (type == ComboTexts.ComboType.COMBO_EPISODE && !schemaOnly) {
            str = str.substring(0, str.indexOf(" "));
            result = this.executeEpisodeQuery(Integer.parseInt(str));
        }
        this.mem.sem.release();
        return result;
    }

    private String executeEpisodeQuery(int idEpisode) {
        Episode ep = null;
        ArrayList<Episode> eps = new ArrayList<Episode>();
        for (Chronobag ch : this.mem.getChronobags()) {
            for (Episode e : ch.getEpisodes()) {
                if (idEpisode != e.idEpisode) continue;
                if (ep == null) {
                    ep = e;
                    continue;
                }
                eps.add(e);
            }
        }
        if (ep == null) {
            return "Episode not found.";
        }
        ep = ep.createCopy(null);
        for (Episode e : eps) {
            ep.mergeWith(e);
        }
        EpisodeNode root = (ep = ep.deriveEpisode()).getRoot();
        if (root == null) {
            return "Episode " + idEpisode + "deleted.";
        }
        String str = "Episode " + idEpisode + ":" + System.getProperty("line.separator");
        str = str + this.describeNode(root, 0, idEpisode);
        return str;
    }

    private String executeActivitySchemaQuery(String name) {
        String str = "";
        Node node = this.mem.getDecisionTree().topLevelGoals.get(name);
        ArrayList<SlotContent> contents = new ArrayList<SlotContent>();
        SchemaEpisodeNode schemaNode = this.mem.getSchemaBag().getSchemaENode(node.getName());
        if (schemaNode == null) {
            return "Don't know.";
        }
        SchemaSlot slot = schemaNode.getSlot("Day");
        contents.addAll(slot.getSlotContents());
        int sum = 0;
        for (SlotContent content : contents) {
            sum += ((SchemaCounter)content.getCounts().get((Object)0).iterator().next()).getCount();
        }
        for (SlotContent content : contents) {
            int count = ((SchemaCounter)content.getCounts().get((Object)0).iterator().next()).getCount();
            if (count * 10 < sum) continue;
            str = str + content.getObject().getName() + ": ";
            str = str + count + "/" + sum + " = ";
            str = str + 100 * count / sum + "%." + System.getProperty("line.separator");
        }
        return str;
    }

    private String describeNode(EpisodeNode node, int offset, int idEpisode) {
        if (node.getAssociatedNode() == null) {
            return "";
        }
        String spaces = "";
        for (int i = 0; i < offset; ++i) {
            spaces = spaces + " ";
        }
        String str = spaces + "Performed " + node.getName() + "." + System.getProperty("line.separator");
        for (SchemaSlot slot : node.getAssociatedNode().getAssociatedNode().getSlots()) {
            String slotStr = this.describeSlot(node, slot.getType());
            str = str + spaces + slotStr + System.getProperty("line.separator");
        }
        Collection<EpisodeNode> children = node.getChildrenNodes();
        HashSet<Node> childrenNodes = new HashSet<Node>();
        for (EpisodeNode n : children) {
            childrenNodes.add(n.getAssociatedNode());
        }
        str = str + spaces + "Performed by doing: ";
        Collection<Node> allchildrenNodes = node.getAssociatedNode().getAllChildrenNodes();
        int totalCount = 0;
        ArrayList<SchemaEpisodeNode> childrenSchemaNodes = new ArrayList<SchemaEpisodeNode>();
        for (Node n : allchildrenNodes) {
            if (n.getAssociatedNode() != null) {
                childrenSchemaNodes.add(n.getAssociatedNode());
            }
            if (n.getAssociatedNode() == null) continue;
            totalCount += n.getAssociatedNode().getSingleCount().intValue();
        }
        for (SchemaEpisodeNode n : childrenSchemaNodes) {
            double perc = 0.0;
            Collection counters = n.getCounts().get((Object)node.getAssociatedNode().getAssociatedNode().getId());
            for (SchemaCounter c : counters) {
                if (!c.checkNode(node.getAssociatedNode().getAssociatedNode().getId())) continue;
                perc += (double)(c.getCount() / totalCount) * (1.0 - Parameters.EPISODE_TREE_RELIANCE);
            }
            if (childrenNodes.contains(n.getAssociatedNode())) {
                perc += Parameters.EPISODE_TREE_RELIANCE;
            }
            str = str + n.getName() + "(" + Math.round(perc * 100.0) + "%); ";
        }
        str = str + System.getProperty("line.separator");
        EpisodeNode subnode = node.getFirstChild().get(idEpisode);
        while (subnode != null) {
            if (subnode.getAssociatedNode() != null) {
                str = str + this.describeNode(subnode, offset + 2, idEpisode);
            }
            subnode = subnode.getSuccessor().get(idEpisode);
        }
        return str;
    }

    private String describeSlot(EpisodeNode node, String slotName) {
        ObjectSlot slot = node.getObjectSlot(slotName);
        String slotStr = slotName + ": ";
        Collection<ObjectNode> obj = slot != null ? slot.getUsedObjects() : new ArrayList<ObjectNode>();
        int objects = obj.size();
        SchemaSlot schemaSlot = node.getAssociatedNode().getAssociatedNode().getSlot(slotName);
        if (schemaSlot == null) {
            return slotStr + "unknown";
        }
        ArrayList<SlotContent> contents = new ArrayList<SlotContent>();
        contents.addAll(schemaSlot.getSlotContents());
        int sum = 0;
        for (SlotContent content : contents) {
            sum += ((SchemaCounter)content.getCounts().get((Object)0).iterator().next()).getCount();
        }
        for (SlotContent content : contents) {
            int count = ((SchemaCounter)content.getCounts().get((Object)0).iterator().next()).getCount();
            double percentage = objects > 0 ? (double)(100 * count / sum) * (1.0 - Parameters.EPISODE_TREE_RELIANCE) : (double)(100 * count / sum);
            for (ObjectNode o : obj) {
                if (!o.getName().equals(content.getObject().getName())) continue;
                percentage += 100.0 * Parameters.EPISODE_TREE_RELIANCE / (double)objects;
            }
            slotStr = slotStr + content.getObject().getName() + " - " + Math.round(percentage) + "%; ";
        }
        if (objects == 0) {
            slotStr = slotStr + "(guess)";
        }
        return slotStr;
    }

    private String executeActivityQuery(String name) {
        String str = "";
        ArrayList<String> days = new ArrayList<String>();
        Integer minday = null;
        Integer maxday = null;
        for (int level = 0; level < Parameters.MAX_CHRONOBAG_LEVELS; ++level) {
            for (Chronobag c = this.mem.getChronobagSequenceEnds().get(level); c != null; c = c.getOlderChronobag()) {
                for (Episode e : c.getEpisodes()) {
                    if (!e.getRoot().getName().equals(name) || maxday != null && maxday <= c.getAge().getMaxAge()) continue;
                    minday = c.getAge().getMinAge();
                    maxday = c.getAge().getMaxAge();
                    ObjectSlot s = e.getRoot().getObjectSlot("Day");
                    if (s == null || s.getUsedObjects().isEmpty()) continue;
                    days.clear();
                    for (ObjectNode o : s.getUsedObjects()) {
                        days.add(o.getName());
                    }
                }
            }
        }
        if (minday != null && maxday != null) {
            str = str + minday + " - " + maxday + " day(s) ago. ";
            str = str + "Possible days: " + days;
        }
        if (str.equals("")) {
            str = "Don't remember.";
        }
        return str;
    }

    public ArrayList<String> executeRoomSchemaQuery() {
        EpisodeNode n;
        ArrayList<String> res = new ArrayList<String>();
        Episode epis = null;
        for (Chronobag c = this.mem.getPresentChronobag(); c != null; c = c.getOlderChronobag()) {
            for (Episode e : c.getEpisodes()) {
                if (!e.getRoot().getName().equals("IObserve")) continue;
                epis = e;
            }
            if (epis != null) break;
        }
        if ((n = (epis = epis.deriveEpisode()).getRoot()) == null) {
            return res;
        }
        if ((n = n.getChild("AObserve")) == null) {
            return res;
        }
        ObjectSlot s = n.getObjectSlot("perceived");
        if (s == null) {
            return res;
        }
        for (ObjectNode o : s.getUsedObjects()) {
            res.add(o.getName());
        }
        return res;
    }

    public Map<Integer, Integer> executeForgettingCurveQuery(Collection<Integer> episodeIDs) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (Integer id : episodeIDs) {
            result.put(id, 0);
            HashSet<Episode> episodes = new HashSet<Episode>();
            for (Chronobag endCh : this.mem.getChronobagSequenceEnds().values()) {
                if (endCh != this.mem.getPresentChronobag()) continue;
                for (Chronobag c = endCh; c != null; c = c.getOlderChronobag()) {
                    for (Episode e : c.getEpisodes()) {
                        if (e.getIdEpisode() != id.intValue()) continue;
                        episodes.add(e.createCopy(null));
                    }
                }
            }
            if (episodes.isEmpty()) continue;
            if (episodes.size() > 1) {
                // empty if block
            }
            Episode e = (Episode)episodes.iterator().next();
            result.put(id, e.getRoot().getNumberOfSubNodesWithObjects() + 1);
        }
        return result;
    }

    public Integer getNumberOfForgottenNodes(Integer id1, AgentMemory mem2, Integer id2, boolean derive1, boolean derive2) {
        Episode epis1 = null;
        for (Chronobag c : this.mem.getChronobags()) {
            for (Episode e : c.getEpisodes()) {
                if (e.getIdEpisode() != id1.intValue()) continue;
                if (epis1 == null) {
                    epis1 = e.createCopy(c);
                    continue;
                }
                epis1.mergeWith(e);
            }
        }
        Episode epis2 = null;
        for (Chronobag c : mem2.getChronobags()) {
            for (Episode e : c.getEpisodes()) {
                if (e.getIdEpisode() != id2.intValue()) continue;
                if (epis2 == null) {
                    epis2 = e.createCopy(c);
                    continue;
                }
                epis2.mergeWith(e);
            }
        }
        if (epis1 != null) {
            epis1 = epis1.deriveEpisode();
        }
        if (epis2 != null) {
            epis2 = epis2.deriveEpisode();
        }
        if (epis1 != null) {
            epis1.getRoot().recalculateTreeSize(false);
        }
        if (epis2 != null) {
            epis2.getRoot().recalculateTreeSize(false);
        }
        if (epis2 == null) {
            return 0;
        }
        if (epis1 == null) {
            return epis2.getRoot().getNumberOfSubNodes() + 1;
        }
        assert (epis1.getRoot().getName().equals(epis2.getRoot().getName()));
        int epis1nodes = epis1.getRoot().getNumberOfSubNodes();
        Episode merged = epis1;
        merged.mergeWith(epis2);
        return merged.getRoot().getNumberOfSubNodes() - epis1nodes;
    }
}

