/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.query;

import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaObjectNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ComboTexts {
    public static Set<String> timeObjects = new HashSet<String>();
    AgentMemory mem;
    int mainComboSelected = 0;
    ArrayList<ComboString> mainComboStrings = new ArrayList();
    ArrayList<ComboString> secondaryComboStrings = new ArrayList();

    ComboTexts(AgentMemory mem) {
        this.mem = mem;
        timeObjects.add("Mo");
        timeObjects.add("Tu");
        timeObjects.add("We");
        timeObjects.add("Th");
        timeObjects.add("Fr");
        timeObjects.add("Sa");
        timeObjects.add("Su");
        timeObjects.add("Morning");
        timeObjects.add("Noon");
        timeObjects.add("Afternoon");
        timeObjects.add("Evening");
        timeObjects.add("LateEvening");
        timeObjects.add("Night");
        this.mainComboStrings.add(new ComboString(ComboType.COMBO_ACTIVITY, false, "When did you last perform ...?"));
        this.mainComboStrings.add(new ComboString(ComboType.COMBO_ACTIVITY, true, "When do you usually perform ...?"));
        this.mainComboStrings.add(new ComboString(ComboType.COMBO_ITEM, false, "When did you last use ...?"));
        this.mainComboStrings.add(new ComboString(ComboType.COMBO_ITEM, true, "When do you usually use ...?"));
        this.mainComboStrings.add(new ComboString(ComboType.COMBO_TIME, false, "What did you do on ...?"));
        this.mainComboStrings.add(new ComboString(ComboType.COMBO_TIME, true, "What do you usually do on ...?"));
        this.mainComboStrings.add(new ComboString(ComboType.COMBO_EPISODE, false, "Describe following episode: "));
    }

    public ArrayList<String> getMainComboTexts() {
        ArrayList<String> res = new ArrayList<String>();
        for (ComboString cs : this.mainComboStrings) {
            res.add(cs.str);
        }
        return res;
    }

    public ArrayList<String> getSecondaryComboTexts() {
        ArrayList<String> res = new ArrayList<String>();
        this.actualizeSecondaryCombo();
        for (ComboString cs : this.secondaryComboStrings) {
            res.add(cs.str);
        }
        return res;
    }

    public void actualizeSecondaryCombo() {
        this.mem.sem.acquireUninterruptibly();
        boolean usual = this.mainComboStrings.get((int)this.mainComboSelected).usual;
        ComboType type = this.mainComboStrings.get((int)this.mainComboSelected).type;
        this.secondaryComboStrings.clear();
        if (type == ComboType.COMBO_ACTIVITY) {
            for (Intention n : this.mem.getDecisionTree().topLevelGoals.values()) {
                this.secondaryComboStrings.add(new ComboString(type, usual, n.getName()));
            }
        }
        if (type == ComboType.COMBO_ITEM) {
            for (SchemaObjectNode o : this.mem.getSchemaBag().getSchemaONodes()) {
                if (timeObjects.contains(o.getName())) continue;
                this.secondaryComboStrings.add(new ComboString(type, usual, o.getName()));
            }
        }
        if (type == ComboType.COMBO_TIME) {
            for (SchemaObjectNode o : this.mem.getSchemaBag().getSchemaONodes()) {
                if (!timeObjects.contains(o.getName())) continue;
                this.secondaryComboStrings.add(new ComboString(type, usual, o.getName()));
            }
        }
        if (type == ComboType.COMBO_EPISODE && !usual) {
            for (Chronobag ch : this.mem.getChronobags()) {
                for (Episode e : ch.getEpisodes()) {
                    String str = e.toString();
                    str = str + ch.getAge().toString();
                    this.secondaryComboStrings.add(new ComboString(type, usual, str));
                }
            }
        }
        this.mem.sem.release();
    }

    public class ComboString {
        final ComboType type;
        final boolean usual;
        String str;

        ComboString(ComboType type, boolean usual, String str) {
            this.type = type;
            this.usual = usual;
            this.str = str;
        }
    }

    public static enum ComboType {
        COMBO_ACTIVITY,
        COMBO_ITEM,
        COMBO_TIME,
        COMBO_EPISODE;

    }
}

