/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.memory;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.AffordanceSlot;
import cz.cuni.amis.pogamut.episodic.decisions.AtomicAction;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTree;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectNode;
import cz.cuni.amis.pogamut.episodic.memory.AffordanceUsed;
import cz.cuni.amis.pogamut.episodic.memory.IAgentMemory;
import cz.cuni.amis.pogamut.episodic.memory.IdGenerator;
import cz.cuni.amis.pogamut.episodic.memory.Parameters;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaBag;
import cz.cuni.amis.pogamut.episodic.visualizer.IVisualizationListener;
import cz.cuni.amis.pogamut.episodic.visualizer.VisualizationEvent;
import cz.cuni.amis.pogamut.episodic.visualizer.VisualizationEventType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.swing.event.EventListenerList;

public class AgentMemory
implements IAgentMemory,
Serializable {
    private static final long serialVersionUID = 1L;
    public Semaphore sem = new Semaphore(1, true);
    EventListenerList listeners = new EventListenerList();
    private IdGenerator idGenerator = new IdGenerator();
    private int lastDay = -1;
    DecisionTree decisionTree = new DecisionTree();
    Chronobag present = new Chronobag(this.idGenerator, this);
    HashSet<Chronobag> past = new HashSet();
    Map<Integer, Chronobag> pastSequenceEnds = new HashMap<Integer, Chronobag>();
    SchemaBag schemas = new SchemaBag(this.idGenerator, this);
    public static boolean visualize = true;

    public void addVisualizationListener(IVisualizationListener listener) {
        this.listeners.add(IVisualizationListener.class, listener);
    }

    public void removeVisualizationListener(IVisualizationListener listener) {
        this.listeners.remove(IVisualizationListener.class, listener);
    }

    public void fireVisualizationEvent(VisualizationEvent event) {
        IVisualizationListener[] listenerList = (IVisualizationListener[])this.listeners.getListeners(IVisualizationListener.class);
        int n = listenerList.length;
        for (int i = 0; i < n; ++i) {
            listenerList[i].handleVisualizationEvent(event);
        }
    }

    public DecisionTree getDecisionTree() {
        return this.decisionTree;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    private void generateIntentionIds(Intention i, IdGenerator idGen) {
        i.setId(idGen.getNewId());
        for (AffordanceSlot slot : i.getAffordances()) {
            slot.setId(idGen.getNewId());
        }
        for (Action a : i.getSubNodes()) {
            this.generateActionIds(a, idGen);
        }
        ++this.getDecisionTree().numberOfNodes;
    }

    private void generateActionIds(Action a, IdGenerator idGen) {
        a.setId(idGen.getNewId());
        for (AffordanceSlot slot : a.getAffordances()) {
            slot.setId(idGen.getNewId());
        }
        for (AtomicAction aa : a.getAtomicActions()) {
            aa.setId(idGen.getNewId());
        }
        for (Intention i : a.getSubNodes()) {
            this.generateIntentionIds(i, idGen);
        }
        this.getDecisionTree().numberOfAtomicActions += a.getAtomicActions().size();
        ++this.getDecisionTree().numberOfNodes;
    }

    private void generateDecisionTreeIds(DecisionTree tree, IdGenerator idGen) {
        for (Intention i : tree.topLevelGoals.values()) {
            this.generateIntentionIds(i, idGen);
        }
    }

    @Override
    public void initialize(Collection<Intention> topLevelGoals) {
        for (Intention i : topLevelGoals) {
            this.decisionTree.topLevelGoals.put(i.getName(), i);
        }
        this.generateDecisionTreeIds(this.decisionTree, this.idGenerator);
        this.present.objectNodes = new HashMap();
    }

    public void initVisualizers() {
        if (visualize) {
            this.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.INITIALIZATION, this));
            this.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.REFRESH_PAST_CHRONOBAGS, this));
            this.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.REFRESH_PRESENT_CHRONOBAG, this));
            this.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.REFRESH_CHRONOBAG_VIEW, this));
            this.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.REFRESH_SCHEMA_BAG, this));
        }
    }

    @Override
    public boolean addNewNode(String atomicAction, ArrayList<String> trace, ArrayList<AffordanceUsed> affordances) {
        return this.addNewNode(atomicAction, trace, "", affordances);
    }

    public boolean addNewNode(String atomicAction, ArrayList<String> trace, String time, ArrayList<AffordanceUsed> affordances) {
        this.sem.acquireUninterruptibly();
        Collections.reverse(trace);
        Iterator<AffordanceUsed> itr = affordances.iterator();
        AffordanceUsed aff = null;
        while (itr.hasNext()) {
            aff = itr.next();
            if (!aff.type.equals("perceived") || Parameters.REMEMBER_SEEN_ITEMS) continue;
            itr.remove();
        }
        boolean success = this.present.addNewNode(atomicAction, trace, affordances, time);
        this.schemas.updateSchema(atomicAction, trace, affordances);
        Collections.reverse(trace);
        if (this.checkNewDay(atomicAction, time)) {
            this.reorganizeMemory();
        }
        this.sem.release();
        time = time.concat(" | ");
        time = time.concat(atomicAction);
        if (visualize) {
            if (this.present.newNodeAdded) {
                this.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.REFRESH_PRESENT_CHRONOBAG, this));
            }
            this.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.UPDATE_TIME, time, this));
            this.present.newNodeAdded = false;
            this.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.REFRESH_SCHEMA_BAG, this));
            this.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.REFRESH_CHRONOBAG_VIEW, this));
        }
        return success;
    }

    private boolean checkNewDay(String action, String time) {
        boolean newDay;
        Integer day;
        if (!time.contains("day")) {
            return false;
        }
        time = time.substring(15, time.length() - 1);
        try {
            day = Integer.parseInt(time);
        }
        catch (Exception e) {
            System.err.print("Cannot check new day - error parsing time information.");
            System.err.print(e.toString());
            return false;
        }
        if (this.lastDay == -1) {
            this.lastDay = day;
            return false;
        }
        boolean bl = newDay = day > this.lastDay;
        if ((action.equals("Look for _TO_SLEEP_IN") || action.equals("SLEEP")) && newDay) {
            this.lastDay = day;
            return true;
        }
        return false;
    }

    private boolean reorganizeMemory() {
        HashMap<String, ObjectNode> objNodes = this.present.objectNodes;
        Chronobag last = this.present;
        this.present.finish();
        this.past.add(this.present);
        this.present = new Chronobag(this.idGenerator, this, last);
        this.pastSequenceEnds.put(0, this.present);
        this.present.objectNodes = objNodes;
        for (Chronobag c : this.past) {
            c.increaseDay();
        }
        if (!Parameters.NO_ABSTRACT_CHRONOBAGS) {
            this.copyEpisodesToAbstractChronobags();
        }
        if (!Parameters.NO_FORGETTING) {
            Iterator<Chronobag> it = this.past.iterator();
            while (it.hasNext()) {
                Chronobag c = it.next();
                if (c.isLandmark()) continue;
                c.decideToForgetNodes();
                if (!c.getEpisodes().isEmpty()) continue;
                c.deleteChronobag();
                if (c == this.pastSequenceEnds.get(c.getLevel())) {
                    this.pastSequenceEnds.put(c.getLevel(), c.getOlderChronobag());
                }
                it.remove();
            }
        }
        if (!Parameters.NO_EPISODE_MERGING) {
            this.consolidateEpisodes();
        }
        if (visualize) {
            this.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.REFRESH_PAST_CHRONOBAGS, this));
            this.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.REFRESH_PRESENT_CHRONOBAG, this));
            this.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.REFRESH_CHRONOBAG_VIEW, this));
        }
        return true;
    }

    public boolean nodeFinished(String node, ArrayList<String> trace, boolean succeeded) {
        this.sem.acquireUninterruptibly();
        Collections.reverse(trace);
        Boolean rv = this.present.finishNode(node, trace, succeeded);
        this.sem.release();
        return rv;
    }

    public void registerNewPastChronobag(Chronobag c) {
        this.past.add(c);
        Chronobag first = this.pastSequenceEnds.get(c.getLevel());
        if (first == null) {
            this.pastSequenceEnds.put(c.getLevel(), c);
            return;
        }
        if (c.getAge().getMaxAge() < first.getAge().getMaxAge()) {
            this.pastSequenceEnds.put(c.getLevel(), c);
        }
    }

    private void copyEpisodesToAbstractChronobags() {
        Chronobag c = this.present;
        assert (c.getEpisodes().isEmpty());
        c = c.getOlderChronobag();
        for (int i = 0; i < Parameters.MAX_CHRONOBAG_LEVELS - 1; ++i) {
            for (Episode e : c.getEpisodes()) {
                c.copyEpisodeToAbstractChronobag(e);
            }
            c = c.getMoreAbstractChronobag();
        }
        Chronobag ch = c = this.present.getOlderChronobag();
        while (c != null) {
            c.increaseMaxNumberOfNodes(ch);
            c = c.getMoreAbstractChronobag();
        }
    }

    private void consolidateEpisodes() {
        for (Chronobag c : this.past) {
            for (Episode e1 : c.getEpisodes()) {
                for (Episode e2 : c.getEpisodes()) {
                    double similarity;
                    if (e1.getIdEpisode() >= e2.getIdEpisode() || !this.decideEpisodeMerging(similarity = e1.episodeSimilarity(e2), c.getAge().getMinAge())) continue;
                    e1.mergeWith(e2);
                }
            }
        }
    }

    private boolean decideEpisodeMerging(double similarity, int age) {
        return similarity >= 1.0 - (double)age * Parameters.DECIDE_EPISODE_MERGING_COEFFICIENT;
    }

    public SchemaBag getSchemaBag() {
        return this.schemas;
    }

    public void reviewActiveIntentions(ArrayList<String> list) {
        this.present.reviewActiveEpisodes(list);
    }

    public Collection<Chronobag> getChronobags() {
        HashSet<Chronobag> col = new HashSet<Chronobag>();
        col.add(this.present);
        col.addAll(this.past);
        return col;
    }

    public Map<Integer, Chronobag> getChronobagSequenceEnds() {
        return this.pastSequenceEnds;
    }

    public Chronobag getPresentChronobag() {
        return this.present;
    }

    public HashSet<Chronobag> getPastChrononags() {
        return this.past;
    }

    public void generateStatistics(String fileName) {
        this.schemas.generateStatistics(fileName);
    }

    public Integer getLastEpisodeId() {
        return this.present.getLastEpisodeId();
    }
}

