/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.episodes;

import cz.cuni.amis.pogamut.episodic.episodes.EpisodeNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectNode;
import cz.cuni.amis.pogamut.episodic.memory.Parameters;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaCounter;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaObjectNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaSlot;
import cz.cuni.amis.pogamut.episodic.schemas.SlotContent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ObjectSlot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int id;
    private final String type;
    private final EpisodeNode parentNode;
    private HashMap<ObjectNode, Double> objects = new HashMap();

    public ObjectSlot(int _id, String _type, EpisodeNode parent) {
        this.id = _id;
        this.type = _type;
        this.parentNode = parent;
    }

    public int getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public EpisodeNode getParentNode() {
        return this.parentNode;
    }

    public void emptySlot() {
        int count = this.objects.size();
        for (EpisodeNode n = this.parentNode; n != null; n = n.getParent()) {
            n.numberOfSubNodesWithObjects -= count;
        }
        for (ObjectNode o : this.objects.keySet()) {
            o.usedAt.remove(this);
        }
        this.parentNode.getEpisodeRoot().getParentChronobag().numberOfUsedObjects -= count;
        if (this.parentNode.getEpisodeRoot().getParentChronobag().numberOfUsedObjects < 0) {
            this.parentNode.getEpisodeRoot().getParentChronobag().numberOfUsedObjects = 0;
        }
        this.objects.clear();
    }

    public void remove(ObjectNode o) {
        this.objects.remove(o);
        o.usedAt.remove(this);
        --this.parentNode.getEpisodeRoot().getParentChronobag().numberOfUsedObjects;
        assert (this.parentNode.getEpisodeRoot().getParentChronobag().numberOfUsedObjects >= 0);
        for (EpisodeNode n = this.parentNode; n != null; n = n.getParent()) {
            --n.numberOfSubNodesWithObjects;
        }
        if (this.objects.isEmpty()) {
            this.deleteSlot();
        }
    }

    public boolean addObject(ObjectNode obj, boolean increaseCounter) {
        if (this.objects.keySet().contains(obj)) {
            return false;
        }
        this.objects.put(obj, Parameters.MAX_OBJECT_SCORE);
        obj.usedAt.add(this);
        if (this.parentNode.getEpisodeRoot().getParentChronobag() != null) {
            ++this.parentNode.getEpisodeRoot().getParentChronobag().numberOfUsedObjects;
        }
        if (!increaseCounter) {
            return true;
        }
        for (EpisodeNode node = this.parentNode; node != null; node = node.getParent()) {
            ++node.numberOfSubNodesWithObjects;
        }
        return true;
    }

    public Collection<ObjectNode> getUsedObjects() {
        return this.objects.keySet();
    }

    public Collection<Double> getScore() {
        return this.objects.values();
    }

    public Collection<Double> computeScore() {
        if (this.type.equals("Other")) {
            for (Map.Entry<ObjectNode, Double> entry : this.objects.entrySet()) {
                entry.setValue(Parameters.DEFAULT_OBJECT_SCORE);
            }
            return this.objects.values();
        }
        if (this.parentNode.associatedNode == null) {
            for (Map.Entry<ObjectNode, Double> entry : this.objects.entrySet()) {
                entry.setValue(0.0);
            }
            return this.objects.values();
        }
        if (this.objects.isEmpty()) {
            return this.objects.values();
        }
        SchemaSlot ss = this.parentNode.associatedNode.getAssociatedNode().getSlot(this.type);
        int countAllSlot = 0;
        for (SlotContent con : ss.getSlotContents()) {
            countAllSlot += ((SchemaCounter)con.getCounts().get((Object)0).iterator().next()).getCount();
        }
        for (ObjectNode o : this.objects.keySet()) {
            int count = 0;
            SlotContent c = ss.getSlotContent(o.getName());
            count += ((SchemaCounter)c.getCounts().get((Object)0).iterator().next()).getCount();
            int countAllObject = 0;
            SchemaObjectNode so = c.getObject();
            for (SlotContent con : so.getSlotContents()) {
                countAllObject += ((SchemaCounter)con.getCounts().get((Object)0).iterator().next()).getCount();
            }
            double score = 1.0 - 2.0 * (double)count / (double)(countAllObject + countAllSlot);
            score = (Parameters.MAX_OBJECT_SCORE - Parameters.MIN_OBJECT_SCORE) * score + Parameters.MIN_OBJECT_SCORE;
            this.objects.put(o, score);
        }
        return this.objects.values();
    }

    public boolean deleteSlot() {
        String otherType = "Other";
        ObjectSlot otherSlot = this.getParentNode().getObjectSlot(otherType);
        if (otherSlot == null) {
            this.getParentNode().addSlot(otherType);
            otherSlot = this.getParentNode().getObjectSlot(otherType);
        }
        for (ObjectNode o : this.getUsedObjects()) {
            otherSlot.addObject(o, true);
        }
        this.emptySlot();
        this.getParentNode().slots.remove(this.type);
        return true;
    }

    public void forgetConnections(double kScore) {
        HashSet<ObjectNode> set = new HashSet<ObjectNode>();
        set.addAll(this.objects.keySet());
        for (ObjectNode obj : set) {
            if (!(this.objects.get(obj) < kScore)) continue;
            this.remove(obj);
        }
    }

    public double getScore(ObjectNode o) {
        if (this.objects.containsKey(o)) {
            return this.objects.get(o);
        }
        return 0.0;
    }
}

