/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.episodes;

import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.decisions.NodeType;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectSlot;
import cz.cuni.amis.pogamut.episodic.memory.Parameters;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaBag;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaCounter;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaSlot;
import cz.cuni.amis.pogamut.episodic.schemas.SlotContent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class EpisodeNode
implements Serializable,
Comparable<EpisodeNode> {
    private static final long serialVersionUID = 1L;
    private final int id;
    private final String name;
    final Node associatedNode;
    private EpisodeNode parent;
    private Episode root;
    HashMap<String, EpisodeNode> children = new HashMap();
    private Map<Integer, EpisodeNode> firstChild = new HashMap<Integer, EpisodeNode>();
    private Map<Integer, EpisodeNode> lastChild = new HashMap<Integer, EpisodeNode>();
    private Map<Integer, EpisodeNode> successors = new HashMap<Integer, EpisodeNode>();
    private Map<Integer, EpisodeNode> predecessors = new HashMap<Integer, EpisodeNode>();
    HashMap<String, ObjectSlot> slots = new HashMap();
    public boolean finished = false;
    public boolean succeeded = false;
    private double score = Parameters.MAX_NODE_SCORE;
    int numberOfSubNodes = 0;
    int numberOfSubNodesWithObjects = 0;
    private final int countAtCreation;
    String timeStart;
    String timeFinish;
    boolean consumed = false;

    public EpisodeNode(String _name, EpisodeNode _parent, Episode _root, Node associated) {
        this.name = _name;
        this.parent = _parent;
        this.root = _root;
        this.associatedNode = associated;
        this.id = this.root.idGen.getNewId();
        this.countAtCreation = associated == null ? 0 : (associated.getAssociatedNode() == null ? 1 : associated.getAssociatedNode().getSingleCount() + 1);
    }

    public EpisodeNode(EpisodeNode other, EpisodeNode parent, Episode e) {
        this.name = other.name;
        this.parent = parent;
        this.root = e;
        this.associatedNode = other.associatedNode;
        this.id = e.idGen.getNewId();
        this.countAtCreation = other.countAtCreation;
        this.numberOfSubNodes = other.numberOfSubNodes;
        this.numberOfSubNodesWithObjects = other.numberOfSubNodesWithObjects;
        this.succeeded = other.succeeded;
        this.finished = other.finished;
        this.timeStart = other.timeStart;
        this.timeFinish = other.timeFinish;
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        String str = "";
        str = "Name: " + this.name;
        str = str + newline + "Started: " + this.timeStart;
        str = str + newline + "Finished: " + this.timeFinish;
        str = str + newline + "Succeeded: " + this.succeeded;
        str = str + newline + "Associated node: ";
        if (this.getAssociatedNode() == null) {
            str = str + "null";
        } else {
            try {
                str = str + this.getAssociatedNode().getId() + " " + this.getAssociatedNode().getName();
            }
            catch (Exception e) {
                System.err.println("Could not retrieve id of associated node (node id: " + this.getId() + ").");
                System.err.println(e.getMessage());
            }
        }
        return str;
    }

    public boolean finishNode(String node, ArrayList<String> trace, boolean _succeeded) {
        if (trace.isEmpty()) {
            if (node.equals(this.name)) {
                this.finished = true;
                this.succeeded = _succeeded;
                return true;
            }
            return false;
        }
        String child = trace.remove(0);
        return this.getChild(child).finishNode(node, trace, _succeeded);
    }

    public int getId() {
        return this.id;
    }

    public int numberOfCommonSubNodesWithObjects(EpisodeNode other) {
        int sum = 0;
        if (other.name.equals(this.name)) {
            ++sum;
        } else {
            return sum;
        }
        Iterator<Serializable> i$ = this.children.values().iterator();
        while (i$.hasNext()) {
            EpisodeNode node;
            EpisodeNode temp = node = i$.next();
            if (!other.children.containsKey(temp.name)) continue;
            sum += temp.numberOfCommonSubNodesWithObjects(other.getChild(temp.name));
        }
        for (ObjectSlot slot : this.slots.values()) {
            if (!other.slots.containsKey(slot.getType())) continue;
            Collection<ObjectNode> col1 = slot.getUsedObjects();
            Collection<ObjectNode> col2 = other.slots.get(slot.getType()).getUsedObjects();
            for (ObjectNode obj : col1) {
                if (!col2.contains(obj)) continue;
                ++sum;
            }
        }
        return sum;
    }

    public String getName() {
        return this.name;
    }

    public EpisodeNode getParent() {
        return this.parent;
    }

    public Node getAssociatedNode() {
        return this.associatedNode;
    }

    public Collection<ObjectSlot> getObjectSlots() {
        return this.slots.values();
    }

    public ObjectSlot getObjectSlot(String type) {
        return this.slots.get(type);
    }

    public boolean addChildNode(String name) {
        return this.addChildNode(name, "");
    }

    public boolean addChildNode(String name, String time) {
        if (this.children.containsKey(name)) {
            this.children.get((Object)name).timeFinish = time;
            return false;
        }
        Node associated = null;
        if (this.associatedNode != null) {
            associated = (Node)this.associatedNode.getSubNode(name);
        }
        EpisodeNode node = new EpisodeNode(name, this, this.root, associated);
        node.timeStart = time;
        node.timeFinish = time;
        EpisodeNode parentNode = this;
        while (parentNode != null) {
            ++parentNode.numberOfSubNodes;
            ++parentNode.numberOfSubNodesWithObjects;
            parentNode = parentNode.parent;
        }
        if (this.root.getParentChronobag() != null) {
            ++this.root.getParentChronobag().numberOfEpisodeNodes;
            this.root.getParentChronobag().newNodeAdded = true;
        }
        if (this.children.isEmpty()) {
            this.firstChild.put(this.root.idEpisode, node);
        }
        this.children.put(name, node);
        if (this.lastChild.containsKey(this.root.idEpisode) && this.lastChild.get(this.root.idEpisode) != null) {
            this.lastChild.get((Object)Integer.valueOf((int)this.root.idEpisode)).successors.put(this.root.idEpisode, node);
            node.predecessors.put(this.root.idEpisode, this.lastChild.get(this.root.idEpisode));
        }
        this.lastChild.put(this.root.idEpisode, node);
        return true;
    }

    public EpisodeNode getChild(String name) {
        if (!this.children.containsKey(name)) {
            return null;
        }
        return this.children.get(name);
    }

    public Collection<EpisodeNode> getChildrenNodes() {
        return this.children.values();
    }

    public Episode getEpisodeRoot() {
        return this.root;
    }

    public void addSlot(String type) {
        if (this.slots.containsKey(type)) {
            return;
        }
        this.slots.put(type, new ObjectSlot(this.root.idGen.getNewId(), type, this));
        if (this.root.getParentChronobag() != null) {
            this.root.getParentChronobag().newNodeAdded = true;
        }
    }

    public void fillSlot(String type, String item) {
        ObjectSlot slot = this.slots.get(type);
        ObjectNode obj = this.root.getParentChronobag().objectNodes.get(item);
        this.root.getParentChronobag().newNodeAdded = true;
        boolean added = slot.addObject(obj, true);
    }

    public Map<Integer, EpisodeNode> getSuccessor() {
        return this.successors;
    }

    public Map<Integer, EpisodeNode> getPredecessor() {
        return this.predecessors;
    }

    public Map<Integer, EpisodeNode> getFirstChild() {
        return this.firstChild;
    }

    public double getScore() {
        return this.score;
    }

    public double calculateScore() {
        if (this.associatedNode == null) {
            this.score = 0.0;
            return this.score;
        }
        double actualCount = this.root.mem.getSchemaBag().getSchemaENode(this.associatedNode.getName()).getSingleCount().intValue();
        double creationCount = this.countAtCreation;
        double level = this.root.getParentChronobag().getLevel();
        boolean bottom = this.children.isEmpty();
        double attractivity = this.associatedNode.getAttractivity();
        double maxSlotScore = 0.0;
        double derivability = 1.0;
        if (bottom) {
            derivability = this.nodeDerivability();
        }
        for (ObjectSlot s : this.slots.values()) {
            for (Double d : s.getScore()) {
                if (!(d > maxSlotScore)) continue;
                maxSlotScore = d;
            }
        }
        this.score = 20.0;
        this.score += (1.0 - derivability) * Parameters.NODE_SCORE_DERIVABILITY_WEIGHT;
        this.score += Math.max(0.0, Parameters.NODE_SCORE_ACTUAL_COUNT_WEIGHT - actualCount + 1.0);
        this.score += Math.max(0.0, Parameters.NODE_SCORE_CREATION_COUNT_WEIGHT - 3.0 * creationCount + 1.0);
        if (!bottom) {
            this.score += Parameters.NODE_SCORE_BOTTOM_WEIGHT;
        }
        this.score += attractivity / 100.0 * Parameters.NODE_SCORE_ATTRACTIVITY_WEIGHT;
        this.score += maxSlotScore / Parameters.MAX_NODE_SCORE * Parameters.NODE_SCORE_AFFORDANCES_WEIGHT;
        return this.score;
    }

    public EpisodeNode createCopy(EpisodeNode parent, Episode e) {
        assert (this.validateNode(this)) : this.id;
        EpisodeNode n = new EpisodeNode(this, parent, e);
        LinkedList<EpisodeNode> q = new LinkedList<EpisodeNode>();
        q.addAll(this.children.values());
        while (!q.isEmpty()) {
            EpisodeNode child = (EpisodeNode)q.poll();
            EpisodeNode newChild = child.createCopy(n, e);
            n.children.put(newChild.name, newChild);
        }
        for (Map.Entry<Integer, EpisodeNode> entry : this.firstChild.entrySet()) {
            n.firstChild.put(entry.getKey(), n.children.get(this.firstChild.get((Object)entry.getKey()).name));
        }
        for (Map.Entry<Integer, EpisodeNode> entry : this.lastChild.entrySet()) {
            n.lastChild.put(entry.getKey(), n.children.get(this.lastChild.get((Object)entry.getKey()).name));
        }
        for (EpisodeNode ch : this.children.values()) {
            for (Map.Entry<Integer, EpisodeNode> entry : ch.successors.entrySet()) {
                n.children.get((Object)ch.getName()).successors.put(entry.getKey(), n.children.get(entry.getValue().getName()));
                n.children.get((Object)entry.getValue().getName()).predecessors.put(entry.getKey(), n.children.get(ch.getName()));
            }
        }
        for (ObjectSlot s : this.slots.values()) {
            n.addSlot(s.getType());
            for (ObjectNode o : s.getUsedObjects()) {
                n.slots.get(s.getType()).addObject(o, false);
            }
        }
        assert (this.validateNode(this.children.values())) : this.id;
        return n;
    }

    public void fullDelete(boolean episodeDeleted) {
        HashSet<EpisodeNode> nodes = new HashSet<EpisodeNode>();
        nodes.addAll(this.children.values());
        for (EpisodeNode n : nodes) {
            n.fullDelete(episodeDeleted);
        }
        this.deleteNode(episodeDeleted);
    }

    public void deleteNode() {
        this.deleteNode(false);
    }

    public void deleteNode(boolean skipChecks) {
        if (!skipChecks) {
            assert (this.validateNode(this)) : this.id;
            assert (this.validateNode(this.parent)) : this.id;
            assert (this.validateNode(this.children.values())) : this.id;
        }
        String otherType = "Other";
        HashSet<ObjectSlot> col = new HashSet<ObjectSlot>();
        col.addAll(this.slots.values());
        for (ObjectSlot s : col) {
            if (s.getType().equals(otherType)) continue;
            s.deleteSlot();
        }
        ObjectSlot s = this.slots.get(otherType);
        if (s != null && this.parent != null) {
            this.parent.addSlot(otherType);
            ObjectSlot ps = this.parent.getObjectSlot(otherType);
            for (ObjectNode o : s.getUsedObjects()) {
                if (!ps.addObject(o, true)) continue;
                for (EpisodeNode n = this; n != null; n = n.getParent()) {
                    ++n.numberOfSubNodesWithObjects;
                }
            }
            s.emptySlot();
        }
        if (s != null) {
            s.deleteSlot();
        }
        assert (this.slots.isEmpty());
        if (this.parent == null) {
            this.root.deleted = true;
            if (this.children.isEmpty() && !skipChecks) {
                this.root.getParentChronobag().deleteEpisode(this.root);
            }
            return;
        }
        if (!skipChecks) {
            assert (this.validateNode(this)) : this.id;
            assert (this.validateNode(this.parent)) : this.id;
            assert (this.validateNode(this.children.values())) : this.id;
        }
        this.removeSequenceReferences(true);
        this.parent.children.remove(this.name);
        HashSet<EpisodeNode> oldChildren = new HashSet<EpisodeNode>();
        oldChildren.addAll(this.children.values());
        for (EpisodeNode child : oldChildren) {
            if (this.parent.children.containsKey(child.name)) {
                this.parent.getChild(child.name).mergeWith(child);
                continue;
            }
            this.parent.children.put(child.name, child);
            child.parent = this.parent;
        }
        EpisodeNode p = this.parent;
        while (p != null) {
            --p.numberOfSubNodes;
            --p.numberOfSubNodesWithObjects;
            p = p.parent;
        }
        if (!skipChecks) {
            assert (this.validateNode(this.parent)) : this.id;
            assert (this.validateNode(this.children.values())) : this.id;
        }
    }

    private void removeSequenceReferences(boolean moveChildrenUp) {
        if (!this.children.isEmpty() && moveChildrenUp) {
            int key;
            for (Map.Entry<Integer, EpisodeNode> entry : this.predecessors.entrySet()) {
                key = entry.getKey();
                this.predecessors.get((Object)Integer.valueOf((int)key)).successors.put(key, this.firstChild.get(key));
                this.firstChild.get((Object)Integer.valueOf((int)key)).predecessors.put(key, entry.getValue());
            }
            for (Map.Entry<Integer, EpisodeNode> entry : this.successors.entrySet()) {
                key = entry.getKey();
                this.successors.get((Object)Integer.valueOf((int)key)).predecessors.put(key, this.lastChild.get(key));
                this.lastChild.get((Object)Integer.valueOf((int)key)).successors.put(key, entry.getValue());
            }
        } else {
            for (Map.Entry<Integer, EpisodeNode> entry : this.predecessors.entrySet()) {
                if (this.successors.containsKey(entry.getKey())) {
                    entry.getValue().successors.put(entry.getKey(), this.successors.get(entry.getKey()));
                    continue;
                }
                entry.getValue().successors.remove(entry.getKey());
            }
            for (Map.Entry<Integer, EpisodeNode> entry : this.successors.entrySet()) {
                if (this.predecessors.containsKey(entry.getKey())) {
                    entry.getValue().predecessors.put(entry.getKey(), this.predecessors.get(entry.getKey()));
                    continue;
                }
                entry.getValue().predecessors.remove(entry.getKey());
            }
        }
        EpisodeNode par = this.parent;
        while (par != null) {
            Iterator<Map.Entry<Integer, EpisodeNode>> it = par.firstChild.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, EpisodeNode> entry = it.next();
                if (entry.getValue() != this) continue;
                if (!this.children.isEmpty()) {
                    entry.setValue(this.firstChild.get(entry.getKey()));
                    continue;
                }
                if (this.successors.containsKey(entry.getKey())) {
                    entry.setValue(this.successors.get(entry.getKey()));
                    continue;
                }
                it.remove();
            }
            it = par.lastChild.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, EpisodeNode> entry = it.next();
                if (entry.getValue() != this) continue;
                if (!this.children.isEmpty()) {
                    entry.setValue(this.lastChild.get(entry.getKey()));
                    continue;
                }
                if (this.predecessors.containsKey(entry.getKey())) {
                    entry.setValue(this.predecessors.get(entry.getKey()));
                    continue;
                }
                it.remove();
            }
            par = par.parent;
        }
        this.predecessors.clear();
        this.successors.clear();
    }

    boolean validateNode(Collection<EpisodeNode> col) {
        for (EpisodeNode n : col) {
            if (this.validateNode(n)) continue;
            return false;
        }
        return true;
    }

    boolean validateNode(EpisodeNode n) {
        if (n == null) {
            return true;
        }
        EpisodeNode par = n.getParent();
        while (par != null) {
            if (par == n) {
                System.err.println("Loop in the episode tree: " + n.id);
                return false;
            }
            par = par.parent;
        }
        if (this.associatedNode != null) {
            if (!this.associatedNode.getName().equals(this.name)) {
                System.err.println("Associated node name inconsistency: " + n.id);
                return false;
            }
            if (this.associatedNode.parent == null && this.parent != null) {
                System.err.println("Invalid parent: " + n.id);
                return false;
            }
            if (this.associatedNode.parent != null && this.parent == null) {
                System.err.println("Missing parent: " + n.id);
                return false;
            }
        }
        for (EpisodeNode ch : n.children.values()) {
            if (ch.parent != n) {
                System.err.println("Child-Parent inconsistency: " + n.id);
                return false;
            }
            if (ch != n) continue;
            System.err.println("Self-child inconsistency: " + n.id);
            return false;
        }
        if (!n.children.isEmpty()) {
            for (EpisodeNode ch : n.firstChild.values()) {
                if (n.children.containsValue(ch)) continue;
                System.err.println("First child inconsistency: " + n.id);
                return false;
            }
            for (EpisodeNode ch : n.lastChild.values()) {
                if (n.children.containsValue(ch)) continue;
                System.err.println("Last child inconsistency: " + n.id);
                return false;
            }
        }
        for (EpisodeNode p : n.predecessors.values()) {
            if (!p.successors.containsValue(n)) {
                System.err.println("Predecessor-Successor inconsistency: " + n.id);
                return false;
            }
            if (p.parent.id != n.parent.id) {
                System.err.println("Predecessor-Parent inconsistency: " + n.id);
                return false;
            }
            if (p.parent.children.containsValue(p)) continue;
            System.err.println("Predecessor-Brother inconsistency: " + n.id);
            return false;
        }
        for (EpisodeNode s : n.successors.values()) {
            if (!s.predecessors.containsValue(n)) {
                System.err.println("Successor-Predecessor inconsistency: " + n.id);
                return false;
            }
            if (s.parent.id != n.parent.id) {
                System.err.println("Successor-Parent inconsistency: " + n.id);
                return false;
            }
            if (s.parent.children.containsValue(s)) continue;
            System.err.println("Successor-Brother inconsistency: " + n.id);
            return false;
        }
        if (n.parent != null) {
            if (!n.parent.children.containsValue(n)) {
                System.err.println("Parent-Child inconsistency: " + n.id);
                return false;
            }
            if (n.predecessors.isEmpty() && !n.parent.firstChild.containsValue(n)) {
                System.err.println("Parent-First child inconsistency: " + n.id);
                return false;
            }
            if (n.successors.isEmpty() && !n.parent.lastChild.containsValue(n)) {
                System.err.println("Parent-Last child inconsistency: " + n.id);
                return false;
            }
        }
        for (Integer i : n.firstChild.keySet()) {
            if (!n.lastChild.containsKey(i)) {
                System.err.println("First child - last child set inconsistency: " + n.id);
                return false;
            }
            if (n.firstChild.get(i) == n.lastChild.get(i) && n.firstChild.get((Object)i).successors.containsKey(i)) {
                System.err.println("First child single sequence inconsistency: " + n.id);
                return false;
            }
            if (n.firstChild.get(i) == n.lastChild.get(i) || n.firstChild.get((Object)i).successors.containsKey(i) && n.firstChild.get((Object)i).successors.get(i) != null) continue;
            System.err.println("First child multi sequence inconsistency: " + n.id);
            return false;
        }
        for (Integer i : n.lastChild.keySet()) {
            if (!n.firstChild.containsKey(i)) {
                System.err.println("Last child - first child set inconsistency: " + n.id);
                return false;
            }
            if (n.firstChild.get(i) == n.lastChild.get(i) && n.lastChild.get((Object)i).predecessors.containsKey(i)) {
                System.err.println("Last child single sequence inconsistency: " + n.id);
                return false;
            }
            if (n.firstChild.get(i) == n.lastChild.get(i) || n.lastChild.get((Object)i).predecessors.containsKey(i) && n.lastChild.get((Object)i).predecessors.get(i) != null) continue;
            System.err.println("Last child multi sequence inconsistency: " + n.id);
            return false;
        }
        return true;
    }

    private double nodeDerivability() {
        this.validateNode(this);
        Chronobag c = this.root.getParentChronobag();
        Chronobag chron = new Chronobag(c.idGenerator, c.getMemory());
        Episode episode1 = this.root.createCopy(chron);
        Episode episode2 = this.root.createCopy(chron);
        ArrayList<String> list = new ArrayList<String>();
        EpisodeNode n = this.parent;
        list.add(this.name);
        while (n != null) {
            list.add(0, n.getName());
            n = n.parent;
        }
        n = episode2.getRoot();
        list.remove(0);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            n = n.getChild((String)it.next());
        }
        n.deleteNode();
        episode2 = episode2.deriveEpisode();
        n = episode2.getRoot();
        it = list.iterator();
        while (it.hasNext()) {
            if ((n = n.getChild((String)it.next())) != null) continue;
            return 0.0;
        }
        episode1 = episode1.deriveEpisode();
        this.validateNode(this);
        return episode1.episodeSimilarity(episode2);
    }

    private void setRoot(Episode newRoot) {
        this.root = newRoot;
        for (EpisodeNode n : this.children.values()) {
            n.setRoot(newRoot);
        }
    }

    public EpisodeNode mergeWith(EpisodeNode other) {
        assert (this.getName().equals(other.getName()));
        other.consumed = true;
        HashSet<EpisodeNode> copiedChildren = new HashSet<EpisodeNode>();
        for (EpisodeNode episodeNode : other.getChildrenNodes()) {
            if (this.children.containsKey(episodeNode.getName())) continue;
            copiedChildren.add(episodeNode);
        }
        for (Map.Entry entry : other.firstChild.entrySet()) {
            int key = (Integer)entry.getKey();
            HashSet<EpisodeNode> sequenced = new HashSet<EpisodeNode>();
            EpisodeNode n = this.firstChild.get(key);
            while (n != null) {
                sequenced.add(n);
                n = n.getSuccessor().get(key);
            }
            n = (EpisodeNode)entry.getValue();
            EpisodeNode next = null;
            other.lastChild.put(key, null);
            while (n != null) {
                next = n.getSuccessor().get(key);
                if (copiedChildren.contains(n)) {
                    this.children.put(n.getName(), n);
                    other.children.remove(n.getName());
                    n.parent = this;
                    n.setRoot(this.root);
                    if (entry.getValue() == n) {
                        entry.setValue(next);
                    }
                    if (n.predecessors.get(key) != null) {
                        assert (n.predecessors.get((Object)Integer.valueOf((int)key)).successors.get(key) == n);
                        if (n.successors.get(key) != null) {
                            n.predecessors.get((Object)Integer.valueOf((int)key)).successors.put(key, n.successors.get(key));
                        } else {
                            n.predecessors.get((Object)Integer.valueOf((int)key)).successors.remove(key);
                        }
                    }
                    if (n.successors.get(key) != null) {
                        assert (n.successors.get((Object)Integer.valueOf((int)key)).predecessors.get(key) == n);
                        if (n.predecessors.get(key) != null) {
                            n.successors.get((Object)Integer.valueOf((int)key)).predecessors.put(key, n.predecessors.get(key));
                        } else {
                            n.successors.get((Object)Integer.valueOf((int)key)).predecessors.remove(key);
                        }
                    }
                } else {
                    assert (n.parent == other);
                    other.lastChild.put(key, n);
                }
                if (!sequenced.contains(n = this.children.get(n.getName()))) {
                    if (this.lastChild.get(key) != null) {
                        assert (this.lastChild.get((Object)Integer.valueOf((int)key)).successors.get(key) == null);
                        n.predecessors.put(key, this.lastChild.get(key));
                        this.lastChild.get((Object)Integer.valueOf((int)key)).successors.put(key, n);
                    }
                    if (!this.firstChild.containsKey(key)) {
                        assert (!this.lastChild.containsKey(key));
                        this.firstChild.put(key, n);
                        n.predecessors.remove(key);
                    }
                    n.successors.remove(key);
                    this.lastChild.put(key, n);
                }
                sequenced.add(n);
                n = next;
                if (n == null) continue;
                next = n.getSuccessor().get(key);
            }
        }
        Iterator<Map.Entry<Integer, EpisodeNode>> i = other.firstChild.entrySet().iterator();
        while (i.hasNext()) {
            if (i.next().getValue() != null) continue;
            i.remove();
        }
        i = other.lastChild.entrySet().iterator();
        while (i.hasNext()) {
            if (i.next().getValue() != null) continue;
            i.remove();
        }
        Object var4_7 = null;
        Iterator<Map.Entry<String, ObjectSlot>> iter = other.slots.entrySet().iterator();
        while (iter.hasNext()) {
            ObjectSlot objectSlot = iter.next().getValue();
            if (!this.slots.containsKey(objectSlot.getType())) {
                this.addSlot(objectSlot.getType());
            }
            ObjectSlot slot = this.slots.get(objectSlot.getType());
            for (ObjectNode o : objectSlot.getUsedObjects()) {
                slot.addObject(o, true);
            }
            objectSlot.emptySlot();
            iter.remove();
        }
        HashSet<EpisodeNode> otherChildren = new HashSet<EpisodeNode>();
        otherChildren.addAll(other.getChildrenNodes());
        for (EpisodeNode otherChild : otherChildren) {
            if (!this.children.containsKey(otherChild.getName())) continue;
            this.children.get(otherChild.getName()).mergeWith(otherChild);
        }
        other.fullDelete(true);
        this.numberOfSubNodes = 0;
        this.numberOfSubNodesWithObjects = 0;
        for (EpisodeNode child : this.children.values()) {
            this.numberOfSubNodes += child.numberOfSubNodes + 1;
            this.numberOfSubNodesWithObjects += child.numberOfSubNodesWithObjects + 1;
        }
        for (ObjectSlot slot : this.slots.values()) {
            this.numberOfSubNodesWithObjects += slot.getUsedObjects().size();
        }
        return this;
    }

    public EpisodeNode deriveNodeTrace() {
        boolean added;
        EpisodeNode newNode;
        if (this.associatedNode.parent == this.parent.associatedNode) {
            System.out.println("-1 assoc " + this.associatedNode.getName());
            System.out.println("-2 this  " + this.getName());
            System.out.println("-3 par   " + this.parent.getName());
            System.out.println("-4 a.par " + this.associatedNode.parent.getName());
            System.out.println("-5 par.a " + this.parent.associatedNode.getName());
        }
        assert (this.associatedNode.parent != this.parent.associatedNode);
        assert (this.validateNode(this));
        assert (this.validateNode(this.parent));
        if (this.associatedNode.parent == null) {
            System.out.println("-1 " + this.associatedNode.getName());
            System.out.println("-2 " + this.getName());
            System.out.println("-3 " + this.parent.getName());
        }
        if ((newNode = this.getParent().getChild(this.associatedNode.parent.getName())) == null) {
            newNode = new EpisodeNode(this.associatedNode.parent.getName(), this.getParent(), this.root, this.associatedNode.parent);
            added = true;
            for (Map.Entry<Integer, EpisodeNode> entry : this.successors.entrySet()) {
                assert (entry.getValue().predecessors.get(entry.getKey()) == this);
                entry.getValue().predecessors.put(entry.getKey(), newNode);
                newNode.successors.put(entry.getKey(), entry.getValue());
            }
            this.successors.clear();
            for (Map.Entry<Integer, EpisodeNode> entry : this.predecessors.entrySet()) {
                assert (entry.getValue().successors.get(entry.getKey()) == this);
                entry.getValue().successors.put(entry.getKey(), newNode);
                newNode.predecessors.put(entry.getKey(), entry.getValue());
            }
            this.predecessors.clear();
            for (Map.Entry<Integer, EpisodeNode> entry : this.parent.firstChild.entrySet()) {
                if (entry.getValue() == this) {
                    entry.setValue(newNode);
                }
                newNode.firstChild.put(entry.getKey(), this);
            }
            for (Map.Entry<Integer, EpisodeNode> entry : this.parent.lastChild.entrySet()) {
                if (entry.getValue() == this) {
                    entry.setValue(newNode);
                }
                newNode.lastChild.put(entry.getKey(), this);
            }
            this.parent.children.remove(this.name);
            this.parent.children.put(newNode.name, newNode);
            this.parent = newNode;
            newNode.children.put(this.name, this);
        } else {
            Map.Entry<Integer, EpisodeNode> entry2;
            assert (this.validateNode(newNode));
            EpisodeNode tempParent = new EpisodeNode(this.associatedNode.parent.getName(), null, this.root, this.associatedNode.parent);
            added = false;
            tempParent.children.put(this.name, this);
            Iterator<Map.Entry<Integer, EpisodeNode>> it = this.parent.firstChild.entrySet().iterator();
            while (it.hasNext()) {
                entry2 = it.next();
                if (entry2.getValue() == this) {
                    entry2.setValue(this.successors.get(entry2.getKey()));
                }
                tempParent.firstChild.put(entry2.getKey(), this);
                if (entry2.getValue() != null) continue;
                it.remove();
            }
            it = this.parent.lastChild.entrySet().iterator();
            while (it.hasNext()) {
                entry2 = it.next();
                if (entry2.getValue() == this) {
                    entry2.setValue(this.predecessors.get(entry2.getKey()));
                }
                tempParent.lastChild.put(entry2.getKey(), this);
                if (entry2.getValue() != null) continue;
                it.remove();
            }
            for (Map.Entry<Integer, EpisodeNode> entry2 : this.predecessors.entrySet()) {
                assert (entry2.getValue().successors.get(entry2.getKey()) == this);
                if (this.successors.containsKey(entry2.getKey())) {
                    entry2.getValue().successors.put(entry2.getKey(), this.successors.get(entry2.getKey()));
                    continue;
                }
                entry2.getValue().successors.remove(entry2.getKey());
            }
            for (Map.Entry<Integer, EpisodeNode> entry2 : this.successors.entrySet()) {
                assert (entry2.getValue().predecessors.get(entry2.getKey()) == this);
                if (this.predecessors.containsKey(entry2.getKey())) {
                    entry2.getValue().predecessors.put(entry2.getKey(), this.predecessors.get(entry2.getKey()));
                    continue;
                }
                entry2.getValue().predecessors.remove(entry2.getKey());
            }
            this.predecessors.clear();
            this.successors.clear();
            this.parent.children.remove(this.name);
            this.parent = tempParent;
            assert (this.validateNode(newNode));
            newNode.mergeWith(tempParent);
            assert (this.validateNode(newNode));
        }
        if (added) {
            EpisodeNode n = this.parent;
            while (n != null) {
                ++n.numberOfSubNodes;
                ++n.numberOfSubNodesWithObjects;
                n = n.parent;
            }
            newNode.numberOfSubNodes = this.numberOfSubNodes + 1;
            newNode.numberOfSubNodesWithObjects = this.numberOfSubNodesWithObjects + 1;
        } else {
            newNode.numberOfSubNodes += this.numberOfSubNodes + 1;
            newNode.numberOfSubNodesWithObjects += this.numberOfSubNodesWithObjects + 1;
        }
        assert (this.associatedNode.parent.getName().equals(this.parent.associatedNode.getName()));
        assert (this.validateNode(newNode));
        assert (this.validateNode(newNode.getChildrenNodes()));
        assert (this.validateNode(newNode.parent));
        return newNode;
    }

    public EpisodeNode deriveChildrenAndSlots(Collection<SchemaEpisodeNode> traceSchemaNodes, Collection<SlotContent> schemaContents) {
        SchemaCounter includedCounter;
        EpisodeNode newChild = null;
        SchemaEpisodeNode newSchemaChild = null;
        HashSet<SchemaEpisodeNode> possibleChildren = new HashSet<SchemaEpisodeNode>();
        if (this.associatedNode.getAssociatedNode() == null) {
            SchemaEpisodeNode s = this.root.getParentChronobag().getMemory().getSchemaBag().getSchemaENode(this.name);
            this.associatedNode.setAssociatedSchemaNode(s);
        }
        traceSchemaNodes.remove(null);
        possibleChildren.addAll(this.associatedNode.getAssociatedNode().getChildrenSchemaNodes());
        for (EpisodeNode n : this.children.values()) {
            if (n.associatedNode == null) continue;
            possibleChildren.remove(n.associatedNode.getAssociatedNode());
        }
        HashSet<SlotContent> possibleContents = new HashSet<SlotContent>();
        for (SchemaEpisodeNode traceNode : traceSchemaNodes) {
            for (SchemaSlot sSlot : traceNode.getSlots()) {
                for (SlotContent slotContent : sSlot.getSlotContents()) {
                    if (schemaContents.contains(slotContent)) continue;
                    possibleContents.add(slotContent);
                }
            }
        }
        SchemaBag schemas = this.root.mem.getSchemaBag();
        Collection<SchemaCounter> counts = schemas.getAllExistingSubSets(traceSchemaNodes, schemaContents, Parameters.MAX_SCHEMA_COMBINATION_COUNT);
        double maxPerc = 0.0;
        HashSet<SchemaEpisodeNode> schemaNodeCollection = new HashSet<SchemaEpisodeNode>();
        if (this.associatedNode.getType() == NodeType.INTENTION || this.children.isEmpty()) {
            for (SchemaCounter count : counts) {
                int total = count.getCount();
                schemaNodeCollection.clear();
                schemaNodeCollection.addAll(count.getENodes());
                for (SchemaEpisodeNode n : possibleChildren) {
                    schemaNodeCollection.add(n);
                    if (schemaNodeCollection.size() > Parameters.MAX_SCHEMA_COMBINATION_COUNT) continue;
                    includedCounter = schemas.getCounter(schemaNodeCollection, count.getContentsNodes(), Parameters.MAX_SCHEMA_COMBINATION_COUNT);
                    int includedTotal = includedCounter == null ? 0 : includedCounter.getCount();
                    schemaNodeCollection.remove(n);
                    double perc = includedTotal / total;
                    if (!(perc > maxPerc)) continue;
                    newSchemaChild = n;
                    maxPerc = perc;
                }
            }
        }
        HashSet<SlotContent> slotContentsCollecion = new HashSet<SlotContent>();
        for (SchemaCounter count : counts) {
            int total = count.getCount();
            slotContentsCollecion.clear();
            slotContentsCollecion.addAll(count.getContentsNodes());
            Iterator iter = possibleContents.iterator();
            while (iter.hasNext()) {
                SlotContent c = (SlotContent)iter.next();
                slotContentsCollecion.add(c);
                if (slotContentsCollecion.size() + count.getENodes().size() > Parameters.MAX_SCHEMA_COMBINATION_COUNT || (includedCounter = schemas.getCounter(count.getENodes(), slotContentsCollecion, Parameters.MAX_SCHEMA_COMBINATION_COUNT)) == null) continue;
                int includedTotal = includedCounter.getCount();
                slotContentsCollecion.remove(c);
                double perc = (double)includedTotal / (double)total;
                if (!(perc > Parameters.PERCENTAGE_TO_DERIVE_OBJECT)) continue;
                ObjectSlot slot = null;
                EpisodeNode slotParent = this;
                while (slotParent != null && !slotParent.associatedNode.getAssociatedNode().getSlots().contains(c.getSlot())) {
                    slotParent = slotParent.parent;
                }
                assert (slotParent != null);
                if (slotParent == null) {
                    System.err.println("Could not derive object - cannot find parent node.");
                    continue;
                }
                slot = this.getObjectSlot(c.getSlot().getType());
                if (slot == null) {
                    slotParent.addSlot(c.getSlot().getType());
                    slot = slotParent.getObjectSlot(c.getSlot().getType());
                    ObjectNode o = this.root.mem.getPresentChronobag().objectNodes.get(c.getObject().getName());
                    while (slotParent != null) {
                        if (slotParent.getObjectSlot("Other") != null && slotParent.getObjectSlot("Other").getUsedObjects().contains(o)) {
                            slotParent.getObjectSlot("Other").remove(o);
                        }
                        slotParent = slotParent.getParent();
                    }
                }
                slot.addObject(this.root.mem.getPresentChronobag().createObjectNode(c.getObject().getName()), true);
                iter.remove();
            }
        }
        if (newSchemaChild == null) {
            return null;
        }
        this.addChildNode(newSchemaChild.getName(), "");
        newChild = this.children.get(newSchemaChild.getName());
        return newChild;
    }

    public int getNumberOfSubNodes() {
        return this.numberOfSubNodes;
    }

    public int getNumberOfSubNodesWithObjects() {
        return this.numberOfSubNodesWithObjects;
    }

    public int getStartTime() {
        Integer hour;
        Integer minute;
        Integer day;
        int t = 0;
        String time = this.timeStart;
        if (!time.contains("day")) {
            return 0;
        }
        String days = time.substring(15, time.length() - 1);
        String minutes = time.substring(7, 9);
        String hours = time.substring(4, 6);
        try {
            day = Integer.parseInt(days);
            minute = Integer.parseInt(minutes);
            hour = Integer.parseInt(hours);
        }
        catch (Exception e) {
            System.err.print("Cannot check new day - error parsing time information.");
            System.err.print(e.toString());
            return 0;
        }
        return t += day * 24 * 60 + hour * 60 + minute;
    }

    @Override
    public int compareTo(EpisodeNode o) {
        return this.getStartTime() - o.getStartTime();
    }

    public void recalculateTreeSize(boolean validate) {
        int origSubNodes = this.numberOfSubNodes;
        int origSubNodesWithObjects = this.numberOfSubNodesWithObjects;
        this.numberOfSubNodes = this.children.size();
        this.numberOfSubNodesWithObjects = this.children.size();
        for (ObjectSlot s : this.slots.values()) {
            this.numberOfSubNodesWithObjects += s.getUsedObjects().size();
        }
        for (EpisodeNode e : this.children.values()) {
            e.recalculateTreeSize(validate);
            this.numberOfSubNodes += e.numberOfSubNodes;
            this.numberOfSubNodesWithObjects += e.numberOfSubNodesWithObjects;
        }
        if (validate) {
            assert (origSubNodes == this.numberOfSubNodes);
            assert (origSubNodesWithObjects == this.numberOfSubNodesWithObjects);
        }
    }
}

