/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.episodes;

import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.EpisodeNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectSlot;
import cz.cuni.amis.pogamut.episodic.memory.AffordanceUsed;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.memory.IdGenerator;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaSlot;
import cz.cuni.amis.pogamut.episodic.schemas.SlotContent;
import cz.cuni.amis.pogamut.episodic.visualizer.VisualizationEvent;
import cz.cuni.amis.pogamut.episodic.visualizer.VisualizationEventType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Stack;

public class Episode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private EpisodeNode root = null;
    private Chronobag parentChronobag = null;
    public boolean finished = false;
    public final int idEpisode;
    public final IdGenerator idGen;
    private double copyScore = 0.0;
    private boolean copied = false;
    public boolean deleted = false;
    public ArrayList<Episode> next = new ArrayList();
    public ArrayList<Episode> previous = new ArrayList();
    public final AgentMemory mem;

    public Episode(Chronobag parent) {
        this.parentChronobag = parent;
        this.mem = parent.getMemory();
        this.idGen = parent.idGenerator;
        this.idEpisode = this.idGen.getNewId();
    }

    public Episode(Episode other) {
        this.mem = other.mem;
        this.finished = other.finished;
        this.idGen = other.idGen;
        this.idEpisode = other.idEpisode;
    }

    public boolean addNewNode(String atomicAction, ArrayList<String> trace, ArrayList<AffordanceUsed> affordances) {
        return this.addNewNode(atomicAction, trace, affordances, "");
    }

    public boolean addNewNode(String atomicAction, ArrayList<String> trace, ArrayList<AffordanceUsed> affordances, String time) {
        EpisodeNode node;
        if (this.root == null) {
            boolean updated = this.parentChronobag.getMemory().getDecisionTree().ensureNodes(atomicAction, trace, affordances, this.mem.getIdGenerator());
            if (updated) {
                this.mem.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.DECISION_TREE_UPDATE, this.mem));
            }
            Node associated = this.parentChronobag.getMemory().getDecisionTree().topLevelGoals.get(trace.get(0));
            this.root = new EpisodeNode(trace.get(0), null, this, associated);
            ++this.parentChronobag.numberOfEpisodeNodes;
        }
        if (!(node = this.root).getName().equals(trace.get(0))) {
            throw new RuntimeException("Root node not matching.");
        }
        for (int index = 1; index <= trace.size(); ++index) {
            for (int i = 0; i < affordances.size(); ++i) {
                AffordanceUsed aff = affordances.get(i);
                if (!aff.usedOn.equals(node.getName())) continue;
                node.addSlot(aff.type);
                if (aff.item == null) continue;
                if (!this.parentChronobag.objectNodes.containsKey(aff.item)) {
                    this.parentChronobag.createObjectNode(aff.item);
                }
                node.fillSlot(aff.type, aff.item);
            }
            if (index == trace.size()) break;
            node.addChildNode(trace.get(index), time);
            node = node.getChild(trace.get(index));
        }
        node.addChildNode(atomicAction, time);
        return false;
    }

    public boolean finishNode(String node, ArrayList<String> trace, boolean succeeded) {
        trace.remove(0);
        boolean rv = this.root.finishNode(node, trace, succeeded);
        if (this.root.finished) {
            this.finished = true;
        }
        return rv;
    }

    public Chronobag getParentChronobag() {
        return this.parentChronobag;
    }

    public boolean setParentChronobag(Chronobag c) {
        if (this.parentChronobag != null) {
            return false;
        }
        this.parentChronobag = c;
        return true;
    }

    public EpisodeNode getRoot() {
        return this.root;
    }

    public double episodeSimilarity(Episode other) {
        int intersection = this.root.numberOfCommonSubNodesWithObjects(other.getRoot());
        int max = Math.max(this.root.numberOfSubNodesWithObjects + 1, other.getRoot().numberOfSubNodesWithObjects + 1);
        if (0 > intersection || intersection > max) {
            int i = 0;
            ++i;
        }
        assert (0 <= intersection && intersection <= max);
        return intersection / max;
    }

    public Episode createCopy(Chronobag c) {
        Episode e = new Episode(this);
        e.setParentChronobag(c);
        e.root = this.root.createCopy(null, e);
        this.root.validateNode(this.root);
        return e;
    }

    public boolean setCopied() {
        if (this.copied) {
            return false;
        }
        this.copied = true;
        return true;
    }

    public boolean getCopied() {
        return this.copied;
    }

    public double getCopyScore() {
        if (this.copied) {
            return -1.0;
        }
        return this.copyScore;
    }

    public double calculateCopyScore() {
        if (this.copied) {
            return -1.0;
        }
        int maxAttractiveness = 0;
        double avgAttractiveness = 0.0;
        int nodes = 0;
        LinkedList<EpisodeNode> q = new LinkedList<EpisodeNode>();
        q.add(this.root);
        while (!q.isEmpty()) {
            EpisodeNode n = (EpisodeNode)q.poll();
            if (n.getAssociatedNode() != null) {
                avgAttractiveness += (double)n.getAssociatedNode().getAttractivity();
                if (n.getAssociatedNode().getAttractivity() > maxAttractiveness) {
                    maxAttractiveness = n.getAssociatedNode().getAttractivity();
                }
            }
            ++nodes;
            for (EpisodeNode child : n.getChildrenNodes()) {
                q.add(child);
            }
        }
        this.copyScore = ((double)maxAttractiveness + (avgAttractiveness /= (double)nodes)) / 2.0;
        return this.copyScore;
    }

    public int getIdEpisode() {
        return this.idEpisode;
    }

    public boolean mergeWith(Episode other) {
        int removedNodes = this.root.numberOfSubNodes + 1 + other.root.numberOfSubNodes + 1;
        int removedNodesObjects = this.root.numberOfSubNodesWithObjects + 1 + other.root.numberOfSubNodesWithObjects + 1;
        assert (this.root.validateNode(this.root)) : this.root.getId();
        assert (this.root.validateNode(this.root.children.values())) : this.root.getId();
        assert (this.root.validateNode(other.root)) : this.root.getId();
        assert (this.root.validateNode(other.root.children.values())) : this.root.getId();
        assert (this.root.validateNode(this.root)) : this.root.getId();
        this.root = this.root.mergeWith(other.root);
        assert (this.root.validateNode(this.root)) : this.root.getId();
        assert (this.root.validateNode(this.root.children.values())) : this.root.getId();
        removedNodes -= this.root.numberOfSubNodes + 1;
        removedNodesObjects -= this.root.numberOfSubNodesWithObjects + 1;
        this.previous.addAll(other.previous);
        this.previous.remove(this);
        this.previous.remove(other);
        this.next.addAll(other.next);
        this.next.remove(this);
        this.next.remove(other);
        this.copied = this.copied && other.copied;
        other.deleted = true;
        this.finished = this.finished || other.finished;
        this.parentChronobag.episodesMerged(this, other, removedNodes, removedNodesObjects);
        return false;
    }

    public Episode deriveEpisode() {
        SchemaSlot sSlot;
        assert (this.root.validateNode(this.root)) : this.root.getId();
        assert (this.root.validateNode(this.root.children.values())) : this.root.getId();
        HashSet<EpisodeNode> s = new HashSet<EpisodeNode>();
        s.add(this.root);
        while (!s.isEmpty()) {
            EpisodeNode e = (EpisodeNode)s.iterator().next();
            s.remove(e);
            assert (e.validateNode(e));
            if (e.getParent() != null && e.associatedNode != null && !e.associatedNode.parent.getName().equals(e.getParent().associatedNode.getName())) {
                EpisodeNode newNode = e.deriveNodeTrace();
                s.add(newNode);
                s.removeAll(newNode.getChildrenNodes());
                assert (e.validateNode(newNode));
                e = newNode.getChild(e.getName());
                continue;
            }
            assert (e.validateNode(e));
            for (EpisodeNode n : e.getChildrenNodes()) {
                assert (e.validateNode(n));
                s.add(n);
            }
        }
        HashSet<SchemaEpisodeNode> schemaENodes = new HashSet<SchemaEpisodeNode>();
        HashSet<SlotContent> schemaContents = new HashSet<SlotContent>();
        Stack<EpisodeNode> stack = new Stack<EpisodeNode>();
        EpisodeNode stackNode = this.root;
        while (stackNode != null && stackNode.associatedNode != null) {
            stack.push(stackNode);
            schemaENodes.add(stackNode.associatedNode.getAssociatedNode());
            for (ObjectSlot slot : stackNode.getObjectSlots()) {
                if (slot.getType().equals("Other")) continue;
                sSlot = slot.getParentNode().associatedNode.getAssociatedNode().getSlot(slot.getType());
                for (ObjectNode obj : slot.getUsedObjects()) {
                    schemaContents.add(sSlot.getSlotContent(obj.getName()));
                }
            }
            stackNode = stackNode.getFirstChild().get(this.idEpisode);
        }
        EpisodeNode addedNode = null;
        EpisodeNode previousAddedNode = null;
        while (!stack.isEmpty()) {
            stackNode = (EpisodeNode)stack.peek();
            previousAddedNode = addedNode;
            addedNode = stackNode.deriveChildrenAndSlots(schemaENodes, schemaContents);
            if (addedNode == null || addedNode == previousAddedNode) {
                stack.pop();
                schemaENodes.remove(stackNode.associatedNode.getAssociatedNode());
                for (ObjectSlot slot : stackNode.getObjectSlots()) {
                    if (slot.getType().equals("Other")) continue;
                    sSlot = slot.getParentNode().associatedNode.getAssociatedNode().getSlot(slot.getType());
                    for (ObjectNode obj : slot.getUsedObjects()) {
                        schemaContents.remove(sSlot.getSlotContent(obj.getName()));
                    }
                }
                EpisodeNode successor = stackNode.getSuccessor().get(this.idEpisode);
                if (successor == null || successor.associatedNode == null) continue;
                stack.push(successor);
                schemaENodes.add(successor.associatedNode.getAssociatedNode());
                for (ObjectSlot slot : successor.getObjectSlots()) {
                    if (slot.getType().equals("Other")) continue;
                    sSlot = slot.getParentNode().associatedNode.getAssociatedNode().getSlot(slot.getType());
                    for (ObjectNode obj : slot.getUsedObjects()) {
                        schemaContents.add(sSlot.getSlotContent(obj.getName()));
                    }
                }
                continue;
            }
            if (addedNode.associatedNode == null) continue;
            stack.push(addedNode);
            schemaENodes.add(addedNode.associatedNode.getAssociatedNode());
            for (ObjectSlot slot : addedNode.getObjectSlots()) {
                sSlot = slot.getParentNode().associatedNode.getAssociatedNode().getSlot(slot.getType());
                for (ObjectNode obj : slot.getUsedObjects()) {
                    schemaContents.add(sSlot.getSlotContent(obj.getName()));
                }
            }
        }
        assert (this.root.validateNode(this.root)) : this.root.getId();
        assert (this.root.validateNode(this.root.children.values())) : this.root.getId();
        return this;
    }

    public String toString() {
        String s = "" + this.idEpisode;
        if (this.root != null) {
            s = s + " " + this.root.getName();
        }
        return s;
    }
}

