/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.episodes;

import cz.cuni.amis.pogamut.episodic.episodes.AgeInterval;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.episodes.EpisodeNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectSlot;
import cz.cuni.amis.pogamut.episodic.memory.AffordanceUsed;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.memory.IdGenerator;
import cz.cuni.amis.pogamut.episodic.memory.Parameters;
import cz.cuni.amis.pogamut.episodic.visualizer.VisualizationEvent;
import cz.cuni.amis.pogamut.episodic.visualizer.VisualizationEventType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Chronobag
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final IdGenerator idGenerator;
    private AgentMemory mem;
    public final int id;
    boolean landmark = false;
    int level = 0;
    ArrayList<Episode> finishedEpisodes = new ArrayList();
    HashMap<String, Episode> currentEpisodes = new HashMap();
    private Episode lastEpisode = null;
    private Episode firstEpisode = null;
    private AgeInterval age = new AgeInterval(0, 0);
    private Chronobag older = null;
    Chronobag younger = null;
    Chronobag nextLevel = null;
    public boolean newNodeAdded = false;
    int numberOfEpisodeNodes = 0;
    int numberOfUsedObjects = 0;
    private int maxNumberOfNodes = 0;
    private double score = Parameters.MAX_NODE_SCORE;
    public HashMap<String, ObjectNode> objectNodes = new HashMap();

    public Chronobag(IdGenerator idGen, AgentMemory mem) {
        this.idGenerator = idGen;
        this.mem = mem;
        this.id = this.idGenerator.getNewId();
    }

    public Chronobag(IdGenerator idGen, AgentMemory _mem, Chronobag last) {
        this.idGenerator = idGen;
        this.mem = _mem;
        this.id = this.idGenerator.getNewId();
        this.older = last;
        last.younger = this;
        this.nextLevel = last.nextLevel;
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        String s = "";
        s = s + Integer.valueOf(this.id).toString() + " Age:" + this.age.toString() + newline;
        s = s + "Number of Episode Nodes: " + this.numberOfEpisodeNodes + newline;
        return s;
    }

    public Chronobag getYoungerChronobag() {
        return this.younger;
    }

    public Chronobag getOlderChronobag() {
        return this.older;
    }

    public AgentMemory getMemory() {
        return this.mem;
    }

    public int getNumberOfEpisodeNodes() {
        return this.numberOfEpisodeNodes;
    }

    public Chronobag getMoreAbstractChronobag() {
        if (this.nextLevel == null) {
            return null;
        }
        Chronobag c = this.nextLevel;
        while (c.getAge().getMaxAge() < this.age.getMaxAge()) {
            if ((c = c.getOlderChronobag()) != null) continue;
            return null;
        }
        if (c.getAge().getMinAge() <= this.age.getMinAge() && c.getAge().getMaxAge() >= this.age.getMaxAge()) {
            return c;
        }
        return null;
    }

    public Chronobag createMoreAbstractChronobag() {
        Chronobag res = null;
        if (this.nextLevel == null) {
            res = new Chronobag(this.idGenerator, this.mem);
            res.level = this.level + 1;
            int ageMin = this.age.getMinAge();
            int ageMax = this.age.getMaxAge();
            int diff = Parameters.CHRONOBAG_INTERVAL_LENGHTS[this.level + 1] - Parameters.CHRONOBAG_INTERVAL_LENGHTS[this.level];
            ageMin -= diff / 2;
            ageMax += diff / 2;
            if (diff % 2 == 1) {
                ++ageMax;
            }
            res.age = new AgeInterval(ageMin, ageMax);
            this.mem.registerNewPastChronobag(res);
            Chronobag c = this;
            this.nextLevel = res;
            while (c.getYoungerChronobag() != null) {
                c = c.younger;
                c.nextLevel = res;
            }
            c = this;
            while (c.getOlderChronobag() != null) {
                c = c.older;
                c.nextLevel = res;
            }
            return res;
        }
        Chronobag temp = res = this.nextLevel;
        while (res != null && res.getAge().getMaxAge() < this.age.getMaxAge()) {
            temp = res;
            res = res.getOlderChronobag();
        }
        if (res != null && res.getAge().getMinAge() <= this.age.getMinAge() && res.getAge().getMaxAge() >= this.age.getMaxAge()) {
            return res;
        }
        res = new Chronobag(this.idGenerator, this.mem);
        if (temp.getAge().getMaxAge() < this.age.getMaxAge()) {
            res.younger = temp;
            res.older = temp.older;
            temp.older = res;
            if (res.older != null) {
                res.older.younger = res;
            }
        } else {
            res.older = temp;
            temp.younger = res;
        }
        res.level = this.level + 1;
        int ageMin = this.age.getMinAge();
        int ageMax = this.age.getMaxAge();
        int diff = Parameters.CHRONOBAG_INTERVAL_LENGHTS[this.level + 1] - Parameters.CHRONOBAG_INTERVAL_LENGHTS[this.level];
        ageMin -= diff / 2;
        ageMax += diff / 2;
        if (diff % 2 == 1) {
            ++ageMax;
        }
        res.age = new AgeInterval(ageMin, ageMax);
        this.mem.registerNewPastChronobag(res);
        Chronobag c = this;
        this.nextLevel = this.mem.getChronobagSequenceEnds().get(this.level + 1);
        while (c.getYoungerChronobag() != null) {
            c = c.younger;
            c.nextLevel = this.mem.getChronobagSequenceEnds().get(this.level + 1);
        }
        c = this;
        while (c.getOlderChronobag() != null) {
            c = c.older;
            c.nextLevel = this.mem.getChronobagSequenceEnds().get(this.level + 1);
        }
        res.nextLevel = this.mem.getChronobagSequenceEnds().get(res.level + 1);
        return res;
    }

    public void increaseDay() {
        this.age.increase();
        if (this.age.getMinAge() >= Parameters.LANDMARK_AGE_THRESHOLDS[this.level]) {
            this.landmark = true;
        }
    }

    public AgeInterval getAge() {
        return this.age;
    }

    public double getScore() {
        return this.score;
    }

    public boolean addNewNode(String atomicAction, ArrayList<String> trace, ArrayList<AffordanceUsed> affordances) {
        return this.addNewNode(atomicAction, trace, affordances, "");
    }

    public boolean addNewNode(String atomicAction, ArrayList<String> trace, ArrayList<AffordanceUsed> affordances, String time) {
        if (trace.size() == 0) {
            return false;
        }
        String topLevelGoal = trace.get(0);
        if (!this.currentEpisodes.containsKey(topLevelGoal)) {
            Episode episode = new Episode(this);
            if (this.firstEpisode == null) {
                this.firstEpisode = episode;
            }
            this.currentEpisodes.put(topLevelGoal, episode);
        }
        Episode current = this.currentEpisodes.get(topLevelGoal);
        if (this.lastEpisode == null) {
            this.lastEpisode = current;
        }
        if (current != this.lastEpisode) {
            this.lastEpisode.next.add(current);
            current.previous.add(0, this.lastEpisode);
        }
        this.lastEpisode = current;
        return current.addNewNode(atomicAction, trace, affordances, time);
    }

    public ObjectNode createObjectNode(String item) {
        if (this.objectNodes.containsKey(item)) {
            return this.objectNodes.get(item);
        }
        this.objectNodes.put(item, new ObjectNode(item, this.idGenerator.getNewId()));
        return this.objectNodes.get(item);
    }

    public boolean finishNode(String node, ArrayList<String> trace, boolean succeeded) {
        if (trace.size() == 0) {
            return false;
        }
        String topLevelGoal = trace.get(0);
        if (!this.currentEpisodes.containsKey(topLevelGoal)) {
            return false;
        }
        boolean rv = this.currentEpisodes.get(topLevelGoal).finishNode(node, trace, succeeded);
        if (this.currentEpisodes.get((Object)topLevelGoal).finished) {
            Episode e = this.currentEpisodes.remove(topLevelGoal);
            this.finishedEpisodes.add(e);
            this.uniteEpisode(e);
        }
        return rv;
    }

    public Collection<Episode> getEpisodes() {
        ArrayList<Episode> col = new ArrayList<Episode>();
        col.addAll(this.finishedEpisodes);
        col.addAll(this.currentEpisodes.values());
        return col;
    }

    public Episode getFirstEpisode() {
        return this.firstEpisode;
    }

    public int getLevel() {
        return this.level;
    }

    public double calculateChronobagScore() {
        int attractive = this.numberOfNodesWithAttractivity(Parameters.CHRONOBAG_SCORE_NODE_THRESHOLD);
        int all = this.numberOfEpisodeNodes;
        if (all == 0) {
            this.score = 0.0;
            return 0.0;
        }
        this.score = attractive / all * 100;
        assert (this.score <= 100.0);
        return this.score;
    }

    public boolean copyEpisodeToAbstractChronobag(Episode e) {
        if (e.getParentChronobag() != this) {
            return false;
        }
        if (e.getCopied()) {
            return false;
        }
        Chronobag abs = this.getMoreAbstractChronobag();
        if (abs == null) {
            abs = this.createMoreAbstractChronobag();
        }
        Episode copy = e.createCopy(abs);
        abs.finishedEpisodes.add(copy);
        abs.newNodeAdded = true;
        abs.numberOfEpisodeNodes += copy.getRoot().numberOfSubNodes;
        Episode predecessor = null;
        Episode successor = null;
        for (Episode ep : abs.finishedEpisodes) {
            if (ep.idEpisode < e.idEpisode && (predecessor == null || predecessor.idEpisode < ep.idEpisode)) {
                predecessor = ep;
            }
            if (ep.idEpisode <= e.idEpisode || successor != null && successor.idEpisode <= ep.idEpisode) continue;
            successor = ep;
        }
        if (successor != null) {
            successor.previous.remove(predecessor);
            successor.previous.add(copy);
        }
        if (predecessor != null) {
            predecessor.next.remove(successor);
            predecessor.next.add(copy);
        }
        return true;
    }

    public boolean isLandmark() {
        return this.landmark;
    }

    public void finish() {
        for (Episode e : this.currentEpisodes.values()) {
            this.finishedEpisodes.add(e);
        }
        this.currentEpisodes.clear();
    }

    private int numberOfNodesWithAttractivity(double min) {
        int count = 0;
        LinkedList<EpisodeNode> q = new LinkedList<EpisodeNode>();
        for (Episode e : this.getEpisodes()) {
            q.add(e.getRoot());
        }
        while (!q.isEmpty()) {
            EpisodeNode n = (EpisodeNode)q.poll();
            if (n.getAssociatedNode() == null) continue;
            if ((double)n.getAssociatedNode().getAttractivity() >= min) {
                ++count;
            }
            for (EpisodeNode child : n.getChildrenNodes()) {
                q.add(child);
            }
        }
        return count;
    }

    private double calculateKScore(List<Double> scores) {
        this.calculateChronobagScore();
        int k = this.calculateK(this.age.getMinAge(), this.score);
        if (k >= scores.size()) {
            return 0.0;
        }
        Collections.sort(scores);
        Collections.reverse(scores);
        if (k == 0) {
            return Parameters.MAX_NODE_SCORE;
        }
        return scores.get(--k);
    }

    private int calculateK(int minAge, double chronobagScore) {
        double limit;
        double k = this.maxNumberOfNodes;
        if (k > (double)Parameters.MAX_CHRONOBAG_NODES) {
            k = Parameters.MAX_CHRONOBAG_NODES;
        }
        if ((limit = (double)(Parameters.LANDMARK_AGE_THRESHOLDS[this.level] - 1)) < (double)minAge) {
            limit = minAge;
        }
        if (Parameters.FORGETTING_CURVE_COEFFICIENT > -1.0) {
            double exponent = Parameters.FORGETTING_CURVE_COEFFICIENT;
            k *= Math.pow((limit - (double)minAge) / limit, exponent);
        }
        if (Parameters.FORGETTING_CURVE_COEFFICIENT == -1.0) {
            k *= Math.pow(Math.E, -1 * (this.age.getMinAge() + this.age.getMaxAge()) / 2);
        }
        return (int)Math.round(k += chronobagScore / 2.0);
    }

    public void decideToForgetNodes() {
        EpisodeNode n;
        ArrayList<Double> nodeScores = new ArrayList<Double>();
        LinkedList<EpisodeNode> q = new LinkedList<EpisodeNode>();
        for (Episode e : this.getEpisodes()) {
            q.add(e.getRoot());
        }
        while (!q.isEmpty()) {
            n = (EpisodeNode)q.poll();
            assert (n.validateNode(n)) : n.getId();
            for (ObjectSlot s : n.getObjectSlots()) {
                nodeScores.addAll(s.computeScore());
            }
            nodeScores.add(n.calculateScore());
            for (EpisodeNode child : n.getChildrenNodes()) {
                q.add(child);
            }
        }
        double kScore = this.calculateKScore(nodeScores);
        for (Episode e : this.getEpisodes()) {
            q.add(e.getRoot());
            assert (e.getRoot().validateNode(e.getRoot())) : e.getRoot().getId();
        }
        while (!q.isEmpty()) {
            n = (EpisodeNode)q.poll();
            if (n.consumed) continue;
            Collection<EpisodeNode> pred = n.getPredecessor().values();
            Collection<EpisodeNode> suc = n.getSuccessor().values();
            EpisodeNode par = n.getParent();
            Collection<EpisodeNode> ch = n.getChildrenNodes();
            assert (n.validateNode(n)) : n.getId();
            assert (n.validateNode(par)) : n.getId();
            assert (n.validateNode(ch)) : n.getId();
            assert (n.validateNode(pred)) : n.getId();
            assert (n.validateNode(suc)) : n.getId();
            for (EpisodeNode child : n.getChildrenNodes()) {
                if (q.contains(child)) continue;
                q.add(child);
            }
            HashSet<ObjectSlot> col = new HashSet<ObjectSlot>();
            col.addAll(n.getObjectSlots());
            for (ObjectSlot s : col) {
                s.forgetConnections(kScore);
                if (!s.getUsedObjects().isEmpty()) continue;
                s.deleteSlot();
            }
            assert (n.validateNode(par)) : n.getId();
            assert (n.validateNode(ch)) : n.getId();
            assert (n.validateNode(pred)) : n.getId();
            assert (n.validateNode(suc)) : n.getId();
            boolean deleted = false;
            if (n.getScore() < kScore) {
                n.deleteNode();
                deleted = true;
            }
            if (deleted) continue;
            assert (n.validateNode(par)) : n.getId();
            assert (n.validateNode(ch)) : n.getId();
            assert (n.validateNode(pred)) : n.getId();
            assert (n.validateNode(suc)) : n.getId();
        }
    }

    void episodesMerged(Episode merged, Episode absorbed, int removedNodes, int removedNodesObjects) {
        if (this.currentEpisodes.containsValue(absorbed)) {
            this.currentEpisodes.remove(absorbed.getRoot().getName());
        }
        this.finishedEpisodes.remove(absorbed);
        if (absorbed == this.firstEpisode) {
            this.firstEpisode = merged;
        }
        if (absorbed == this.lastEpisode) {
            this.lastEpisode = merged;
        }
        int temp = this.numberOfEpisodeNodes;
        this.deleteEpisode(absorbed);
        this.numberOfEpisodeNodes = temp;
        this.newNodeAdded = true;
        this.numberOfEpisodeNodes -= removedNodes;
    }

    public void reviewActiveEpisodes(ArrayList<String> list) {
        boolean updated = false;
        for (Map.Entry<String, Episode> entry : this.currentEpisodes.entrySet()) {
            if (list.contains(entry.getKey())) continue;
            Episode e = entry.getValue();
            e.finished = true;
            updated = true;
        }
        if (updated) {
            this.mem.fireVisualizationEvent(new VisualizationEvent(this, VisualizationEventType.REFRESH_PRESENT_CHRONOBAG, this.mem));
        }
    }

    public boolean uniteEpisode(Episode e) {
        for (Episode prev : e.previous) {
            if (e.episodeSimilarity(prev) != 1.0) continue;
            prev.mergeWith(e);
            return true;
        }
        return false;
    }

    public void deleteEpisode(Episode e) {
        Episode e2;
        Iterator<Episode> it;
        int i;
        this.finishedEpisodes.remove(e);
        if (this.currentEpisodes.containsValue(e)) {
            System.err.println("Deleting unfinished episode: " + e);
        }
        ArrayList<Episode> tempNext = new ArrayList<Episode>(e.next);
        Collections.reverse(e.previous);
        if (e == this.firstEpisode && !e.next.isEmpty()) {
            e.next.remove(0);
        }
        block0: for (Episode prev : e.previous) {
            i = 0;
            while (i < prev.next.size()) {
                if (prev.next.get(i) == e) {
                    it = e.next.iterator();
                    if (!it.hasNext()) {
                        prev.next.remove(i);
                        continue;
                    }
                    e2 = it.next();
                    it.remove();
                    if (e2 == prev) {
                        prev.next.remove(i);
                        continue;
                    }
                    prev.next.set(i, e2);
                    continue block0;
                }
                ++i;
            }
        }
        e.next = tempNext;
        if (e != this.lastEpisode || !e.previous.isEmpty()) {
            // empty if block
        }
        block2: for (Episode n : e.next) {
            i = n.previous.size() - 1;
            while (i >= 0) {
                if (n.previous.get(i) == e) {
                    if (n.previous.size() < e.next.size() && e == this.firstEpisode) {
                        n.previous.remove(i);
                        continue block2;
                    }
                    it = e.previous.iterator();
                    if (!it.hasNext()) {
                        n.previous.remove(i);
                        --i;
                        continue;
                    }
                    e2 = it.next();
                    it.remove();
                    if (e2 == n) {
                        n.previous.remove(i);
                        --i;
                        continue;
                    }
                    n.previous.set(i, e2);
                    continue block2;
                }
                --i;
            }
        }
        if (e.getRoot() != null) {
            e.getRoot().fullDelete(true);
        }
    }

    public void deleteChronobag() {
        if (this.younger == null) {
            Chronobag c = this.mem.getChronobagSequenceEnds().get(this.level - 1);
            while (c != null) {
                c.nextLevel = this.older;
                c = c.older;
            }
        }
        if (this.older != null) {
            this.older.younger = this.younger;
        }
        if (this.younger != null) {
            this.younger.older = this.older;
        }
    }

    public int getMaxNumberOfNodes() {
        return this.maxNumberOfNodes;
    }

    public void increaseMaxNumberOfNodes(Chronobag c) {
        assert (c.level == 0);
        assert (c.age.getMinAge() >= this.age.getMinAge());
        assert (c.age.getMaxAge() <= this.age.getMaxAge());
        this.maxNumberOfNodes += c.numberOfEpisodeNodes + c.numberOfUsedObjects;
    }

    public Integer getLastEpisodeId() {
        if (this.lastEpisode == null) {
            return null;
        }
        return this.lastEpisode.getIdEpisode();
    }

    public Episode getEpisode(Integer id) {
        for (Episode e : this.getEpisodes()) {
            if (e.getIdEpisode() != id.intValue()) continue;
            return e;
        }
        return null;
    }
}

