/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.episodes;

import java.io.Serializable;

public class AgeInterval
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int minAge;
    private int maxAge;

    public AgeInterval(int min, int max) {
        if (min > max) {
            throw new RuntimeException("Abnormal AgeInterval boundaries!");
        }
        this.minAge = min;
        this.maxAge = max;
    }

    public int getMinAge() {
        return this.minAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public boolean intersects(AgeInterval b) {
        AgeInterval a = this;
        if (b.minAge <= a.maxAge && b.minAge >= a.minAge) {
            return true;
        }
        return a.minAge <= b.maxAge && a.minAge >= b.minAge;
    }

    public AgeInterval join(AgeInterval other) {
        if (!this.intersects(other)) {
            return null;
        }
        return new AgeInterval(Math.min(this.minAge, other.minAge), Math.max(this.maxAge, other.maxAge));
    }

    public void increase() {
        ++this.minAge;
        ++this.maxAge;
    }

    public String toString() {
        return "[" + this.minAge + ", " + this.maxAge + "]";
    }
}

