/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.decisions;

import cz.cuni.amis.pogamut.episodic.decisions.AffordanceSlot;
import cz.cuni.amis.pogamut.episodic.decisions.INode;
import cz.cuni.amis.pogamut.episodic.decisions.NodeType;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class Node
implements INode,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final int attractivity;
    public Node parent = null;
    private int id = 0;
    private boolean idSet = false;
    private final NodeType type;
    private Map<String, AffordanceSlot> affordances = new HashMap<String, AffordanceSlot>();
    private SchemaEpisodeNode associatedSchemaNode = null;

    public String toString() {
        return Integer.valueOf(this.id).toString() + " " + this.name;
    }

    public boolean setId(int newId) {
        if (this.idSet) {
            return false;
        }
        this.idSet = true;
        this.id = newId;
        return true;
    }

    public int getId() {
        if (!this.idSet) {
            throw new RuntimeException("Node id not set.");
        }
        return this.id;
    }

    public Node(String _name, int _attractivity, NodeType _type) {
        this.name = _name;
        this.type = _type;
        if (_attractivity < 0) {
            _attractivity = 0;
        }
        if (_attractivity > 100) {
            _attractivity = 100;
        }
        this.attractivity = _attractivity;
    }

    public NodeType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void addAffordance(AffordanceSlot affordance) {
        this.affordances.put(affordance.getType(), affordance);
    }

    public boolean setAssociatedSchemaNode(SchemaEpisodeNode node) {
        this.associatedSchemaNode = node;
        return true;
    }

    @Override
    public SchemaEpisodeNode getAssociatedNode() {
        return this.associatedSchemaNode;
    }

    @Override
    public Collection<AffordanceSlot> getAffordances() {
        return this.affordances.values();
    }

    public AffordanceSlot getAffordance(String type) {
        return this.affordances.get(type);
    }

    public int getAttractivity() {
        return this.attractivity;
    }
}

