/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.decisions;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.AtomicAction;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.memory.AffordanceUsed;
import cz.cuni.amis.pogamut.episodic.memory.IdGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class DecisionTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    public HashMap<String, Intention> topLevelGoals = new HashMap();
    public int numberOfAtomicActions = 0;
    public int numberOfNodes = 0;
    public ArrayList<Integer> branchFactor = new ArrayList();

    public ArrayList<Integer> getBranchFactor() {
        for (Intention i : this.topLevelGoals.values()) {
            this.branchFactor.add(i.getPossibleSubTrees());
        }
        return this.branchFactor;
    }

    public ArrayList<Node> getTrace(ArrayList<String> trace) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (trace.isEmpty()) {
            return list;
        }
        Intention i = this.topLevelGoals.get(trace.get(0));
        for (int index = 1; index < trace.size() && i != null; ++index) {
            list.add(i);
            Action a = (Action)i.getSubNode(trace.get(index));
            ++index;
            if (a == null) break;
            list.add(a);
            if (index >= trace.size()) continue;
            i = a.getSubIntention(trace.get(index));
        }
        return list;
    }

    public boolean ensureNodes(String atomicAction, ArrayList<String> trace, ArrayList<AffordanceUsed> affordances, IdGenerator gen) {
        boolean updated = false;
        Intention i = this.topLevelGoals.get(trace.get(0));
        if (i == null) {
            i = new Intention(trace.get(0), 0);
            i.setId(gen.getNewId());
            this.topLevelGoals.put(trace.get(0), i);
        }
        Action a = null;
        for (int index = 1; index < trace.size(); ++index) {
            a = (Action)i.getSubNode(trace.get(index));
            if (a == null) {
                a = new Action(trace.get(index), 0);
                a.setId(gen.getNewId());
                i.addSubNode(a);
                updated = true;
            }
            if (++index == trace.size()) break;
            i = a.getSubIntention(trace.get(index));
            if (i != null) continue;
            i = new Intention(trace.get(index), 0);
            i.setId(gen.getNewId());
            a.addSubNode(i);
            a = null;
            updated = true;
        }
        if (a == null) {
            System.err.println("Incorrect number of nodes in the trace. Atomic action was not added.");
        } else if (a.getAtomicAction(atomicAction) == null) {
            AtomicAction aa = new AtomicAction(atomicAction, 0);
            aa.setId(gen.getNewId());
            a.addAtomicAction(aa);
            updated = true;
        }
        return updated;
    }
}

