/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.decisions;

import cz.cuni.amis.pogamut.episodic.decisions.AtomicAction;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.decisions.NodeType;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class Action
extends Node
implements Serializable {
    private static final long serialVersionUID = 1L;
    int possibleSubTrees = 0;
    private HashMap<String, Intention> subNodes = new HashMap();
    private HashMap<String, AtomicAction> atomicActions = new HashMap();

    public Action(String name, int attractivity) {
        super(name, attractivity, NodeType.ACTION);
    }

    public void addAtomicAction(AtomicAction aa) {
        this.atomicActions.put(aa.getName(), aa);
        aa.parent = this;
    }

    public Collection<AtomicAction> getAtomicActions() {
        return this.atomicActions.values();
    }

    public AtomicAction getAtomicAction(String s) {
        return this.atomicActions.get(s);
    }

    public void addSubNode(Intention intention) {
        this.subNodes.put(intention.getName(), intention);
        intention.parent = this;
    }

    public Collection<Intention> getSubNodes() {
        return this.subNodes.values();
    }

    @Override
    public Node getSubNode(String name) {
        Node node = this.subNodes.get(name);
        if (node == null) {
            node = this.atomicActions.get(name);
        }
        return node;
    }

    public Intention getSubIntention(String name) {
        return this.subNodes.get(name);
    }

    @Override
    public Collection<Node> getAllChildrenNodes() {
        HashSet<Node> col = new HashSet<Node>();
        col.addAll(this.subNodes.values());
        col.addAll(this.atomicActions.values());
        return col;
    }

    public int getPossibleSubTrees() {
        if (this.possibleSubTrees == 0) {
            this.possibleSubTrees = 1;
            for (Intention i : this.getSubNodes()) {
                this.possibleSubTrees *= i.getPossibleSubTrees();
            }
        }
        return this.possibleSubTrees;
    }
}

