package cz.cuni.amis.pogamut.episodic.schemas;

import java.io.Serializable;
import java.util.Collection;

/**
 * Because counters in the schemabag are updated more often than
 * the individual nodes, it is convenient not to redraw all whole
 * schemabag visualization each time they are increased. But still,
 * the detailed information that is invoded when the count number is
 * requested by the user needs to be up to date. Therefore the reference
 * to <code>SchemaMessageCommand</code> class is passed to the
 * visualizer and it is used to receive latest count number each time
 * it is requested by the user via visualizer window.
 *
 * This interface is created so the method <code>getSchemaMessage</code>
 * can be accessed from the visualizer structures while
 * the <code>SchemaMessageCommand</code> class is still in the schema
 * package outside the visualizer structures.
 *
 * @author Michal Cermak
 */
public interface ISchemaMessageCommand {
    /**
     * Once reference to <code>SchemaMesssageCommand</code> is set
     * in visualizer, this method can be used to retrieve up to date
     * count number of currently selected set of schema nodes.
     * @param picked    Collection of IDs of schema episode nodes and
     * schema object nodes that are selected in the visualizer and should
     * form the set of nodes representing wanted counter.
     * @return  The string message to be displayed to the user. If count
     * for selected set of nodes existed in <code>SchemaBag</code> it
     * should contain the count number of this set of nodes.
     */
    public String getSchemaMessage(Collection<Integer> picked);
}
