package cz.cuni.amis.pogamut.episodic.memory;

/**
 *
 * @author Michal Cermak
 */
public class Parameters {

    /**
     * Defines how quickly chronobag capacity decreases.
     * 1 - linear decrease up to landmark age
     * 2 - quadratic decrease up to landmark age
     * ...
     * -1 is a special constant indicating exponential decrease based
     *    on the age of chronobag
     */
    public static double FORGETTING_CURVE_COEFFICIENT = 1;

    /**
     * Input events can contain object of affordance type "perceived".
     * This is for schema experiment only. Generally we do want the agent
     * to remember just what he did and used, not everything he saw.
     */
    public static boolean REMEMBER_SEEN_ITEMS = false;
    /**
     * Disables the creation of multi-day chronobags. Each chronobag will
     * represent single day.
     */
    public static boolean NO_ABSTRACT_CHRONOBAGS = false;
    /**
     * Disables the forgetting of nodes. No memories will be deleted from
     * the chronobags.
     */
    public static boolean NO_FORGETTING = false;
    /**
     * Disables the merging of similar episodes inside chronobag. Each episode
     * will be stand-alone until it is deleted.
     */
    public static boolean NO_EPISODE_MERGING = false;

    public static double MAX_OBJECT_SCORE = 80;
    public static double MIN_OBJECT_SCORE = 20;
    public static double DEFAULT_OBJECT_SCORE = 50;
    public static double MAX_NODE_SCORE = 100;

    public static int MAX_SCHEMA_COMBINATION_COUNT = 3;

    /**
     * 1 means only absolutely derivable objects will be added.
     * 0 means all possible objects will be derived
     */
    public static double PERCENTAGE_TO_DERIVE_OBJECT = 0.5;
    //public static final double PERCENTAGE_TO_DERIVE_SUBNODE = 0.5;
    //not used because all actions are derived and one best intention is derived

    public static double EPISODE_COPY_THRESHOLD_SCORE = -1; //low because attractivity of most nodes is currently 0

    public static int MAX_CHRONOBAG_LEVELS = 4; //0-3

    //indexed by chronobag level
    public static int[] CHRONOBAG_INTERVAL_LENGHTS = {1,3,5,7};

    public static int[] LANDMARK_AGE_THRESHOLDS = {10, 20, 40, 80};

    //minimum attractivity of episode node to increase chronobag score
    public static double CHRONOBAG_SCORE_NODE_THRESHOLD = 50;

    public static int MAX_CHRONOBAG_NODES = 200;

    //tolerance in episode difference for each day when deciding episode merging
    public static double DECIDE_EPISODE_MERGING_COEFFICIENT = 0.03;

    /****************************** NODE SCORE *******************************/

    public static double NODE_SCORE_DERIVABILITY_WEIGHT = 20; // out of 100;
    public static double NODE_SCORE_ACTUAL_COUNT_WEIGHT = 10; // out of 100;
    public static double NODE_SCORE_CREATION_COUNT_WEIGHT = 10; // out of 100;
    public static double NODE_SCORE_BOTTOM_WEIGHT = 10; // out of 100;
    public static double NODE_SCORE_ATTRACTIVITY_WEIGHT = 30; // out of 100;
    public static double NODE_SCORE_AFFORDANCES_WEIGHT = 20; // out of 100;

    /***************************** VISUALIZATION *****************************/

    public static int NODES_X_MARGIN = 50;
    public static int NODES_Y_MARGIN = 50;

    /******************************** RECALL *********************************/

    public static double EPISODE_TREE_RELIANCE = 0.8;

}
