package cz.cuni.amis.pogamut.episodic.memory;

/**
 * This class is used to unite all the information about usage of an item
 * into one object. It is used as a parameter of <code>addNewNode</code>
 * method in various classes. When a new action is executed by an agent,
 * the name of atomic action, trace to this node in decision tree and all
 * objects needed to execute the action are passed to the agent's memory.
 * Information about these items is passed in a list of <code>AffordanceUsed</code>
 * objects (one object for one affordance).
 * <p>
 * Each <code>AffordanceUsed</code> contains name of the node, that affordance
 * slot is attached to, the type of the slot and item and the unique name
 * of the item that satisfied the affordance. The name of the item does not
 * have to be set if there is no item satisfying the affordance yet (e.g. when
 * the agent is just looking for an item to fill the slot).
 *
 * @author Michal Cermak
 */
public class AffordanceUsed {
    /**
     * Name of the node this affordance's slot is attached to.
     */
    public String usedOn;
    /**
     * Type of the affordance and class of the item that can satisfy it.
     */
    public String type;
    /**
     * Name of the item satisfying this affordance. Can be <code>null</code>
     * if the affordance is not satisfied.
     */
    public String item;

    /**
     * Instantiate the class by providing the name of the node the affordance
     * is attached to, the type of affordance and the item satisfying it.
     *
     * @param   _usedOn    Name of the node this affordance's slot is
     * attached to.
     * @param   _type   Type of the affordance and class of the item that
     * can satisfy it.
     * @param   _item   Name of the item satisfying this affordance.
     * Can be <code>null</code> if the affordance is not satisfied.
     */
    public AffordanceUsed(String _usedOn, String _type, String _item) {
        usedOn = _usedOn;
        type = _type;
        item = _item;
    }
}
