package cz.cuni.amis.pogamut.episodic.episodes;

import java.io.Serializable;
import java.util.HashSet;

/**
 * <code>ObjectNode</code> represent a trace of an actual item in episodic memory.
 * Any object that was used by an agent while performing an action is
 * remembered in the memory. In memory there is a list of objects used
 * that is common to all <code>Chronobags</code>s and <code>Episode</code>s.
 * <code>ObjectNode</code>s are linked to <code>ObjectSlot</code>s they were
 * used in. That way it is possible to find out what object was used at specified
 * slot or what slots (or episodes) were filled by specified object.
 *
 * @author Michal Cermak 
 */
public class ObjectNode implements Serializable {
    /**
     * Determines if a de-serialized file is compatible with this class.
     *
     * Maintainers must change this value if and only if the new version
     * of this class is not compatible with old versions. See Sun docs
     * for <a href=http://java.sun.com/products/jdk/1.1/docs/guide
     * /serialization/spec/version.doc.html> details. </a>
     *
     * Not necessary to include in first version of the class, but
     * included here as a reminder of its importance.
     */
    private static final long serialVersionUID = 1L;

    /** Name of the item represented by this object node. No two items should have
     * identical name.
     */
    private final String name;

    /** ID of this node. Used as an ID of vertex representing
     * this node when visualizing Chronobag View.
     */
    private final int id;

    /** Set of all slots, this object was used in. An object can be used in several
     * slots of different type, in several different episodes belonging to different
     * chronobags or in several slot in one episode. For each object here it
     * can be found where the object was used.
     */
    public HashSet<ObjectSlot> usedAt = new HashSet<ObjectSlot>();

    /** Instantiate the class by providing unique object's name, and unique ID that
     * will be used for visualizing purposes.
     *
     * @param   _name   Unique name of the node.
     * @param   _id Unique ID of this node.
     */
    ObjectNode(String _name, int _id) {
        name = _name;
        id = _id;
    }
    
    /** Getter method for the <code>id</code> variable.
     *
     * @return  Returns ID of this node. Used as an ID of vertex representing
     * this node when visualizing Chronobag View.
     */
    public int getId() {
        return id;
    }
    /** Getter method for the <code>name</code> variable.
     *
     * @return Returns name of the item represented by this object node.
     * No two items should have identical name.
     */
    public String getName() {
        return name;
    }
}
