package cz.cuni.amis.pogamut.episodic.decisions;

import java.util.ArrayList;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import java.util.Collection;

/**
 * An interface for the <code>Node</code> class. See the description
 * of <code>Node</code> class for more information.
 *
 * @author Michal Cermak
 * @see Node
 */
public interface INode {
    /**
     * Returns a reference to equivalent node in schemabag once
     * the equivalent node is created there. SchemaNodes can be used to
     * create average episodes or count number of experienced of an episode.
     * Returns null of the associated node does not exist yet.
     * @see SchemaEpisodeNode
     */
    public SchemaEpisodeNode getAssociatedNode();

    /**
     *Returns a list of affordance slots attached to this node.
     * In order to perform an action or satisfy a goal, all its slots
     * have to be filled first. Once the slot is filled, its equivalent
     * in memory of experienced episode will be linked with the object
     * that satisfied the slot.
     */
    public Collection<AffordanceSlot> getAffordances();

    /**
     * For <code>Intention</code> node type this method returns one
     * specified <code>Action</code> node that is direct subnode of this node.
     * <p>
     * For <code>Action</code> node type it returns either one specified
     * <code>Intention</code> node that is direct subnode of this node or
     * specified <code>AtomicAction</code> node.
     * <p>
     * For <code>AtomicAction</code> node type this method returns null.
     * @param name  Name of the node to be returned.
     */
    public INode getSubNode(String name);

    /**
     * For <code>Intention</code> node type this method returns <code>Action</code>
     * nodes that are direct subnodes of this node.
     * <p>
     * For <code>Action</code> node type it returns either  <code>Intention</code>
     * nodes that are direct subnodes of this node and <code>AtomicAction</code> nodes.
     * <p>
     * For <code>AtomicAction</code> node type this method returns null.
     */
    public Collection<Node> getAllChildrenNodes();
}
