package cz.cuni.amis.pogamut.episodic.decisions;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

/**
 * <code>AtomicAction</code> is a type node node that represents an execution
 * of an atomic action by the agent. An atomic action does not have any more
 * subnodes. It is always attached the <code>Action</code> node and it is
 * executed when performing the parent action.
 * <p>
 * Atomic action is always a leaf of a decision tree and mirrors similar
 * structure in the pogamut end project, where decisions are executed. Each time
 * an agent executes an atomic action, this action and trace to it in
 * the decision tree is sent to agent's memory module and its creates new
 * nodes in the given episode tree. The <code>EpisodeNode</code> representing
 * atomic action is always associated with the equivalent <code>AtomicAction</code>
 * node in the decision tree. Usually more episode nodes will be associated
 * with one decision node.
 *
 * @author Michal Cermak
 */
public class AtomicAction extends Node implements Serializable {
    /**
     * Determines if a de-serialized file is compatible with this class.
     *
     * Maintainers must change this value if and only if the new version
     * of this class is not compatible with old versions. See Sun docs
     * for <a href=http://java.sun.com/products/jdk/1.1/docs/guide
     * /serialization/spec/version.doc.html> details. </a>
     *
     * Not necessary to include in first version of the class, but
     * included here as a reminder of its importance.
     */
    private static final long serialVersionUID = 1L;

    /**
     * Instantiate the class by providing its name.
     * <p>
     * There can be several atomic actions with identical name in
     * the decistion tree, but no two atomic actions that are attached
     * to one parent node can share the same name.
     *
     * @param name  The describing the atomic action.
     */
    public AtomicAction(String name, int attractivity) {
        super(name, attractivity, NodeType.ATOMIC_ACTION);
    }

    /**
     * Since <code>AtomicAction</code> will always be a leaf in the decision
     * tree, it will have no sub-nodes. Therefore this method always returns
     * null. It has to be implemented though, because <code>AtomicAction</code>
     * needs to implement this method of the <code>INode</code> interface.
     *
     * @param name  The name of the wanted subnode.
     * @return  Returns <code>null</code>.
     */
    public Node getSubNode(String name) {
        return null;
    }

    /**
     * Since <code>AtomicAction</code> will always be a leaf in the decision
     * tree, it will have no sub-nodes. Therefore this method always returns
     * empty collection. It has to be implemented though, because <code>AtomicAction</code>
     * needs to implement this method of the <code>INode</code> interface.
     *
     * @return  Returns empty collection.
     */
    public Collection<Node> getAllChildrenNodes() {
        Collection<Node> col = new HashSet<Node>();
        return col;
    }
}
