/*
 * Decompiled with CFR 0.152.
 */
package JSHOP2;

import JSHOP2.InternalAxiom;
import JSHOP2.InternalMethod;
import JSHOP2.InternalOperator;
import JSHOP2.JSHOP2Lexer;
import JSHOP2.JSHOP2Parser;
import JSHOP2.Predicate;
import JSHOP2.TaskList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public class InternalDomain {
    private int planNo;
    private Vector axioms;
    private Vector calcs;
    private Vector compoundTasks;
    private Vector constants;
    private int constantsSize;
    static final String endl = System.getProperty("line.separator");
    private Vector methods;
    private String name;
    private String packageName;
    private Vector operators;
    private Map<ComparatorSignature, Integer> numRegisteredComparators;
    private JSHOP2Parser parser;
    private Vector primitiveTasks;
    private String probName;
    private File inputDirectory;
    private File outputDirectory;
    private File txtOutputDirectory;
    private boolean generateTxt = true;

    public InternalDomain(File fin, int planNoIn) throws IOException {
        this.planNo = planNoIn;
        this.axioms = new Vector();
        this.calcs = new Vector();
        this.compoundTasks = new Vector();
        this.constants = new Vector();
        this.methods = new Vector();
        this.operators = new Vector();
        this.numRegisteredComparators = new HashMap<ComparatorSignature, Integer>();
        JSHOP2Lexer lexer = new JSHOP2Lexer(new FileInputStream(fin));
        this.parser = new JSHOP2Parser(lexer);
        this.parser.initialize(lexer, this);
        this.primitiveTasks = new Vector();
    }

    public File getInputDirectory() {
        return this.inputDirectory;
    }

    public void setInputDirectory(File inputDirectory) {
        this.inputDirectory = inputDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getTxtOutputDirectory() {
        return this.txtOutputDirectory;
    }

    public void setTxtOutputDirectory(File txtOutputDirectory) {
        this.txtOutputDirectory = txtOutputDirectory;
    }

    public boolean isGenerateTxt() {
        return this.generateTxt;
    }

    public void setGenerateTxt(boolean generateTxt) {
        this.generateTxt = generateTxt;
    }

    public void addAxiom(InternalAxiom axiom) {
        this.axioms.add(axiom);
    }

    public int addCompoundTask(String s) {
        int index = this.compoundTasks.indexOf(s);
        if (index == -1) {
            this.compoundTasks.add(s);
            return this.compoundTasks.size() - 1;
        }
        return index;
    }

    public int addConstant(String s) {
        int index = this.constants.indexOf(s);
        if (index == -1) {
            this.constants.add(s);
            return this.constants.size() - 1;
        }
        return index;
    }

    public String memberNameFromUserFunctionName(String func) {
        return "calculate" + func.substring(0, 1).toUpperCase() + func.substring(1);
    }

    public void addCalc(String what) {
        if (!this.calcs.contains(what)) {
            this.calcs.add(what);
        }
    }

    public void addMethod(InternalMethod method) {
        this.methods.add(method);
    }

    public void addOperator(InternalOperator op) {
        this.operators.add(op);
    }

    public int addPrimitiveTask(String s) {
        int index = this.primitiveTasks.indexOf(s);
        if (index == -1) {
            this.primitiveTasks.add(s);
            return this.primitiveTasks.size() - 1;
        }
        return index;
    }

    public String addComparatorInstance(String comparatorName, int varIndex) {
        ComparatorSignature comparatorSignature = new ComparatorSignature(comparatorName, varIndex);
        int previousComparatorCount = this.numRegisteredComparators.containsKey(comparatorSignature) ? this.numRegisteredComparators.get(comparatorSignature) : 0;
        this.numRegisteredComparators.put(comparatorSignature, previousComparatorCount + 1);
        return this.getComparatorFieldName(comparatorSignature, previousComparatorCount);
    }

    public void close(int varsMaxSize) throws IOException {
        int i;
        int id;
        String imp;
        String s = "";
        if (this.packageName != null && !this.packageName.isEmpty()) {
            s = s + "package " + this.packageName + ";" + endl + endl;
        }
        s = s + "import JSHOP2.*;" + endl;
        s = s + "import java.util.Comparator;" + endl + endl;
        s = s + "public class " + this.name + " extends Domain" + endl + "{" + endl;
        for (int i2 = 0; i2 < this.calcs.size(); ++i2) {
            imp = (String)this.calcs.get(i2);
            s = s + "\tprotected final Calculate " + this.memberNameFromUserFunctionName(imp) + ";" + endl;
        }
        s = s + endl;
        s = s + "\tprivate JSHOP2 context;" + endl + endl;
        s = s + "\tpublic static final int NUM_CONSTANTS = " + this.constants.size() + ";" + endl;
        s = s + "\tpublic static final int NUM_METHODS = " + this.compoundTasks.size() + ";" + endl;
        s = s + "\tpublic static final int NUM_PRIMITIVES = " + this.primitiveTasks.size() + ";" + endl;
        s = s + this.vectorToConstantDefinition(this.constants, "CONST");
        s = s + this.vectorToConstantDefinition(this.compoundTasks, "METHOD");
        s = s + this.vectorToConstantDefinition(this.primitiveTasks, "PRIMITIVE");
        for (ComparatorSignature comparatorSignature : this.numRegisteredComparators.keySet()) {
            int numComparators = this.numRegisteredComparators.get(comparatorSignature);
            for (id = 0; id < numComparators; ++id) {
                s = s + "\tpublic Comparator " + this.getComparatorFieldName(comparatorSignature, id) + ";" + endl;
            }
        }
        s = s + "\tpublic " + this.name + "(JSHOP2 context)" + endl + "\t{" + endl;
        s = s + "\t\tthis(context, java.util.Collections.EMPTY_MAP, java.util.Collections.EMPTY_MAP);" + endl;
        s = s + "\t}" + endl + endl;
        s = s + "\tpublic " + this.name + "(JSHOP2 context, java.util.Map<String, Calculate> userFunctionImplementations, java.util.Map<String, Comparator<Term>> userComparatorImplementations)" + endl + "\t{" + endl;
        s = s + "\t\tthis.context = context;" + endl + endl;
        s = s + "\t\tcontext.initializeVars(" + varsMaxSize + ");" + endl;
        s = s + "\t\tcontext.initializeConstants(NUM_CONSTANTS);" + endl;
        for (int i3 = 0; i3 < this.calcs.size(); ++i3) {
            imp = (String)this.calcs.get(i3);
            String memberName = this.memberNameFromUserFunctionName(imp);
            s = s + "\t\t" + memberName + " = getFunctionImplementation(\"" + imp + "\", userFunctionImplementations);" + endl;
        }
        s = s + endl;
        s = s + this.vectorToCode(this.constants, "constants");
        s = s + this.vectorToCode(this.compoundTasks, "compoundTasks");
        s = s + this.vectorToCode(this.primitiveTasks, "primitiveTasks");
        for (ComparatorSignature comparatorSignature : this.numRegisteredComparators.keySet()) {
            int numComparators = this.numRegisteredComparators.get(comparatorSignature);
            for (id = 0; id < numComparators; ++id) {
                s = s + "\t\t" + this.getComparatorFieldName(comparatorSignature, id) + " = createComparatorImplementation(\"" + comparatorSignature.getComparatorName() + "\", " + comparatorSignature.getVarIndex() + ", userComparatorImplementations);" + endl;
            }
        }
        s = s + "\t\tmethods = new Method[" + this.compoundTasks.size() + "][];" + endl + endl;
        for (i = 0; i < this.compoundTasks.size(); ++i) {
            int j = 0;
            for (InternalMethod m : this.methods) {
                if (m.getHead().getHead() != i) continue;
                ++j;
            }
            s = s + "\t\tmethods[" + i + "] = new Method[" + j + "];" + endl;
            j = 0;
            for (InternalMethod m : this.methods) {
                if (m.getHead().getHead() != i) continue;
                s = s + "\t\tmethods[" + i + "][" + j++ + "] = new " + m.getClassName() + "();" + endl;
            }
            s = s + endl;
        }
        s = s + endl + "\t\tops = new Operator[" + this.primitiveTasks.size() + "][];" + endl + endl;
        for (i = 0; i < this.primitiveTasks.size(); ++i) {
            int j = 0;
            for (InternalOperator o : this.operators) {
                if (o.getHead().getHead() != i) continue;
                ++j;
            }
            s = s + "\t\tops[" + i + "] = new Operator[" + j + "];" + endl;
            j = 0;
            for (InternalOperator o : this.operators) {
                if (o.getHead().getHead() != i) continue;
                s = s + "\t\tops[" + i + "][" + j++ + "] = new " + o.getClassName() + "();" + endl;
            }
            s = s + endl;
        }
        s = s + "\t\taxioms = new Axiom[" + this.constants.size() + "][];" + endl + endl;
        for (i = 0; i < this.constants.size(); ++i) {
            int j = 0;
            for (InternalAxiom a : this.axioms) {
                if (a.getHead().getHead() != i) continue;
                ++j;
            }
            s = s + "\t\taxioms[" + i + "] = new Axiom[" + j + "];" + endl;
            j = 0;
            for (InternalAxiom a : this.axioms) {
                if (a.getHead().getHead() != i) continue;
                s = s + "\t\taxioms[" + i + "][" + j++ + "] = new Axiom" + a.getCnt() + "();" + endl;
            }
            s = s + endl;
        }
        s = s + "\t}" + endl;
        for (i = 0; i < this.operators.size(); ++i) {
            s = s + ((InternalOperator)this.operators.get(i)).toCode();
        }
        for (i = 0; i < this.methods.size(); ++i) {
            s = s + ((InternalMethod)this.methods.get(i)).toCode();
        }
        for (i = 0; i < this.axioms.size(); ++i) {
            s = s + ((InternalAxiom)this.axioms.get(i)).toCode();
        }
        s = s + endl + "}";
        String fullFileName = this.packageName == null ? this.name : this.packageName.replace('.', File.separatorChar) + File.separatorChar + this.name;
        File javaOutputFile = this.outputDirectory != null ? new File(this.outputDirectory, fullFileName + ".java") : new File(fullFileName + ".java");
        javaOutputFile.getParentFile().mkdirs();
        BufferedWriter dest = new BufferedWriter(new FileWriter(javaOutputFile));
        dest.write(s, 0, s.length());
        dest.close();
        if (this.generateTxt) {
            File txtOutputFile = this.txtOutputDirectory != null ? new File(this.txtOutputDirectory, fullFileName + ".txt") : (this.outputDirectory != null ? new File(this.outputDirectory, fullFileName + ".txt") : new File(fullFileName + ".txt"));
            txtOutputFile.getParentFile().mkdirs();
            dest = new BufferedWriter(new FileWriter(txtOutputFile));
            this.dumpStringArray(dest, this.constants);
            this.dumpStringArray(dest, this.compoundTasks);
            this.dumpStringArray(dest, this.primitiveTasks);
            dest.close();
        }
    }

    public void commandInitialize() throws IOException {
        BufferedReader src = new BufferedReader(new FileReader(this.name + ".txt"));
        this.constantsSize = this.readStringArray(src, this.constants);
        this.readStringArray(src, this.compoundTasks);
        this.readStringArray(src, this.primitiveTasks);
        src.close();
    }

    public void commandToCode(LinkedList states, LinkedList taskLists) throws IOException {
        String s = "import JSHOP2.*;" + endl + endl;
        s = s + "public class " + this.probName + endl + "{" + endl;
        s = s + "\tprivate static String[] defineConstants()" + endl + "\t{" + endl;
        s = s + "\t\tString[] problemConstants = new String[" + (this.constants.size() - this.constantsSize) + "];" + endl + endl;
        for (int i = this.constantsSize; i < this.constants.size(); ++i) {
            s = s + "\t\tproblemConstants[" + (i - this.constantsSize) + "] = \"" + (String)this.constants.get(i) + "\";" + endl;
        }
        s = s + endl + "\t\treturn problemConstants;" + endl + "\t}" + endl + endl;
        Iterator e = states.iterator();
        int problemIdx = 0;
        while (e.hasNext()) {
            s = s + "\tprivate static void createState" + problemIdx++ + "(State s)" + "\t{" + endl;
            Vector state = (Vector)e.next();
            for (int i = 0; i < state.size(); ++i) {
                Predicate p = (Predicate)state.get(i);
                if (p.getHead() >= this.constantsSize) continue;
                s = s + "\t\ts.add(" + p.toCode() + ");" + endl;
            }
            s = s + "\t}" + endl + endl;
        }
        s = s + "\tpublic static void main(String[] args) throws InterruptedException" + endl + "\t{" + endl;
        s = s + "\t\tDomain d = new " + this.name + "();" + endl + endl;
        s = s + "\t\tJSHOP2 context = new JSHOP2();" + endl + endl;
        s = s + "\t\td.setProblemConstants(defineConstants());" + endl + endl;
        s = s + "\t\tState s = new State(" + this.constantsSize + ", d.getAxioms());" + endl;
        s = s + endl + "\t\tjshop.initialize(context, " + this.constants.size() + ");" + endl;
        s = s + "\t\tjshop.setState(s);" + endl + endl;
        s = s + "\t\tTaskList tl;" + endl + "\t\tThread thread;" + endl + endl;
        e = taskLists.iterator();
        problemIdx = 0;
        while (e.hasNext()) {
            if (problemIdx != 0) {
                s = s + endl + "\t\ts.clear();" + endl;
            }
            s = s + "\t\tcreateState" + problemIdx + "(s);" + endl;
            TaskList tl = (TaskList)e.next();
            s = s + endl + tl.getInitCode("tl") + endl;
            s = s + "\t\tthread = new SolverThread(context, tl, " + this.planNo + ");" + endl;
            s = s + "\t\tthread.start();" + endl;
            s = s + "\t\twhile (thread.isAlive())" + endl + "\t\t\tThread.sleep(500);" + endl;
            ++problemIdx;
        }
        s = s + "\t}" + endl + "}";
        BufferedWriter dest = new BufferedWriter(new FileWriter(this.probName + ".java"));
        dest.write(s, 0, s.length());
        dest.close();
    }

    public void dumpStringArray(BufferedWriter dest, Vector list) throws IOException {
        String buff = list.size() + endl;
        dest.write(buff, 0, buff.length());
        for (int i = 0; i < list.size(); ++i) {
            buff = list.get(i) + endl;
            dest.write(buff, 0, buff.length());
        }
    }

    public int getAxiomNo() {
        return this.axioms.size();
    }

    public Vector getCompoundTasks() {
        return this.compoundTasks;
    }

    public Vector getConstants() {
        return this.constants;
    }

    public int getMethodNo() {
        return this.methods.size();
    }

    public String getName() {
        return this.name;
    }

    public Vector getPrimitiveTasks() {
        return this.primitiveTasks;
    }

    public static void main(String[] args) throws Exception {
        int planNo = -1;
        boolean error = false;
        String errorText = null;
        boolean isDomain = true;
        boolean generateTxt = true;
        File outputDirectory = null;
        File inputDirectory = null;
        File txtOutputDirectory = null;
        File inputFile = null;
        String packageName = null;
        if (args.length == 0) {
            error = true;
        } else {
            String inputFileName;
            int endOfDirs;
            for (int argIndex = 0; argIndex < args.length - 1; ++argIndex) {
                String arg = args[argIndex];
                if (arg.startsWith("-r")) {
                    if (arg.equals("-r")) {
                        planNo = 1;
                    } else if (arg.equals("-ra")) {
                        planNo = Integer.MAX_VALUE;
                    } else {
                        try {
                            planNo = Integer.parseInt(arg.substring(2));
                        }
                        catch (NumberFormatException e) {
                            error = true;
                            errorText = "Invalid plan count";
                            break;
                        }
                    }
                    isDomain = false;
                    continue;
                }
                if (arg.equals("-o") || arg.equals("--output-dir")) {
                    if (argIndex >= args.length - 2) {
                        errorText = "-o or --output-dir must be followed by a directory name";
                        error = true;
                        break;
                    }
                    outputDirectory = new File(args[++argIndex]);
                    continue;
                }
                if (arg.equals("-i") || arg.equals("--input-dir")) {
                    if (argIndex >= args.length - 2) {
                        errorText = "-i or --input-dir must be followed by a directory name";
                        error = true;
                        break;
                    }
                    inputDirectory = new File(args[++argIndex]);
                    continue;
                }
                if (arg.equals("-t") || arg.equals("--tct-output-dir")) {
                    if (argIndex >= args.length - 2) {
                        errorText = "-t or --txtoutput-dir must be followed by a directory name";
                        error = true;
                        break;
                    }
                    txtOutputDirectory = new File(args[++argIndex]);
                    continue;
                }
                if (arg.equals("--no-txt")) {
                    generateTxt = false;
                    continue;
                }
                error = true;
                errorText = "Unrecognized argument " + arg;
                break;
            }
            if ((endOfDirs = (inputFileName = args[args.length - 1].replace('\\', File.separatorChar).replace('/', File.separatorChar)).lastIndexOf(File.separatorChar)) > 0) {
                packageName = inputFileName.substring(0, endOfDirs).replace(File.separatorChar, '.');
            }
            inputFile = inputDirectory == null ? new File(inputFileName) : new File(inputDirectory, inputFileName);
        }
        if (error) {
            if (errorText != null) {
                System.err.println(errorText);
            }
            System.err.println("usage: java InternalDomain [-r|-ra|-rSomePositiveInteger] [-i|--input-dir INPUT_DIRECTORY] \n[-o|--output-dir OUTPUT_DIRECTORY] [-t|--txt-output-dir OUTPUT_DIRECTORY_FOR_TXT_FILES] [--no-txt] input");
            System.exit(1);
        }
        InternalDomain internalDomain = new InternalDomain(inputFile, planNo);
        internalDomain.setOutputDirectory(outputDirectory);
        internalDomain.setInputDirectory(inputDirectory);
        internalDomain.setTxtOutputDirectory(txtOutputDirectory);
        internalDomain.setGenerateTxt(generateTxt);
        internalDomain.setPackageName(packageName);
        if (!isDomain) {
            internalDomain.parser.command();
        } else {
            internalDomain.parser.domain();
        }
    }

    public int readStringArray(BufferedReader src, Vector list) throws IOException {
        String buff = src.readLine();
        int j = Integer.valueOf(buff);
        for (int i = 0; i < j; ++i) {
            buff = src.readLine();
            list.add(buff);
        }
        return j;
    }

    public void setName(String nameIn) {
        this.name = nameIn;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setProbName(String probNameIn) {
        this.probName = probNameIn;
    }

    public String vectorToCode(Vector list, String name) {
        String retVal = "\t\t" + name + " = new String[" + list.size() + "];" + endl;
        for (int i = 0; i < list.size(); ++i) {
            retVal = retVal + "\t\t" + name + "[" + i + "] = \"" + list.get(i) + "\";" + endl;
        }
        return retVal + endl;
    }

    private String translateConstantNameToJavaConstantIndetifier(String constantName) {
        return constantName.replace("!", "").toUpperCase();
    }

    private String getComparatorFieldName(ComparatorSignature signature, int id) {
        return "comparator_" + signature.getComparatorName() + "_var" + signature.varIndex + "_" + id;
    }

    public String vectorToConstantDefinition(Vector list, String prefix) {
        StringBuilder retVal = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            retVal.append("\tpublic static final int ").append(prefix).append("_").append(this.translateConstantNameToJavaConstantIndetifier((String)list.get(i))).append(" = ").append(i).append(";").append(endl);
        }
        return retVal.append(endl).toString();
    }

    private static class ComparatorSignature {
        private String comparatorName;
        private int varIndex;

        public ComparatorSignature(String comparatorName, int varIndex) {
            this.comparatorName = comparatorName;
            this.varIndex = varIndex;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComparatorSignature other = (ComparatorSignature)obj;
            if (this.comparatorName == null ? other.comparatorName != null : !this.comparatorName.equals(other.comparatorName)) {
                return false;
            }
            return this.varIndex == other.varIndex;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + (this.comparatorName != null ? this.comparatorName.hashCode() : 0);
            hash = 59 * hash + this.varIndex;
            return hash;
        }

        public String getComparatorName() {
            return this.comparatorName;
        }

        public int getVarIndex() {
            return this.varIndex;
        }
    }
}

