/*
 * Decompiled with CFR 0.152.
 */
package JSHOP2;

import JSHOP2.Axiom;
import JSHOP2.Calculate;
import JSHOP2.JSHOPException;
import JSHOP2.Method;
import JSHOP2.Operator;
import JSHOP2.Term;
import JSHOP2.TermIndexComparator;
import java.util.Comparator;
import java.util.Map;

public abstract class Domain {
    protected Axiom[][] axioms;
    protected String[] compoundTasks;
    protected String[] constants;
    protected Method[][] methods;
    protected Operator[][] ops;
    protected String[] primitiveTasks;
    protected String[] problemConstants;

    public Axiom[][] getAxioms() {
        return this.axioms;
    }

    public String getConstant(int idx) {
        if (idx < this.constants.length) {
            return this.constants[idx];
        }
        return this.problemConstants[idx - this.constants.length];
    }

    public int getDomainConstantCount() {
        return this.constants.length;
    }

    public String getDomainConstant(int idx) {
        return this.constants[idx];
    }

    public String[] getPrimitiveTasks() {
        return this.primitiveTasks;
    }

    public String[] getCompoundTasks() {
        return this.compoundTasks;
    }

    public void setProblemConstants(String[] inp) {
        this.problemConstants = inp;
    }

    protected Calculate getFunctionImplementation(String functionName, Map<String, Calculate> userFunctionImplementations) {
        if (userFunctionImplementations.containsKey(functionName)) {
            return userFunctionImplementations.get(functionName);
        }
        try {
            Class<?> calculateClass = Class.forName(functionName);
            Calculate implementation = (Calculate)calculateClass.newInstance();
            return implementation;
        }
        catch (Exception ex) {
            throw new JSHOPException("No implementation supplied for function " + functionName + " and class of this name cannot be instantiated.", ex);
        }
    }

    protected Comparator createComparatorImplementation(String comparatorName, int varIndex, Map<String, Comparator<Term>> userComparatorImplementations) {
        if (userComparatorImplementations.containsKey(comparatorName)) {
            return new TermIndexComparator(userComparatorImplementations.get(comparatorName), varIndex);
        }
        try {
            Class<?> comparatorClass = Class.forName(comparatorName);
            return (Comparator)comparatorClass.getConstructor(Integer.class).newInstance(varIndex);
        }
        catch (Exception ex) {
            throw new JSHOPException("Could not instantiate class for compartor " + comparatorName + ". Make sure the class has a single int-arg constructor.", ex);
        }
    }
}

