/*
 * Decompiled with CFR 0.152.
 */
package JSHOP2;

import JSHOP2.Axiom;
import JSHOP2.Domain;
import JSHOP2.JSHOP2;
import JSHOP2.MyIterator;
import JSHOP2.NumberedPredicate;
import JSHOP2.Predicate;
import JSHOP2.Term;
import java.util.Iterator;
import java.util.Vector;

public class State {
    private Vector[] atoms;
    private Axiom[][] axioms;
    private Vector[] protections;

    public State(Domain d) {
        this(d.getAxioms().length, d.getAxioms());
    }

    public State(int size, Axiom[][] axiomsIn) {
        this.atoms = new Vector[size];
        this.protections = new Vector[size];
        for (int i = 0; i < size; ++i) {
            this.atoms[i] = new Vector();
            this.protections[i] = new Vector();
        }
        this.axioms = axiomsIn;
    }

    public State(State original) {
        int i;
        this.atoms = new Vector[original.atoms.length];
        for (i = 0; i < original.atoms.length; ++i) {
            this.atoms[i] = new Vector(original.atoms[i]);
        }
        this.protections = new Vector[original.protections.length];
        for (i = 0; i < original.protections.length; ++i) {
            this.protections[i] = new Vector(original.protections[i]);
        }
        this.axioms = original.axioms;
    }

    public boolean add(Predicate p) {
        for (Term t : this.atoms[p.getHead()]) {
            if (!p.equals(t)) continue;
            return false;
        }
        this.atoms[p.getHead()].add(p.getParam());
        return true;
    }

    public boolean addProtection(Predicate p) {
        for (NumberedPredicate np : this.protections[p.getHead()]) {
            if (!p.equals(np.getParam())) continue;
            np.inc();
            return true;
        }
        this.protections[p.getHead()].add(new NumberedPredicate(p));
        return true;
    }

    public void clear() {
        for (int i = 0; i < this.atoms.length; ++i) {
            this.atoms[i].clear();
            this.protections[i].clear();
        }
    }

    public int del(Predicate p) {
        Vector vec = this.atoms[p.getHead()];
        for (int i = 0; i < vec.size(); ++i) {
            Term t = (Term)vec.get(i);
            if (!p.equals(t)) continue;
            vec.remove(i);
            return i;
        }
        return -1;
    }

    public boolean delProtection(Predicate p) {
        Iterator e = this.protections[p.getHead()].iterator();
        while (e.hasNext()) {
            NumberedPredicate np = (NumberedPredicate)e.next();
            if (!p.equals(np.getParam())) continue;
            if (!np.dec()) {
                e.remove();
            }
            return true;
        }
        return false;
    }

    public boolean isProtected(Predicate p) {
        for (NumberedPredicate np : this.protections[p.getHead()]) {
            if (!p.equals(np.getParam())) continue;
            return true;
        }
        return false;
    }

    public MyIterator iterator(int head) {
        return new MyIterator(this.atoms[head]);
    }

    public Term[] nextBinding(Predicate p, MyIterator me) {
        Term[] retVal;
        if (me.whichAxiom == -1) {
            while (me.index < me.vec.size()) {
                Term t;
                if ((retVal = p.findUnifier(t = (Term)me.vec.get(me.index++))) == null) continue;
                return retVal;
            }
            me.whichAxiom = 0;
        }
        while (true) {
            if (me.ax == null) {
                if (me.whichAxiom == this.axioms[p.getHead()].length) {
                    return null;
                }
                me.ax = this.axioms[p.getHead()][me.whichAxiom++];
                me.binding = me.ax.unify(p);
                if (me.binding == null) {
                    me.ax = null;
                    continue;
                }
                me.index = 0;
                me.found = false;
                continue;
            }
            while (me.index < me.ax.getBranchSize()) {
                Term[] nextB;
                if (me.pre == null) {
                    me.pre = me.ax.getIterator(me.binding, me.index);
                }
                while ((nextB = me.pre.nextBinding()) != null) {
                    Term.merge(nextB, me.binding);
                    Predicate groundAxiomHead = me.ax.getHead().applySubstitution(nextB);
                    retVal = p.findUnifier(groundAxiomHead.getParam());
                    if (retVal == null) continue;
                    me.found = true;
                    return retVal;
                }
                me.pre = null;
                if (me.found) break;
                ++me.index;
            }
            me.ax = null;
        }
    }

    public void print() {
        for (int i = 0; i < this.atoms.length; ++i) {
            for (Term t : this.atoms[i]) {
                new Predicate(i, 0, t).print();
            }
            System.out.println();
        }
        System.out.println("------");
    }

    public void undo(Vector[] delAdd) {
        Iterator e = delAdd[1].iterator();
        while (e.hasNext()) {
            this.del((Predicate)e.next());
        }
        for (int i = delAdd[0].size() - 1; i >= 0; --i) {
            NumberedPredicate np = (NumberedPredicate)delAdd[0].get(i);
            this.atoms[np.getHead()].add(np.getNumber(), np.getParam());
        }
        e = delAdd[3].iterator();
        while (e.hasNext()) {
            this.delProtection((Predicate)e.next());
        }
        e = delAdd[2].iterator();
        while (e.hasNext()) {
            this.addProtection((Predicate)e.next());
        }
    }

    public String toString(JSHOP2 context) {
        StringBuilder stateString = new StringBuilder();
        for (int i = 0; i < this.atoms.length; ++i) {
            if (this.atoms[i].isEmpty()) continue;
            stateString.append(context.getConstant(i).toString(context)).append(":");
            for (int j = 0; j < this.atoms[i].size(); ++j) {
                Term t = (Term)this.atoms[i].get(j);
                stateString.append("\n\t").append(t.toString(context));
            }
            stateString.append("\n");
        }
        return stateString.toString();
    }
}

