/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.external.impl.itsimple;

import cz.cuni.amis.planning4j.external.impl.itsimple.ItSimplePlannerInformation;
import cz.cuni.amis.planning4j.external.impl.itsimple.ItSimpleUtils;
import cz.cuni.amis.planning4j.external.impl.itsimple.SimplePlannerListManager;
import java.io.File;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class PlannerListManager
extends SimplePlannerListManager {
    private final Logger logger = Logger.getLogger(PlannerListManager.class);

    public PlannerListManager(Element plannersXml) {
        super(plannersXml);
    }

    public final void extractAndPreparePlanner(ItSimplePlannerInformation selectedPlanner) {
        this.extractAndPreparePlanner(new File("."), selectedPlanner);
    }

    public void extractAndPreparePlanner(File targetDirectory, ItSimplePlannerInformation selectedPlanner) {
        if (selectedPlanner == null) {
            throw new NullPointerException("Planner can't be null");
        }
        File binaryFile = ItSimpleUtils.getPlannerExecutableFile(targetDirectory, selectedPlanner);
        String plannerRelativeFileName = selectedPlanner.getSettings().getExecutableFilePath();
        String plannerResourcePath = "/" + plannerRelativeFileName;
        ItSimpleUtils.extractFileIfNotExists(binaryFile, plannerResourcePath);
        this.preparePlanner(targetDirectory, selectedPlanner);
    }

    @Override
    public void preparePlanner(File plannersDirectory, ItSimplePlannerInformation selectedPlanner) {
        super.preparePlanner(plannersDirectory, selectedPlanner);
        File plannerFile = ItSimpleUtils.getPlannerExecutableFile(plannersDirectory, selectedPlanner);
        ItSimpleUtils.prepareExecutableForExecution(plannerFile);
    }
}

