/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.external.impl.itsimple;

import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.OsProcess;
import com.jezhumble.javasysmon.ProcessVisitor;
import cz.cuni.amis.planning4j.ActionDescription;
import cz.cuni.amis.planning4j.PlanningException;
import cz.cuni.amis.planning4j.PlanningStatistics;
import cz.cuni.amis.planning4j.external.IExternalPlanningProcess;
import cz.cuni.amis.planning4j.external.IExternalPlanningResult;
import cz.cuni.amis.planning4j.external.impl.ExternalPlanningResult;
import cz.cuni.amis.planning4j.external.impl.itsimple.INoPlanFoundChecker;
import cz.cuni.amis.planning4j.external.impl.itsimple.ItSimplePlannerInformation;
import cz.cuni.amis.planning4j.external.impl.itsimple.PlannerArgument;
import cz.cuni.amis.planning4j.utils.Planning4JUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.log4j.Logger;

public class ItSimplePlanningProcess
implements IExternalPlanningProcess {
    private static final Logger logger = Logger.getLogger(ItSimplePlanningProcess.class);
    public static final int PROCESS_SPAWN_TIMEOUT = 50;
    protected File plannerExecutableFile;
    private ItSimplePlannerInformation chosenPlanner;
    private File plannerBinariesDirectory;
    private File workingDirectory;
    File domainFile;
    File problemFile;
    long timeInIO;
    Process process = null;
    private boolean cancelled = false;
    private int processPid = -1;
    private static final Object spawnProcessMutex = new Object();

    public ItSimplePlanningProcess(ItSimplePlannerInformation chosenPlanner, File plannerBinariesDirectory, File workingDirectory, File domainFile, File problemFile, long timeInIO) {
        this.chosenPlanner = chosenPlanner;
        this.plannerBinariesDirectory = plannerBinariesDirectory;
        this.workingDirectory = workingDirectory;
        this.domainFile = domainFile;
        this.problemFile = problemFile;
        this.timeInIO = timeInIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process spawnPlanner(ProcessBuilder procBuilder, String processCommandFragment) throws IOException {
        Object object = spawnProcessMutex;
        synchronized (object) {
            JavaSysMon monitor = new JavaSysMon();
            DirectPlannerChildVisitor beforeVisitor = new DirectPlannerChildVisitor(processCommandFragment);
            monitor.visitProcessTree(monitor.currentPid(), (ProcessVisitor)beforeVisitor);
            Set<Integer> alreadySpawnedProcesses = beforeVisitor.getPids();
            Process proc = procBuilder.start();
            DirectPlannerChildVisitor afterVisitor = new DirectPlannerChildVisitor(processCommandFragment);
            Set<Integer> newProcesses = afterVisitor.getPids();
            long startTime = System.currentTimeMillis();
            while (newProcesses.isEmpty() && System.currentTimeMillis() - startTime < 50L) {
                monitor.visitProcessTree(monitor.currentPid(), (ProcessVisitor)afterVisitor);
                newProcesses = afterVisitor.getPids();
                newProcesses.removeAll(alreadySpawnedProcesses);
            }
            if (newProcesses.isEmpty()) {
                logger.warn((Object)"There is no new planner PID.");
            } else if (newProcesses.size() > 1) {
                logger.warn((Object)"Multiple new candidate planner PIDs");
            } else {
                this.processPid = newProcesses.iterator().next();
            }
            logger.info((Object)("Spawned planning process. Pid:" + this.processPid));
            return proc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killPlannerByPID() {
        if (this.processPid < 0) {
            logger.warn((Object)"Cannot kill planner by PID. PID not set.");
            return;
        }
        Object object = spawnProcessMutex;
        synchronized (object) {
            logger.info((Object)("Killing planner pid:" + this.processPid));
            JavaSysMon monitor = new JavaSysMon();
            monitor.killProcessTree(this.processPid, false);
        }
    }

    protected boolean isLineAction(String line) {
        if (this.isLineStatistics(line)) {
            return false;
        }
        if (line.contains(":")) {
            return true;
        }
        return line.contains("(") && line.contains(")");
    }

    protected boolean isLineStatistics(String line) {
        return line.trim().startsWith(";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected UnprocessedPlanningResult runPlanner(File domain, File problem) {
        settings = this.chosenPlanner.getSettings();
        plannerRelativeFile = settings.getExecutableFilePath();
        this.plannerExecutableFile = new File(this.plannerBinariesDirectory, plannerRelativeFile);
        if (!this.plannerExecutableFile.exists()) {
            toolMessage = "Could not find selected planner '" + plannerRelativeFile + "' in directory " + this.plannerBinariesDirectory.getAbsolutePath();
            throw new PlanningException(toolMessage);
        }
        commandArguments = new ArrayList<String>();
        commandArguments.add(this.plannerExecutableFile.getAbsolutePath());
        if (!settings.getDomainArgumentName().trim().isEmpty()) {
            commandArguments.add(settings.getDomainArgumentName());
        }
        commandArguments.add(domain.getAbsolutePath());
        if (!settings.getProblemArgumentName().trim().isEmpty()) {
            commandArguments.add(settings.getProblemArgumentName());
        }
        commandArguments.add(problem.getAbsolutePath());
        for (PlannerArgument argument : settings.getAdditionalArguments()) {
            if (!argument.getName().trim().equals("")) {
                commandArguments.add(argument.getName());
            }
            if (argument.getValue().trim().equals("")) continue;
            commandArguments.add(argument.getValue());
        }
        if (settings.isHasOutputFile() && settings.isOutputFileNeedsArgument()) {
            commandArguments.add(settings.getOutputFileArgumentName());
            commandArguments.add(settings.getOutputFile());
        }
        i$ = this;
        synchronized (i$) {
            if (this.cancelled) {
                return null;
            }
            ItSimplePlanningProcess.logger.info((Object)("\n>> Calling planner " + this.chosenPlanner.getName() + " in directory: " + this.workingDirectory.getAbsolutePath()));
            ItSimplePlanningProcess.logger.debug((Object)("Planner arguments:" + commandArguments));
            try {
                builder = new ProcessBuilder(commandArguments);
                builder.directory(this.workingDirectory);
                this.process = this.spawnPlanner(builder, plannerRelativeFile);
            }
            catch (Exception e) {
                message = "Error while running the planner " + this.chosenPlanner.getName() + ". ";
                throw new PlanningException(message, (Throwable)e);
            }
        }
        plannerFoundNoSolution = false;
        sc = new Scanner(this.process.getInputStream());
        if (ItSimplePlanningProcess.logger.isDebugEnabled()) {
            ItSimplePlanningProcess.logger.debug((Object)"Planner console output:");
        }
        consoleOutputBuilder = new StringBuilder();
        unprocessedPlan = new ArrayList<String>();
        unprocessedStatistics = new ArrayList<String>();
        numLinesBeforePlan = settings.getConsoleOutputStartsAfterNLines();
        consoleParseState = settings.getConsoleOutputPlanStartIdentifier() == null || settings.getConsoleOutputPlanStartIdentifier().isEmpty() != false ? EConsoleParseState.COUNTING_TO_PLAN_START : EConsoleParseState.BEGIN;
        block27: while (sc.hasNextLine()) {
            line = sc.nextLine();
            consoleOutputBuilder.append(line).append("\n");
            for (INoPlanFoundChecker checker : settings.getNoPlanFoundCheckers()) {
                if (!checker.processOutputLine(line)) continue;
                plannerFoundNoSolution = true;
            }
            if (ItSimplePlanningProcess.logger.isDebugEnabled()) {
                ItSimplePlanningProcess.logger.debug((Object)line);
            }
            if (settings.isHasOutputFile() || line.trim().isEmpty()) continue;
            if (ItSimplePlanningProcess.logger.isDebugEnabled()) {
                ItSimplePlanningProcess.logger.debug((Object)((Object)consoleParseState + ":" + line));
            }
            switch (1.$SwitchMap$cz$cuni$amis$planning4j$external$impl$itsimple$ItSimplePlanningProcess$EConsoleParseState[consoleParseState.ordinal()]) {
                case 1: {
                    if (!line.contains(settings.getConsoleOutputPlanStartIdentifier())) break;
                    if (numLinesBeforePlan > 0) {
                        consoleParseState = EConsoleParseState.COUNTING_TO_PLAN_START;
                        --numLinesBeforePlan;
                        break;
                    }
                    indexPlanStart = line.indexOf(settings.getConsoleOutputPlanStartIdentifier());
                    firstLine = line.substring(indexPlanStart + settings.getConsoleOutputPlanStartIdentifier().length());
                    if (!this.isLineAction(firstLine)) {
                        unprocessedStatistics.add(firstLine);
                    } else {
                        unprocessedPlan.add(firstLine);
                    }
                    consoleParseState = EConsoleParseState.READING_PLAN;
                    break;
                }
                case 2: {
                    if (numLinesBeforePlan > 0) {
                        --numLinesBeforePlan;
                        break;
                    }
                    consoleParseState = EConsoleParseState.READING_PLAN;
                }
                case 3: {
                    if (!settings.getConsoleOutputPlanEndIdentifier().isEmpty() && line.contains(settings.getConsoleOutputPlanEndIdentifier())) {
                        consoleParseState = EConsoleParseState.END;
                        break;
                    }
                    if (!this.isLineAction(line)) {
                        unprocessedStatistics.add(line);
                        break;
                    }
                    unprocessedPlan.add(line);
                    break;
                }
                case 4: {
                    if (!this.isLineStatistics(line)) break;
                    unprocessedStatistics.add(line);
                    continue block27;
                }
            }
        }
        sc.close();
        if (this.cancelled) {
            line = null;
            i$ = settings.getAdditionalGeneratedFiles().iterator();
        }
        ** GOTO lbl126
        {
            catch (Throwable var19_40) {
                throw var19_40;
            }
            while (i$.hasNext() != false) {
                generatedFileName = (String)i$.next();
                file = new File(this.workingDirectory, generatedFileName);
                if (!file.exists()) continue;
                file.delete();
            }
            return line;
lbl126:
            // 1 sources

            try {
                errorOuput = IOUtils.toString((InputStream)this.process.getErrorStream());
            }
            catch (IOException ex) {
                errorOuput = "Could not get error stream: " + ex.getMessage();
            }
            try {
                if (this.cancelled) {
                    ex = null;
                    i$ = settings.getAdditionalGeneratedFiles().iterator();
                }
                ** GOTO lbl-1000
            }
            catch (InterruptedException ex) {}
            if (this.cancelled) {
                i$ = null;
                i$ = settings.getAdditionalGeneratedFiles().iterator();
                while (i$.hasNext() != false) {
                    generatedFileName = i$.next();
                    file = new File(this.workingDirectory, generatedFileName);
                    if (!file.exists()) continue;
                    file.delete();
                }
                return i$;
            }
            ** try [egrp 8[TRYBLOCK] [11 : 1325->1342)] { 
lbl150:
            // 1 sources

            ItSimplePlanningProcess.logger.info((Object)"Waiting for planner execution interrupted", (Throwable)ex);
            this.destroyProcess();
            return null;
lbl153:
            // 1 sources

            finally {
                i$ = settings.getAdditionalGeneratedFiles().iterator();
                while (true) {
                    if (!i$.hasNext()) {
                    }
                    generatedFileName = i$.next();
                    file = new File(this.workingDirectory, generatedFileName);
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
        }
        while (i$.hasNext() != false) {
            generatedFileName = i$.next();
            file = new File(this.workingDirectory, generatedFileName);
            if (!file.exists()) continue;
            file.delete();
        }
        return ex;
lbl-1000:
        // 1 sources

        {
            this.process.waitFor();
            ItSimplePlanningProcess.logger.info((Object)("\n>> Planner " + this.chosenPlanner.getName() + " finished execution\n "));
        }
        {
            this.process.destroy();
            if (ItSimplePlanningProcess.logger.isDebugEnabled()) {
                ItSimplePlanningProcess.logger.debug((Object)"Planner console output end.");
            }
            if (!this.cancelled) ** GOTO lbl-1000
            ex = null;
            i$ = settings.getAdditionalGeneratedFiles().iterator();
        }
        while (i$.hasNext() != false) {
            generatedFileName = (String)i$.next();
            file = new File(this.workingDirectory, generatedFileName);
            if (!file.exists()) continue;
            file.delete();
        }
        return ex;
lbl-1000:
        // 1 sources

        {
            exitCode = this.process.exitValue();
            for (INoPlanFoundChecker checker : settings.getNoPlanFoundCheckers()) {
                if (!checker.processExitCode(exitCode)) continue;
                plannerFoundNoSolution = true;
            }
            if (exitCode != 0 && !plannerFoundNoSolution) {
                throw new PlanningException("Planner terminated with an error - exit code: " + exitCode + ". Planner output:\n " + consoleOutputBuilder.toString() + "\nError output:\n" + errorOuput);
            }
            if (settings.isHasOutputFile()) {
                solutionFile = "solution.soln";
                if (!settings.getOutputFile().trim().isEmpty()) {
                    solutionFile = settings.getOutputFile();
                }
                if (settings.getOutputFileAutomaticIncrementSuffix() != null) {
                    i = 1;
                    while ((candidateSolutionFile = new File(this.workingDirectory, candidateSolutionFileName = solutionFile + settings.getOutputFileAutomaticIncrementSuffix().replace("#", Integer.toString(i)))).exists()) {
                        solutionFile = candidateSolutionFileName;
                        ++i;
                    }
                }
                if ((outputFile = new File(this.workingDirectory, solutionFile)).exists()) {
                    try {
                        for (String line : FileUtils.readLines((File)outputFile)) {
                            if (line.trim().isEmpty()) continue;
                            if (!this.isLineAction(line)) {
                                unprocessedStatistics.add(line);
                                continue;
                            }
                            unprocessedPlan.add(line);
                        }
                    }
                    catch (IOException ex) {
                        throw new PlanningException("Could not read planner output", (Throwable)ex);
                    }
                    outputFile.delete();
                } else if (!plannerFoundNoSolution) {
                    throw new PlanningException("Could not find the planner output solution file! \n");
                }
            }
            if (!this.cancelled) ** GOTO lbl-1000
            solutionFile = null;
            i$ = settings.getAdditionalGeneratedFiles().iterator();
        }
        while (i$.hasNext() != false) {
            generatedFileName = i$.next();
            file = new File(this.workingDirectory, generatedFileName);
            if (!file.exists()) continue;
            file.delete();
        }
        return solutionFile;
lbl-1000:
        // 3 sources

        {
            for (INoPlanFoundChecker checker : settings.getNoPlanFoundCheckers()) {
                if (!checker.processUnprocessedPlan(unprocessedPlan)) continue;
                plannerFoundNoSolution = true;
            }
            var15_23 = new UnprocessedPlanningResult(unprocessedPlan, unprocessedStatistics, consoleOutputBuilder.toString(), plannerFoundNoSolution == false);
            i$ = settings.getAdditionalGeneratedFiles().iterator();
        }
        while (i$.hasNext() != false) {
            generatedFileName = i$.next();
            file = new File(this.workingDirectory, generatedFileName);
            if (!file.exists()) continue;
            file.delete();
        }
        return var15_23;
    }

    private List<ActionDescription> parsePlanToActionDescription(List<String> plan) {
        ArrayList<ActionDescription> result = new ArrayList<ActionDescription>();
        for (int lineIndex = 0; lineIndex < plan.size(); ++lineIndex) {
            String line = plan.get(lineIndex);
            try {
                String actionInstance;
                ActionDescription action = new ActionDescription();
                int colonIndex = line.indexOf(58);
                if (line.indexOf(40) >= 0) {
                    actionInstance = line.substring(line.indexOf(40) + 1, line.lastIndexOf(41));
                } else if (colonIndex >= 0) {
                    actionInstance = line.substring(colonIndex + 1);
                } else {
                    logger.warn((Object)("Could not determine what is the actual action: " + line));
                    continue;
                }
                StringTokenizer st = new StringTokenizer(actionInstance);
                String actionName = st.nextToken();
                action.setName(Planning4JUtils.normalizeIdentifier((String)actionName));
                ArrayList<String> parameterValues = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String parameterStr = st.nextToken();
                    parameterValues.add(Planning4JUtils.normalizeIdentifier((String)parameterStr));
                }
                action.setParameters(parameterValues);
                String startTimeStr = colonIndex > 0 ? line.substring(0, colonIndex) : new StringTokenizer(line).nextToken();
                if (!startTimeStr.startsWith("(")) {
                    try {
                        action.setStartTime(Double.parseDouble(startTimeStr));
                    }
                    catch (NumberFormatException ex) {
                        logger.warn((Object)("Could not parse action: " + line));
                        continue;
                    }
                }
                String durationStr = "1";
                if (line.indexOf(91) > -1) {
                    durationStr = line.substring(line.indexOf(91) + 1, line.lastIndexOf(93));
                }
                action.setDuration(Double.parseDouble(durationStr));
                action.setNotes("");
                result.add(action);
                continue;
            }
            catch (RuntimeException ex) {
                logger.warn((Object)("Could not parse action: " + line), (Throwable)ex);
            }
        }
        return result;
    }

    private PlanningStatistics parseStatistics(List<String> statistic) {
        PlanningStatistics planningStatistics = new PlanningStatistics();
        for (String line : statistic) {
            String value;
            String keyword;
            if (line.indexOf(32) > -1) {
                keyword = line.substring(0, line.indexOf(32)).trim();
                value = line.substring(line.indexOf(32), line.length()).trim();
            } else {
                keyword = line;
                value = "";
            }
            if (value.isEmpty()) continue;
            if (keyword.equals("Time")) {
                planningStatistics.setTime(Double.parseDouble(value));
                continue;
            }
            if (keyword.equals("ParsingTime")) {
                planningStatistics.setParsingTime(Double.parseDouble(value));
                continue;
            }
            if (keyword.equals("NrActions")) {
                planningStatistics.setNumberOfActions(Integer.parseInt(value));
                continue;
            }
            if (keyword.equals("MakeSpan")) {
                planningStatistics.setMakeSpan(Double.parseDouble(value));
                continue;
            }
            if (keyword.equals("MetricValue")) {
                planningStatistics.setMetricValue(Double.parseDouble(value));
                continue;
            }
            if (keyword.equals("PlanningTechnique")) {
                planningStatistics.setPlanningTechnique(value);
                continue;
            }
            planningStatistics.addAdditionalStat(keyword + " " + value);
        }
        return planningStatistics;
    }

    @Override
    public IExternalPlanningResult executePlanner() {
        long start_time = System.currentTimeMillis() - this.timeInIO;
        if (this.cancelled) {
            return null;
        }
        UnprocessedPlanningResult unprocessedResult = this.runPlanner(this.domainFile, this.problemFile);
        if (this.cancelled) {
            return null;
        }
        PlanningStatistics stats = this.parseStatistics(unprocessedResult.getStatistics());
        List<ActionDescription> actionDescriptions = this.parsePlanToActionDescription(unprocessedResult.getPlan());
        long time = System.currentTimeMillis() - start_time;
        if (this.cancelled) {
            return null;
        }
        return new ExternalPlanningResult(unprocessedResult.isPlanningSuccesful(), actionDescriptions, unprocessedResult.getConsoleOuptut(), stats, time);
    }

    @Override
    public synchronized void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            if (this.process != null) {
                this.destroyProcess();
            }
        }
    }

    public void destroyProcess() {
        if (this.process != null) {
            try {
                this.process.exitValue();
            }
            catch (IllegalThreadStateException ingoredException) {
                InputStream is = this.process.getInputStream();
                InputStream es = this.process.getErrorStream();
                if (this.processPid > 0) {
                    this.killPlannerByPID();
                }
                this.process.destroy();
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)new NullOutputStream());
                }
                catch (IOException ex) {
                    logger.debug((Object)("Error consuming output:" + ex.getMessage()), (Throwable)ex);
                }
                try {
                    IOUtils.copy((InputStream)es, (OutputStream)new NullOutputStream());
                }
                catch (IOException ex) {
                    logger.debug((Object)("Error consuming error output:" + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$cz$cuni$amis$planning4j$external$impl$itsimple$ItSimplePlanningProcess$EConsoleParseState;

        static {
            $SwitchMap$cz$cuni$amis$planning4j$external$impl$itsimple$ItSimplePlanningProcess$EConsoleParseState = new int[EConsoleParseState.values().length];
            try {
                1.$SwitchMap$cz$cuni$amis$planning4j$external$impl$itsimple$ItSimplePlanningProcess$EConsoleParseState[EConsoleParseState.BEGIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$cz$cuni$amis$planning4j$external$impl$itsimple$ItSimplePlanningProcess$EConsoleParseState[EConsoleParseState.COUNTING_TO_PLAN_START.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$cz$cuni$amis$planning4j$external$impl$itsimple$ItSimplePlanningProcess$EConsoleParseState[EConsoleParseState.READING_PLAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$cz$cuni$amis$planning4j$external$impl$itsimple$ItSimplePlanningProcess$EConsoleParseState[EConsoleParseState.END.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    protected static class UnprocessedPlanningResult {
        List<String> plan;
        List<String> statistics;
        String consoleOuptut;
        boolean planningSuccesful;

        public UnprocessedPlanningResult(List<String> plan, List<String> statistics, String consoleOuptut, boolean planningSuccesful) {
            this.plan = plan;
            this.statistics = statistics;
            this.consoleOuptut = consoleOuptut;
            this.planningSuccesful = planningSuccesful;
        }

        public List<String> getPlan() {
            return this.plan;
        }

        public List<String> getStatistics() {
            return this.statistics;
        }

        public String getConsoleOuptut() {
            return this.consoleOuptut;
        }

        public boolean isPlanningSuccesful() {
            return this.planningSuccesful;
        }
    }

    private static enum EConsoleParseState {
        BEGIN,
        COUNTING_TO_PLAN_START,
        READING_PLAN,
        END;

    }

    private static class DirectPlannerChildVisitor
    implements ProcessVisitor {
        Set<Integer> pids = new HashSet<Integer>();
        String processNameFragment;

        public DirectPlannerChildVisitor(String processNameFragment) {
            this.processNameFragment = processNameFragment.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        }

        public boolean visit(OsProcess op, int i) {
            if (op.processInfo().getCommand().contains(this.processNameFragment) || op.processInfo().getName().equals(this.processNameFragment)) {
                this.pids.add(op.processInfo().getPid());
            }
            return false;
        }

        public Set<Integer> getPids() {
            return this.pids;
        }
    }
}

