/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.external.impl.itsimple;

import cz.cuni.amis.planning4j.external.impl.itsimple.EPlannerPlatform;
import cz.cuni.amis.planning4j.external.impl.itsimple.ItSimplePlannerInformation;
import cz.cuni.amis.planning4j.external.impl.itsimple.ItSimplePlanningException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ItSimpleUtils {
    private static final Object fileOperationsMutex = new Object();
    private static final Logger logger = Logger.getLogger(ItSimpleUtils.class);

    public static EPlannerPlatform getOperatingSystem() {
        String operatingSystem = System.getProperty("os.name").toLowerCase();
        if (operatingSystem.indexOf("linux") == 0) {
            return EPlannerPlatform.LINUX;
        }
        if (operatingSystem.indexOf("windows") == 0) {
            return EPlannerPlatform.WINDOWS;
        }
        if (operatingSystem.indexOf("mac") == 0) {
            return EPlannerPlatform.MAC;
        }
        throw new IllegalStateException("Current platform could not be guessed");
    }

    public static File getPlannerExecutableFile(File baseDirectory, ItSimplePlannerInformation chosenPlanner) {
        File plannerExecutableFile = new File(baseDirectory, chosenPlanner.getSettings().getExecutableFilePath());
        return plannerExecutableFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFileIfNotExists(File targetFile, String resourcePath) {
        Object object = fileOperationsMutex;
        synchronized (object) {
            if (!targetFile.exists()) {
                InputStream inputStream = ItSimpleUtils.class.getResourceAsStream(resourcePath);
                if (inputStream == null) {
                    throw new ItSimplePlanningException("Could not find file resource on classpath. Resource path:" + resourcePath);
                }
                if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                    throw new ItSimplePlanningException("Could not create parent dirs for file resource " + targetFile);
                }
                try {
                    FileOutputStream outputfilestream = new FileOutputStream(targetFile);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputfilestream);
                    outputfilestream.close();
                }
                catch (IOException ex) {
                    throw new ItSimplePlanningException("Could not extract file resource to " + targetFile, ex);
                }
            }
        }
    }

    public static void prepareExecutableForExecution(File plannerFile) {
        if (ItSimpleUtils.getOperatingSystem().equals((Object)EPlannerPlatform.LINUX)) {
            try {
                Runtime.getRuntime().exec(new String[]{"chmod", "+x", plannerFile.getAbsolutePath()});
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not set planner file permissions", (Throwable)ex);
            }
        }
    }
}

