/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.spline;

import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import java.util.Collection;
import math.JavaGeomMath;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.domain.ContinuousOrientedCurve2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;

public class QuadBezierCurve2D
extends AbstractSmoothCurve2D
implements SmoothCurve2D,
ContinuousOrientedCurve2D,
Cloneable {
    protected double x1;
    protected double y1;
    protected double ctrlx;
    protected double ctrly;
    protected double x2;
    protected double y2;

    public QuadBezierCurve2D() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public QuadBezierCurve2D(double[][] coefs) {
        this(coefs[0][0], coefs[1][0], coefs[0][0] + coefs[0][1] / 2.0, coefs[1][0] + coefs[1][1] / 2.0, coefs[0][0] + coefs[0][1] + coefs[0][2], coefs[1][0] + coefs[1][1] + coefs[1][2]);
    }

    public QuadBezierCurve2D(java.awt.geom.Point2D p1, java.awt.geom.Point2D ctrl, java.awt.geom.Point2D p2) {
        this(p1.getX(), p1.getY(), ctrl.getX(), ctrl.getY(), p2.getX(), p2.getY());
    }

    public QuadBezierCurve2D(java.awt.geom.Point2D[] pts) {
        this(pts[0].getX(), pts[0].getY(), pts[1].getX(), pts[1].getY(), pts[2].getX(), pts[2].getY());
    }

    public QuadBezierCurve2D(double x1, double y1, double xctrl, double yctrl, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.ctrlx = xctrl;
        this.ctrly = yctrl;
        this.x2 = x2;
        this.y2 = y2;
    }

    public static QuadBezierCurve2D create(Point2D p1, Point2D p2, Point2D p3) {
        return new QuadBezierCurve2D(p1, p2, p3);
    }

    public Point2D getControl() {
        return new Point2D(this.ctrlx, this.ctrly);
    }

    public Point2D getP1() {
        return this.getFirstPoint();
    }

    public Point2D getP2() {
        return this.getLastPoint();
    }

    public Point2D getCtrl() {
        return this.getControl();
    }

    public double[][] getParametric() {
        double[][] tab = new double[2][3];
        tab[0][0] = this.x1;
        tab[0][1] = 2.0 * this.ctrlx - 2.0 * this.x1;
        tab[0][2] = this.x2 - 2.0 * this.ctrlx + this.x1;
        tab[1][0] = this.y1;
        tab[1][1] = 2.0 * this.ctrly - 2.0 * this.y1;
        tab[1][2] = this.y2 - 2.0 * this.ctrly + this.y1;
        return tab;
    }

    @Override
    public double getWindingAngle(java.awt.geom.Point2D point) {
        return this.getAsPolyline(100).getWindingAngle(point);
    }

    @Override
    public boolean isInside(java.awt.geom.Point2D pt) {
        return this.getAsPolyline(100).isInside(pt);
    }

    @Override
    public double getSignedDistance(java.awt.geom.Point2D point) {
        if (this.isInside(point)) {
            return -this.getDistance(point.getX(), point.getY());
        }
        return this.getDistance(point.getX(), point.getY());
    }

    @Override
    public double getSignedDistance(double x, double y) {
        if (this.isInside(new Point2D(x, y))) {
            return -this.getDistance(x, y);
        }
        return this.getDistance(x, y);
    }

    @Override
    public Vector2D getTangent(double t) {
        double[][] c = this.getParametric();
        double dx = c[0][1] + 2.0 * c[0][2] * t;
        double dy = c[1][1] + 2.0 * c[1][2] * t;
        return new Vector2D(dx, dy);
    }

    @Override
    public double getCurvature(double t) {
        double[][] c = this.getParametric();
        double xp = c[0][1] + 2.0 * c[0][2] * t;
        double yp = c[1][1] + 2.0 * c[1][2] * t;
        double xs = 2.0 * c[0][2];
        double ys = 2.0 * c[1][2];
        return (xp * ys - yp * xs) / Math.pow(JavaGeomMath.hypot(xp, yp), 3.0);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public double getT0() {
        return 0.0;
    }

    @Override
    public double getT1() {
        return 1.0;
    }

    @Override
    public Collection<Point2D> getIntersections(LinearShape2D line) {
        return this.getAsPolyline(100).getIntersections(line);
    }

    @Override
    public Point2D getPoint(double t) {
        t = Math.min(Math.max(t, 0.0), 1.0);
        double[][] c = this.getParametric();
        double x = c[0][0] + (c[0][1] + c[0][2] * t) * t;
        double y = c[1][0] + (c[1][1] + c[1][2] * t) * t;
        return new Point2D(x, y);
    }

    @Override
    public Point2D getFirstPoint() {
        return new Point2D(this.x1, this.y1);
    }

    @Override
    public Point2D getLastPoint() {
        return new Point2D(this.x2, this.y2);
    }

    @Override
    public double getPosition(java.awt.geom.Point2D point) {
        int N = 100;
        return this.getAsPolyline(N).getPosition(point) / (double)N;
    }

    @Override
    public double project(java.awt.geom.Point2D point) {
        int N = 100;
        return this.getAsPolyline(N).project(point) / (double)N;
    }

    @Override
    public QuadBezierCurve2D getReverseCurve() {
        return new QuadBezierCurve2D(this.getLastPoint(), this.getControl(), this.getFirstPoint());
    }

    @Override
    public QuadBezierCurve2D getSubCurve(double t0, double t1) {
        if ((t0 = Math.max(t0, 0.0)) > (t1 = Math.min(t1, 1.0))) {
            return null;
        }
        Point2D p0 = this.getPoint(t0);
        Point2D p1 = this.getPoint(t1);
        Vector2D v0 = this.getTangent(t0);
        Vector2D v1 = this.getTangent(t1);
        StraightLine2D tan0 = new StraightLine2D((java.awt.geom.Point2D)p0, v0);
        StraightLine2D tan1 = new StraightLine2D((java.awt.geom.Point2D)p1, v1);
        Point2D control = tan0.getIntersection(tan1);
        return new QuadBezierCurve2D(p0, control, p1);
    }

    @Override
    public boolean contains(double x, double y) {
        return new QuadCurve2D.Double(this.x1, this.y1, this.ctrlx, this.ctrly, this.x2, this.y2).contains(x, y);
    }

    @Override
    public boolean contains(java.awt.geom.Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public double getDistance(java.awt.geom.Point2D p) {
        return this.getDistance(p.getX(), p.getY());
    }

    @Override
    public double getDistance(double x, double y) {
        return this.getAsPolyline(100).getDistance(x, y);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public CurveSet2D<? extends QuadBezierCurve2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curve2DUtils.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<QuadBezierCurve2D> result = new CurveArray2D<QuadBezierCurve2D>(set.getCurveNumber());
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof QuadBezierCurve2D)) continue;
            result.addCurve((QuadBezierCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public Box2D getBoundingBox() {
        Point2D p1 = this.getFirstPoint();
        Point2D p2 = this.getControl();
        Point2D p3 = this.getLastPoint();
        double xmin = Math.min(Math.min(p1.getX(), p2.getX()), p3.getX());
        double xmax = Math.max(Math.max(p1.getX(), p2.getX()), p3.getX());
        double ymin = Math.min(Math.min(p1.getY(), p2.getY()), p3.getY());
        double ymax = Math.max(Math.max(p1.getY(), p2.getY()), p3.getY());
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public QuadBezierCurve2D transform(AffineTransform2D trans) {
        return new QuadBezierCurve2D(trans.transform(this.getFirstPoint()), trans.transform(this.getControl()), trans.transform(this.getLastPoint()));
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        Point2D p2 = this.getControl();
        Point2D p3 = this.getLastPoint();
        path.quadTo(p2.getX(), p2.getY(), p3.getX(), p3.getY());
        return path;
    }

    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        Point2D p1 = this.getFirstPoint();
        Point2D p2 = this.getControl();
        Point2D p3 = this.getLastPoint();
        path.moveTo(p1.getX(), p1.getY());
        path.quadTo(p2.getX(), p2.getY(), p3.getX(), p3.getY());
        return path;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QuadBezierCurve2D)) {
            return false;
        }
        QuadBezierCurve2D bezier = (QuadBezierCurve2D)obj;
        if (Math.abs(this.x1 - bezier.x1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.y1 - bezier.y1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrlx - bezier.ctrlx) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrly - bezier.ctrly) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.x2 - bezier.x2) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(this.y2 - bezier.y2) > 1.0E-12);
    }

    @Override
    public QuadBezierCurve2D clone() {
        return new QuadBezierCurve2D(this.x1, this.y1, this.ctrlx, this.ctrly, this.x2, this.y2);
    }
}

