/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.curve;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.polygon.Polyline2D;

public class PolyCurve2D<T extends ContinuousCurve2D>
extends CurveArray2D<T>
implements ContinuousCurve2D {
    protected boolean closed = false;

    public PolyCurve2D() {
    }

    public PolyCurve2D(int n) {
        super(n);
    }

    public PolyCurve2D(T[] curves) {
        super(curves);
    }

    public PolyCurve2D(T[] curves, boolean closed) {
        super(curves);
        this.closed = closed;
    }

    public PolyCurve2D(Collection<? extends T> curves) {
        super(curves);
    }

    public PolyCurve2D(Collection<? extends T> curves, boolean closed) {
        super(curves);
        this.closed = closed;
    }

    public static <T extends ContinuousCurve2D> PolyCurve2D<T> create(Collection<T> curves) {
        return new PolyCurve2D<T>(curves);
    }

    public static <T extends ContinuousCurve2D> PolyCurve2D<T> create(T[] curves) {
        return new PolyCurve2D(curves);
    }

    protected static <T extends ContinuousCurve2D> Collection<T> wrapCurve(T curve) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(curve);
        return list;
    }

    public void setClosed(boolean b) {
        this.closed = b;
    }

    @Override
    public Vector2D getLeftTangent(double t) {
        return ((ContinuousCurve2D)this.getChildCurve(t)).getLeftTangent(this.getLocalPosition(t));
    }

    @Override
    public Vector2D getRightTangent(double t) {
        return ((ContinuousCurve2D)this.getChildCurve(t)).getRightTangent(this.getLocalPosition(t));
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Polyline2D getAsPolyline(int n) {
        Point2D[] points = new Point2D[n + 1];
        double t0 = this.getT0();
        double t1 = this.getT1();
        double dt = (t1 - t0) / (double)n;
        for (int i = 0; i < n; ++i) {
            points[i] = this.getPoint((double)i * dt + t0);
        }
        return new Polyline2D(points);
    }

    @Override
    public Collection<? extends SmoothCurve2D> getSmoothPieces() {
        ArrayList<SmoothCurve2D> list = new ArrayList<SmoothCurve2D>();
        for (ContinuousCurve2D curve : this.curves) {
            list.addAll(PolyCurve2D.getSmoothCurves(curve));
        }
        return list;
    }

    private static final Collection<SmoothCurve2D> getSmoothCurves(Curve2D curve) {
        ArrayList<SmoothCurve2D> array = new ArrayList<SmoothCurve2D>();
        if (curve instanceof SmoothCurve2D) {
            array.add((SmoothCurve2D)curve);
            return array;
        }
        if (curve instanceof CurveSet2D) {
            for (Curve2D curve2 : ((CurveSet2D)curve).getCurves()) {
                array.addAll(PolyCurve2D.getSmoothCurves(curve2));
            }
            return array;
        }
        if (curve == null) {
            return array;
        }
        System.err.println("could not find smooth parts of curve with class " + curve.getClass().getName());
        return array;
    }

    @Override
    public Collection<? extends PolyCurve2D<?>> getContinuousCurves() {
        return PolyCurve2D.wrapCurve(this);
    }

    @Override
    public PolyCurve2D<? extends ContinuousCurve2D> getReverseCurve() {
        int n = this.curves.size();
        ContinuousCurve2D[] curves2 = new ContinuousCurve2D[n];
        for (int i = 0; i < n; ++i) {
            curves2[i] = (ContinuousCurve2D)((ContinuousCurve2D)this.curves.get(n - 1 - i)).getReverseCurve();
        }
        return new PolyCurve2D(curves2);
    }

    @Override
    public PolyCurve2D<? extends ContinuousCurve2D> getSubCurve(double t0, double t1) {
        if (t1 < t0 & !this.isClosed()) {
            return new PolyCurve2D<T>();
        }
        Curve2D set = super.getSubCurve(t0, t1);
        PolyCurve2D<ContinuousCurve2D> subCurve = new PolyCurve2D<ContinuousCurve2D>(((CurveSet2D)set).getCurveNumber());
        subCurve.setClosed(false);
        for (Curve2D curve : ((CurveSet2D)set).getCurves()) {
            subCurve.addCurve((ContinuousCurve2D)curve);
        }
        return subCurve;
    }

    @Override
    public CurveSet2D<? extends ContinuousCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curve2DUtils.clipCurve(this, box);
        CurveArray2D<ContinuousCurve2D> result = new CurveArray2D<ContinuousCurve2D>(set.getCurveNumber());
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof ContinuousCurve2D)) continue;
            result.addCurve((ContinuousCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public PolyCurve2D<? extends ContinuousCurve2D> transform(AffineTransform2D trans) {
        PolyCurve2D<ContinuousCurve2D> result = new PolyCurve2D<ContinuousCurve2D>();
        for (ContinuousCurve2D curve : this.curves) {
            result.addCurve((ContinuousCurve2D)curve.transform(trans));
        }
        result.setClosed(this.isClosed());
        return result;
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        Point2D point;
        for (ContinuousCurve2D curve : this.getCurves()) {
            point = curve.getPoint(curve.getT0());
            path.lineTo((float)point.getX(), (float)point.getY());
            curve.appendPath(path);
        }
        if (this.closed) {
            point = this.getFirstPoint();
            path.lineTo((float)point.getX(), (float)point.getY());
        }
        return path;
    }

    @Override
    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        if (this.curves.size() == 0) {
            return path;
        }
        Point2D start = this.getFirstPoint();
        path.moveTo((float)start.getX(), (float)start.getY());
        Point2D current = start;
        for (ContinuousCurve2D curve : this.curves) {
            start = curve.getFirstPoint();
            if (start.distance(current) > 1.0E-12) {
                path.lineTo((float)start.getX(), (float)start.getY());
            }
            path = curve.appendPath(path);
            current = start;
        }
        if (this.closed) {
            path.closePath();
        }
        return path;
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(this.getGeneralPath());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CurveSet2D)) {
            return false;
        }
        PolyCurve2D curveSet = (PolyCurve2D)obj;
        if (this.getCurveNumber() != curveSet.getCurveNumber()) {
            return false;
        }
        for (int i = 0; i < this.curves.size(); ++i) {
            if (((ContinuousCurve2D)this.curves.get(i)).equals(curveSet.curves.get(i))) continue;
            return false;
        }
        return true;
    }
}

