/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.spline;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.Vector2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.spline.CubicBezierCurve2D;

@Deprecated
public class BezierCurve2D
extends CubicBezierCurve2D
implements Cloneable {
    private static final long serialVersionUID = 1L;

    public BezierCurve2D() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public BezierCurve2D(double[][] coefs) {
        this(coefs[0][0], coefs[1][0], coefs[0][0] + coefs[0][1] / 3.0, coefs[1][0] + coefs[1][1] / 3.0, coefs[0][0] + 2.0 * coefs[0][1] / 3.0 + coefs[0][2] / 3.0, coefs[1][0] + 2.0 * coefs[1][1] / 3.0 + coefs[1][2] / 3.0, coefs[0][0] + coefs[0][1] + coefs[0][2] + coefs[0][3], coefs[1][0] + coefs[1][1] + coefs[1][2] + coefs[1][3]);
    }

    public BezierCurve2D(Point2D p1, Point2D ctrl1, Point2D ctrl2, Point2D p2) {
        this(p1.getX(), p1.getY(), ctrl1.getX(), ctrl1.getY(), ctrl2.getX(), ctrl2.getY(), p2.getX(), p2.getY());
    }

    public BezierCurve2D(Point2D p1, Vector2D v1, Point2D p2, Vector2D v2) {
        this(p1.getX(), p1.getY(), p1.getX() + v1.getX() / 3.0, p1.getY() + v1.getY() / 3.0, p2.getX() - v2.getX() / 3.0, p2.getY() - v2.getY() / 3.0, p2.getX(), p2.getY());
    }

    public BezierCurve2D(double x1, double y1, double xctrl1, double yctrl1, double xctrl2, double yctrl2, double x2, double y2) {
        super(x1, y1, xctrl1, yctrl1, xctrl2, yctrl2, x2, y2);
    }

    @Override
    public BezierCurve2D getReverseCurve() {
        return new BezierCurve2D((Point2D)this.getP2(), this.getCtrlP2(), (Point2D)this.getCtrlP1(), this.getP1());
    }

    @Override
    public BezierCurve2D getSubCurve(double t0, double t1) {
        if ((t0 = Math.max(t0, 0.0)) > (t1 = Math.min(t1, 1.0))) {
            return null;
        }
        double dt = t1 - t0;
        Vector2D v0 = this.getTangent(t0).times(dt);
        Vector2D v1 = this.getTangent(t1).times(dt);
        return new BezierCurve2D((Point2D)this.getPoint(t0), v0, (Point2D)this.getPoint(t1), v1);
    }

    @Override
    public CurveSet2D<? extends BezierCurve2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curve2DUtils.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveSet2D<BezierCurve2D> result = new CurveSet2D<BezierCurve2D>();
        for (SmoothCurve2D curve : set.getCurves()) {
            if (!(curve instanceof BezierCurve2D)) continue;
            result.addCurve((BezierCurve2D)curve);
        }
        return result;
    }

    @Override
    public BezierCurve2D transform(AffineTransform2D trans) {
        return new BezierCurve2D((Point2D)trans.transform(this.getP1()), trans.transform(this.getCtrlP1()), (Point2D)trans.transform(this.getCtrlP2()), trans.transform(this.getP2()));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CubicCurve2D.Double)) {
            return false;
        }
        CubicCurve2D.Double bezier = (CubicCurve2D.Double)obj;
        if (Math.abs(this.x1 - bezier.x1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.y1 - bezier.y1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrlx1 - bezier.ctrlx1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrly1 - bezier.ctrly1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrlx2 - bezier.ctrlx2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrly2 - bezier.ctrly2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.x2 - bezier.x2) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(this.y2 - bezier.y2) > 1.0E-12);
    }

    @Override
    public BezierCurve2D clone() {
        return new BezierCurve2D(this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2);
    }
}

