/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.line;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CirculinearCurve2DUtils;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.conic.CircleArc2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.transform.CircleInversion2D;

public class Line2D
extends AbstractSmoothCurve2D
implements LinearShape2D,
CirculinearElement2D,
Cloneable {
    public Point2D p1;
    public Point2D p2;

    public static boolean intersects(Line2D line1, Line2D line2) {
        Point2D e1p1 = line1.getFirstPoint();
        Point2D e1p2 = line1.getLastPoint();
        Point2D e2p1 = line2.getFirstPoint();
        Point2D e2p2 = line2.getLastPoint();
        boolean b1 = Point2D.ccw(e1p1, e1p2, e2p1) * Point2D.ccw(e1p1, e1p2, e2p2) <= 0;
        boolean b2 = Point2D.ccw(e2p1, e2p2, e1p1) * Point2D.ccw(e2p1, e2p2, e1p2) <= 0;
        return b1 && b2;
    }

    public Line2D(Point2D point1, Point2D point2) {
        this.p1 = point1;
        this.p2 = point2;
    }

    public Line2D(double x1, double y1, double x2, double y2) {
        this.p1 = new Point2D(x1, y1);
        this.p2 = new Point2D(x2, y2);
    }

    public static Line2D create(Point2D p1, Point2D p2) {
        return new Line2D(p1, p2);
    }

    public Point2D getPoint1() {
        return this.p1;
    }

    public Point2D getPoint2() {
        return this.p2;
    }

    public double getX1() {
        return this.p1.getX();
    }

    public double getY1() {
        return this.p1.getY();
    }

    public double getX2() {
        return this.p2.getX();
    }

    public double getY2() {
        return this.p2.getY();
    }

    public Point2D getOtherPoint(Point2D point) {
        if (point.equals(this.p1)) {
            return this.p2;
        }
        if (point.equals(this.p2)) {
            return this.p1;
        }
        return null;
    }

    public void setPoint1(Point2D point) {
        this.p1 = point;
    }

    public void setPoint2(Point2D point) {
        this.p2 = point;
    }

    public boolean isColinear(LinearShape2D line) {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).isColinear(line);
    }

    public boolean isParallel(LinearShape2D line) {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).isParallel(line);
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        return CirculinearCurve2DUtils.computeBuffer(this, dist);
    }

    @Override
    public Line2D getParallel(double d) {
        double x0 = this.getX1();
        double y0 = this.getY1();
        double dx = this.getX2() - x0;
        double dy = this.getY2() - y0;
        double dd = Math.sqrt(dx * dx + dy * dy);
        return new Line2D(x0 + dy * d / dd, y0 - dx * d / dd, x0 + dx + dy * d / dd, y0 + dy - dx * d / dd);
    }

    @Override
    public double getLength() {
        return this.p1.getDistance(this.p2);
    }

    @Override
    public double getLength(double pos) {
        double dx = this.p2.getX() - this.p1.getX();
        double dy = this.p2.getY() - this.p1.getY();
        return pos * Math.hypot(dx, dy);
    }

    @Override
    public double getPosition(double length) {
        double dx = this.p2.getX() - this.p1.getX();
        double dy = this.p2.getY() - this.p1.getY();
        return length / Math.hypot(dx, dy);
    }

    @Override
    public CirculinearElement2D transform(CircleInversion2D inv) {
        Point2D center = inv.getCenter();
        double r = inv.getRadius();
        Point2D po = new StraightLine2D(this).getProjectedPoint(center);
        double d = this.getDistance(po);
        if (Math.abs(d) < 1.0E-12) {
            Point2D p1 = this.getFirstPoint().transform(inv);
            Point2D p2 = this.getLastPoint().transform(inv);
            return new LineSegment2D((java.awt.geom.Point2D)p1, p2);
        }
        double angle = Angle2D.getHorizontalAngle(center, po);
        double r2 = r * r / d / 2.0;
        Point2D c2 = Point2D.createPolar(center, r2, angle);
        boolean direct = !this.isInside(center);
        double theta1 = Angle2D.getHorizontalAngle(c2, this.p1);
        double theta2 = Angle2D.getHorizontalAngle(c2, this.p2);
        return new CircleArc2D(c2, r2, theta1, theta2, direct);
    }

    public double[][] getParametric() {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).getParametric();
    }

    public double[] getCartesianEquation() {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).getCartesianEquation();
    }

    public double[] getPolarCoefficients() {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).getPolarCoefficients();
    }

    public double[] getSignedPolarCoefficients() {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).getSignedPolarCoefficients();
    }

    @Override
    public double getHorizontalAngle() {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).getHorizontalAngle();
    }

    @Override
    public Point2D getIntersection(LinearShape2D line) {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).getIntersection(line);
    }

    @Override
    public Point2D getOrigin() {
        return this.p1;
    }

    @Override
    public StraightLine2D getSupportingLine() {
        return new StraightLine2D((java.awt.geom.Point2D)this.p1, (java.awt.geom.Point2D)this.p2);
    }

    @Override
    public Vector2D getVector() {
        return new Vector2D(this.p1, this.p2);
    }

    @Override
    public double getSignedDistance(java.awt.geom.Point2D p) {
        return this.getSignedDistance(p.getX(), p.getY());
    }

    @Override
    public double getSignedDistance(double x, double y) {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).getSignedDistance(x, y);
    }

    public Collection<? extends Line2D> getSmoothPieces() {
        ArrayList<Line2D> array = new ArrayList<Line2D>(1);
        array.add(this);
        return array;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public double getDistance(java.awt.geom.Point2D p) {
        return this.getDistance(p.getX(), p.getY());
    }

    @Override
    public double getDistance(double x, double y) {
        StraightLine2D support = new StraightLine2D((java.awt.geom.Point2D)this.p1, (java.awt.geom.Point2D)this.p2);
        Point2D proj = support.getProjectedPoint(x, y);
        if (this.contains(proj)) {
            return proj.distance(x, y);
        }
        double d1 = Math.hypot(this.p1.getX() - x, this.p1.getY() - y);
        double d2 = Math.hypot(this.p2.getX() - x, this.p2.getY() - y);
        return Math.min(d1, d2);
    }

    public StraightLine2D getParallel(Point2D point) {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).getParallel(point);
    }

    public StraightLine2D getPerpendicular(Point2D point) {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).getPerpendicular(point);
    }

    @Override
    public CurveSet2D<? extends Line2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curve2DUtils.clipCurve(this, box);
        CurveArray2D<Line2D> result = new CurveArray2D<Line2D>(set.getCurveNumber());
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof Line2D)) continue;
            result.addCurve((Line2D)curve2D);
        }
        return result;
    }

    @Override
    public Box2D getBoundingBox() {
        return new Box2D(this.p1, this.p2);
    }

    @Override
    public Vector2D getTangent(double t) {
        return new Vector2D(this.p1, this.p2);
    }

    @Override
    public double getCurvature(double t) {
        return 0.0;
    }

    @Override
    public double getWindingAngle(java.awt.geom.Point2D point) {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).getWindingAngle(point);
    }

    @Override
    public boolean isInside(java.awt.geom.Point2D point) {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).getSignedDistance(point) < 0.0;
    }

    @Override
    public double getT0() {
        return 0.0;
    }

    @Override
    public double getT1() {
        return 1.0;
    }

    @Override
    public Point2D getPoint(double t) {
        if (t < 0.0) {
            return null;
        }
        if (t > 1.0) {
            return null;
        }
        double x = this.p1.getX() * (1.0 - t) + this.p2.getX() * t;
        double y = this.p1.getY() * (1.0 - t) + this.p2.getY() * t;
        return new Point2D(x, y);
    }

    @Override
    public Point2D getFirstPoint() {
        return this.p1;
    }

    @Override
    public Point2D getLastPoint() {
        return this.p2;
    }

    @Override
    public double getPosition(java.awt.geom.Point2D point) {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).getPosition(point);
    }

    @Override
    public double project(java.awt.geom.Point2D point) {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).project(point);
    }

    @Override
    public Line2D getReverseCurve() {
        return new Line2D(this.p2, this.p1);
    }

    public Collection<? extends Line2D> getContinuousCurves() {
        return Line2D.wrapCurve(this);
    }

    @Override
    public Line2D getSubCurve(double t0, double t1) {
        if (t0 > t1) {
            return null;
        }
        t0 = Math.max(t0, this.getT0());
        t1 = Math.min(t1, this.getT1());
        return new Line2D(this.getPoint(t0), this.getPoint(t1));
    }

    @Override
    public Collection<Point2D> getIntersections(LinearShape2D line) {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).getIntersections(line);
    }

    @Override
    public Line2D transform(AffineTransform2D trans) {
        return new Line2D(this.p1.transform(trans), this.p2.transform(trans));
    }

    @Override
    public boolean contains(double x, double y) {
        return new LineSegment2D((java.awt.geom.Point2D)this.p1, this.p2).contains(x, y);
    }

    @Override
    public boolean contains(java.awt.geom.Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        path.moveTo((float)this.p1.getX(), (float)this.p1.getY());
        path.lineTo((float)this.p2.getX(), (float)this.p2.getY());
        return path;
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        path.lineTo((float)this.p2.getX(), (float)this.p2.getY());
        return path;
    }

    public String toString() {
        return "Line2D(" + this.p1 + ")-(" + this.p2 + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Line2D)) {
            return false;
        }
        Line2D edge = (Line2D)obj;
        return this.p1.equals(edge.p1) && this.p2.equals(edge.p2);
    }

    @Override
    public Line2D clone() {
        return new Line2D(this.p1.clone(), this.p2.clone());
    }
}

