/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.introspection.jmx;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.Property;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class FolderMBean
implements DynamicMBean {
    protected Folder folder = null;
    MBeanInfo mBeanInfo = null;

    public FolderMBean(Folder folder) {
        this.folder = folder;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            return this.folder.getProperty(attribute).getValue();
        }
        catch (IntrospectionException ex) {
            throw new MBeanException(ex);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.folder.getProperty(attribute.getName()).setValue(attribute.getValue());
        }
        catch (IntrospectionException ex) {
            throw new MBeanException(ex);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attributeList = new AttributeList();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String atr = stringArray[n2];
            try {
                attributeList.add(new Attribute(atr, this.folder.getProperty(atr).getValue()));
            }
            catch (IntrospectionException ex) {
                Logger.getLogger(FolderMBean.class.getName()).log(Level.SEVERE, null, ex);
            }
            ++n2;
        }
        return attributeList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object atr : attributes) {
            try {
                Attribute a = (Attribute)atr;
                keys.add(a.getName());
                this.setAttribute(a);
            }
            catch (Exception ex) {
                Logger.getLogger(FolderMBean.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.getAttributes(keys.toArray(new String[0]));
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.mBeanInfo == null) {
            this.mBeanInfo = new MBeanInfo("FolderMBean", "MBean for introspection folder", this.getAttributeInfos(), null, null, null);
        }
        return this.mBeanInfo;
    }

    MBeanAttributeInfo[] getAttributeInfos() {
        try {
            Property[] props = this.folder.getProperties();
            MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[props.length];
            int i = 0;
            while (i < props.length) {
                Property p = props[i];
                try {
                    attrs[i] = new MBeanAttributeInfo(p.getName(), p.getType().getName(), null, true, true, false);
                }
                catch (IntrospectionException ex) {
                    attrs[i] = new MBeanAttributeInfo(p.getName(), "unknown", null, true, true, false);
                }
                ++i;
            }
            return attrs;
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(FolderMBean.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void registerFolderHierarchyInJMX(MBeanServer mBeanServer, String domain, String path) throws JMException, IntrospectionException {
        ObjectName objectName = ObjectName.getInstance(String.valueOf(domain) + ":type=" + path + ",name=" + this.folder.getName());
        mBeanServer.registerMBean(this, objectName);
        Folder[] folderArray = this.folder.getFolders();
        int n = folderArray.length;
        int n2 = 0;
        while (n2 < n) {
            Folder f = folderArray[n2];
            new FolderMBean(f).registerFolderHierarchyInJMX(mBeanServer, domain, String.valueOf(path) + "." + this.folder.getName());
            ++n2;
        }
    }

    public static void exportFolderHierarchy(Folder folder, MBeanServer mBeanServer, String domain, String rootName) throws JMException, IntrospectionException {
        new FolderMBean(folder).registerFolderHierarchyInJMX(mBeanServer, domain, rootName);
    }
}

