/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.dash;

import cz.cuni.amis.dash.DashPresenterFactory;
import cz.cuni.amis.dash.EngineData;
import cz.cuni.amis.dash.InfoPanel;
import cz.cuni.amis.dash.YaposhEngine;
import cz.cuni.amis.pogamut.sposh.dbg.engine.IDebugEngineListener;
import cz.cuni.amis.pogamut.sposh.dbg.lap.LapBreakpoint;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.pogamut.posh.explorer.ClassCrawler;
import cz.cuni.pogamut.posh.explorer.ClassCrawlerFactory;
import cz.cuni.pogamut.posh.explorer.CrawlerListener;
import cz.cuni.pogamut.posh.explorer.NameMapCrawler;
import cz.cuni.pogamut.shed.presenter.IPresenterFactory;
import cz.cuni.pogamut.shed.widget.LapSceneFactory;
import cz.cuni.pogamut.shed.widget.ShedScene;
import java.awt.BorderLayout;
import java.awt.Container;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JScrollPane;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.windows.TopComponent;

public class DashWindow
extends TopComponent
implements IDebugEngineListener {
    private EngineData engineData;
    private final YaposhEngine engine;
    private IPresenterFactory presenter;
    private ShedScene dashScene;
    private long lastEvaluationFinished = 0L;
    private static int REDRAW_INTERVAL_MS = 50;

    public DashWindow(YaposhEngine engine, String name) {
        this.engine = engine;
        this.setDisplayName(name);
        this.setLayout(new BorderLayout());
        this.setContent(new JScrollPane(new InfoPanel("Waiting to be connected to the engine")));
    }

    @Override
    public void connected() {
        this.setContent(new JScrollPane(new InfoPanel("Connected to the engine, waiting for the plan.")));
    }

    @Override
    public void planRecieved(String name, PoshPlan plan) {
        this.setDisplayName(name);
        ShedScene scene = new ShedScene(plan);
        this.engineData = new EngineData(plan);
        this.presenter = new DashPresenterFactory(this.engine, this.engineData, scene, scene.getPresenter());
        this.dashScene = LapSceneFactory.createDashScene((PoshPlan)plan, (ShedScene)scene, (IPresenterFactory)this.presenter);
        this.setContent(new JScrollPane(this.dashScene.createView()));
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        HashSet<Project> openProjectsSet = new HashSet<Project>(Arrays.asList(openProjects));
        ClassCrawler actionCrawler = ClassCrawlerFactory.createActionCrawler(openProjectsSet);
        NameMapCrawler actionNameCrawler = new NameMapCrawler(scene.getPresenter());
        actionCrawler.addListener((CrawlerListener)actionNameCrawler);
        actionCrawler.crawl();
        ClassCrawler senseCrawler = ClassCrawlerFactory.createSenseCrawler(openProjectsSet);
        NameMapCrawler senseNameCrawler = new NameMapCrawler(scene.getPresenter());
        senseCrawler.addListener((CrawlerListener)senseNameCrawler);
        senseCrawler.crawl();
    }

    @Override
    public void evaluationReached() {
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.lastEvaluationFinished;
        if (this.dashScene != null && elapsedTime > (long)REDRAW_INTERVAL_MS) {
            this.dashScene.validate();
            this.dashScene.repaint();
            this.dashScene.getView().repaint();
        }
    }

    @Override
    public void pathReached(LapPath path) {
    }

    @Override
    public void evaluationFinished() {
        this.lastEvaluationFinished = System.currentTimeMillis();
    }

    @Override
    public void breakpointAdded(LapBreakpoint breakpoint) {
    }

    @Override
    public void breakpointRemoved(LapBreakpoint breakpoint) {
    }

    @Override
    public void disconnected(String message, boolean error) {
        if (error) {
            this.add(new InfoPanel("<html>Error: " + message + "</html>"), "North");
        } else {
            this.add(new InfoPanel(message), "North");
        }
    }

    protected void componentClosed() {
        this.engine.disconnect("The debugging window is being closed.", false);
    }

    public int getPersistenceType() {
        return 2;
    }

    private void setContent(Container container) {
        this.removeAll();
        this.add(container, "Center");
        this.revalidate();
    }
}

