package cz.cuni.amis.dash;

import cz.cuni.amis.pogamut.sposh.dbg.engine.IDebugEngine;
import cz.cuni.amis.pogamut.sposh.dbg.engine.IDebugEngineListener;
import cz.cuni.amis.pogamut.sposh.dbg.lap.LapBreakpoint;
import cz.cuni.amis.pogamut.sposh.elements.*;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenterFactory;
import cz.cuni.pogamut.shed.presenter.PrimitivePresenter;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.*;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.visual.action.WidgetAction;

/**
 * Presenter factory for Dash. This factory creates presenters that use {@link EngineData}
 * as its model.
 *
 * @author Honza
 */
public class DashPresenterFactory implements IPresenterFactory {

    private final YaposhEngine engine;
    private final EngineData engineData;
    private final ShedScene scene;
    private final ShedPresenter presenter;
    /**
     * Presenter for parts that don't require to set presenter for the widget
     */
    private static final IPresenter EMPTY_PRESENTER = new IPresenter() {

        @Override
        public void register() {
        }

        @Override
        public void unregister() {
        }

        @Override
        public Action[] getMenuActions() {
            return null;
        }

        @Override
        public AbstractAcceptAction[] getAcceptProviders() {
            return new AbstractAcceptAction[0];
        }

        @Override
        public WidgetAction getEditAction() {
            return null;
        }
    };

    public DashPresenterFactory(YaposhEngine engine, EngineData engineData, ShedScene scene, ShedPresenter presenter) {
        this.engine = engine;
        this.engineData = engineData;
        this.scene = scene;
        this.presenter = presenter;
    }

    @Override
    public IPresenter createActionPresenter(LapPath actionPath, TriggeredAction action, ShedVariableWidget actionWidget, LapChain actionChain) {
        return new DashActionPresenter(engine, actionPath, scene, presenter, action, actionWidget, actionChain);
    }

    @Override
    public IPresenter createExpandedActionPresenter(TriggeredAction action, ExpandedActionEnvelope envelope, LapChain chain) {
        return EMPTY_PRESENTER;
    }

    @Override
    public IPresenter createSensePresenter(LapPath sensePath, Sense sense, ShedSenseWidget senseWidget, LapChain senseChain) {
        return new DashSensePresenter(engine, sensePath, scene, presenter, sense, senseWidget, senseChain);
    }

    @Override
    public <TRIGGER_PARENT extends PoshElement> IPresenter createTriggerPresenter(TRIGGER_PARENT parent, Trigger<TRIGGER_PARENT> trigger, ShedTriggerEnvelope triggerEnvelope, LapChain chain) {
        return EMPTY_PRESENTER;
    }

    @Override
    public IPresenter createDriveCollectionPresenter(LapPath driveCollectionPath, DriveCollection driveCollection) {
        return EMPTY_PRESENTER;
    }

    @Override
    public IPresenter createActionPatternPresenter(LapPath actionPatternPath, TriggeredAction referencingAction, ActionPattern actionPattern, ShedVariableWidget actionPatternWidget, LapChain chain) {
        return new WidgetDummyPresenter(engine, actionPatternPath, actionPatternWidget);
    }

    @Override
    public IPresenter createCompetencePresenter(LapPath competencePath, TriggeredAction referencingAction, Competence competence, ShedVariableWidget competenceWidget, LapChain chain) {
        return new WidgetDummyPresenter(engine, competencePath, competenceWidget);
    }

    @Override
    public IPresenter createChoicePresenter(LapPath competencePath, CompetenceElement choice, ShedVariableWidget choiceWidget) {
        return new WidgetDummyPresenter(engine, competencePath, choiceWidget);
    }

    @Override
    public IPresenter createDrivePresenter(LapPath drivePath, DriveElement drive, ShedVariableWidget widget) {
        return new WidgetDummyPresenter(engine, drivePath, widget);
    }

    @Override
    public IPresenter createActionsPresenter(LapPath actionPatternPath, ActionPattern actionPattern, ShedActionsEnvelope actionsEnvelope, LapChain chain) {
        return EMPTY_PRESENTER;
    }

    @Override
    public IPresenter createChoicesPresenter(LapPath competencePath, Competence competence, ShedChoicesEnvelope choicesEnvelope, LapChain chain) {
        return EMPTY_PRESENTER;
    }
}

/**
 * {@link ShedWidget} requires {@link IPresenter} because it provides menu
 * actions and so on. The provider is set during {@link #register() } method.
 *
 * @author Honza
 */
class WidgetDummyPresenter implements IPresenter, IDebugEngineListener {

    private final IDebugEngine engine;
    private final LapPath path;
    private final ShedVariableWidget widget;

    public WidgetDummyPresenter(IDebugEngine engine, LapPath path, ShedVariableWidget widget) {
        this.engine = engine;
        this.path = path;
        this.widget = widget;
    }

    @Override
    public void register() {
        widget.setPresenter(this);
        engine.addListener(this);
    }

    @Override
    public void unregister() {
        engine.removeListener(this);
        widget.setPresenter(null);
    }

    @Override
    public Action[] getMenuActions() {
        return null;
    }

    @Override
    public AbstractAcceptAction[] getAcceptProviders() {
        return null;
    }

    @Override
    public WidgetAction getEditAction() {
        return null;
    }

    @Override
    public void connected() {
    }

    @Override
    public void planRecieved(String name, PoshPlan plan) {
    }

    private boolean pathReached = false;
    private int intensity = 0;

    @Override
    public void evaluationReached() {
        pathReached = false;
    }

    @Override
    public void pathReached(LapPath reachedPath) {
        if (reachedPath.equals(path)) {
            pathReached = true;
            intensity = 100;
            widget.setActiveIntensity(intensity);
        }
    }

    @Override
    public void evaluationFinished() {
        if (!pathReached) {
            if (intensity > 50) {
                intensity = 50;
            } else {
                intensity -= 5;
            }
            
            intensity = Math.max(0, intensity);
            intensity = Math.min(intensity, 100);
            widget.setActiveIntensity(intensity);
        }
    }

    @Override
    public void breakpointAdded(LapBreakpoint bp) {
    }

    @Override
    public void breakpointRemoved(LapBreakpoint bp) {
    }

    @Override
    public void disconnected(String message, boolean error) {
    }
}
