/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.dash;

import cz.cuni.amis.pogamut.sposh.dbg.engine.IDebugEngine;
import cz.cuni.amis.pogamut.sposh.dbg.engine.IDebugEngineListener;
import cz.cuni.amis.pogamut.sposh.dbg.lap.LapBreakpoint;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.shed.presenter.PrimitivePresenter;
import cz.cuni.pogamut.shed.presenter.ShedMenuActionFactory;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedVariableWidget;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;

public abstract class DashPrimitivePresenter<PRIMITIVE_TYPE extends PoshElement>
extends PrimitivePresenter<PRIMITIVE_TYPE>
implements IDebugEngineListener {
    private final IDebugEngine engine;
    private final LapPath primitivePath;
    private boolean pathReached = false;
    private int intensity = 0;

    public DashPrimitivePresenter(IDebugEngine engine, LapPath primitivePath, ShedScene scene, ShedPresenter presenter, PRIMITIVE_TYPE primitive, ShedVariableWidget primitiveWidget, LapChain primitiveChain) {
        super(scene, presenter, primitive, primitiveWidget, primitiveChain);
        this.engine = engine;
        this.primitivePath = primitivePath;
    }

    public void register() {
        super.register();
        this.engine.addListener(this);
    }

    public void unregister() {
        this.engine.removeListener(this);
        super.unregister();
    }

    public Action[] getMenuActions() {
        return new Action[]{new AbstractAction("Add single breakpoint"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashPrimitivePresenter.this.engine.addBreakpoint(DashPrimitivePresenter.this.primitivePath, true);
            }
        }, new AbstractAction("Add permanent breakpoint"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashPrimitivePresenter.this.engine.addBreakpoint(DashPrimitivePresenter.this.primitivePath, false);
            }
        }, new AbstractAction("Remove breakpoint"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashPrimitivePresenter.this.engine.removeBreakpoint(DashPrimitivePresenter.this.primitivePath);
            }
        }, ShedMenuActionFactory.goToSourceAction((PoshElement)this.primitive)};
    }

    public AbstractAcceptAction[] getAcceptProviders() {
        return new AbstractAcceptAction[0];
    }

    public void propertyChange(PropertyChangeEvent evt) {
        throw new IllegalStateException("Dash doesn't allow changes of the tree.");
    }

    public WidgetAction getEditAction() {
        return ActionFactory.createEditAction((EditProvider)new EditProvider(){

            public void edit(Widget widget) {
                ShedMenuActionFactory.goToSourceAction((PoshElement)DashPrimitivePresenter.this.primitive).actionPerformed(null);
            }
        });
    }

    @Override
    public void connected() {
    }

    @Override
    public void planRecieved(String name, PoshPlan plan) {
    }

    @Override
    public void evaluationReached() {
        this.pathReached = false;
    }

    @Override
    public void pathReached(LapPath path) {
        if (path.equals((Object)this.primitivePath)) {
            this.pathReached = true;
            this.intensity = 100;
            this.primitiveWidget.setActiveIntensity(this.intensity);
        }
    }

    @Override
    public void evaluationFinished() {
        if (!this.pathReached) {
            this.intensity = this.intensity > 50 ? 50 : (this.intensity -= 5);
            this.intensity = Math.max(0, this.intensity);
            this.intensity = Math.min(this.intensity, 100);
            this.primitiveWidget.setActiveIntensity(this.intensity);
        }
    }

    @Override
    public void breakpointAdded(LapBreakpoint bp) {
        if (this.primitivePath.equals((Object)bp.getPath())) {
            this.primitiveWidget.addBreakpoint(bp.isSingle());
        }
    }

    @Override
    public void breakpointRemoved(LapBreakpoint bp) {
        if (this.primitivePath.equals((Object)bp.getPath())) {
            this.primitiveWidget.removeBreakpoint();
        }
    }

    @Override
    public void disconnected(String message, boolean error) {
    }
}

